/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.administration;

import com.evermind.io.IOUtils;
import com.evermind.naming.ContextRemote;
import com.evermind.naming.DefaultContextRemote;
import com.evermind.server.Application;
import com.evermind.server.DataSourceConfig;
import com.evermind.server.XMLDataSourcesConfig;
import com.evermind.server.administration.ApplicationAdministrator;
import com.evermind.server.administration.ApplicationClientAdministrator;
import com.evermind.server.administration.DataSourceRuntimeInfo;
import com.evermind.server.administration.DefaultApplicationClientAdministrator;
import com.evermind.server.administration.DefaultUserAdministrator;
import com.evermind.server.administration.UserAdministrator;
import com.evermind.server.deployment.ApplicationClientArchive;
import com.evermind.server.deployment.ClientModule;
import com.evermind.server.deployment.EJBModule;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.MailSessionInfo;
import com.evermind.server.deployment.Module;
import com.evermind.server.deployment.WebModule;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.administration.DefaultEJBPackageAdministrator;
import com.evermind.server.ejb.administration.EJBPackageAdministrator;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.http.administration.DefaultHttpApplicationAdministrator;
import com.evermind.server.http.administration.HttpApplicationAdministrator;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.administration.DefaultJMSServerAdministrator;
import com.evermind.server.jms.administration.JMSServerAdministrator;
import com.evermind.sql.SerializableRowSet;
import com.evermind.util.ConfigUtils;
import com.evermind.util.ErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import oracle.classloader.util.PathElement;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceBaseConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourcesConfig;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.config.NativeDataSourceConfig;
import oracle.oc4j.sql.config.legacy.LegacyDataSourcesConfig;

public class DefaultApplicationAdministrator
implements ApplicationAdministrator {
    private Application application;

    public DefaultApplicationAdministrator(Application application) {
        this.application = application;
    }

    public void restart() throws InstantiationException {
        EnterpriseArchive config = (EnterpriseArchive)this.application.getConfig();
        if (config != null) {
            config.update();
        }
        this.application.setConfig(config);
        this.application.resetHttpApplications();
    }

    public Map getModules(ErrorHandler errorHandler) throws InstantiationException {
        try {
            Module module;
            HashMap<String, Remote> modules = new HashMap<String, Remote>();
            Iterator iterator = this.application.getConfig().getEJBPackages().iterator();
            while (iterator.hasNext()) {
                module = (EJBModule)iterator.next();
                EJBPackageDeployment deployment = this.application.getEJBContainer().getEJBPackage((EJBModule)module);
                modules.put(module.getPath(), new DefaultEJBPackageAdministrator(this.application.getEJBContainer(), deployment));
            }
            iterator = this.application.getConfig().getWebApplications().iterator();
            while (iterator.hasNext()) {
                module = (WebModule)iterator.next();
                modules.put(((WebModule)module).getPath(), new DefaultHttpApplicationAdministrator(null, this.application.getHttpApplicationConfig(module.getName())));
            }
            iterator = this.application.getConfig().getClients().iterator();
            while (iterator.hasNext()) {
                module = (ClientModule)iterator.next();
                modules.put(((ClientModule)module).getPath(), new DefaultApplicationClientAdministrator(this.application, (ClientModule)module, this.application.getConfig().getClientArchive(((ClientModule)module).getPath(), Thread.currentThread().getContextClassLoader())));
            }
            return modules;
        }
        catch (IOException e) {
            throw new InstantiationException("IO Error: " + e.getMessage());
        }
    }

    public DataSourceRuntimeInfo[] getDataSourceInfo() throws InstantiationException {
        return new DataSourceRuntimeInfo[0];
    }

    public void flushEJBCache(String path) {
        throw new UnsupportedOperationException();
    }

    public List getCMPDataSourceNames() throws InstantiationException {
        return new ArrayList();
    }

    public List getMailSessions() {
        return this.application.getConfig().getMailSessions();
    }

    public List getDataSources() throws RemoteException {
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RowSet executeSQL(String dataSource, String sql) throws SQLException, RemoteException {
        try {
            DataSource source = (DataSource)this.application.getContext().lookup(dataSource);
            Connection connection = source.getConnection();
            try {
                if ("listTables".equalsIgnoreCase(sql)) {
                    ResultSet set = connection.getMetaData().getTables(null, null, "%", new String[]{"TABLE", "VIEW"});
                    SerializableRowSet rowSet = new SerializableRowSet(set, sql, dataSource, null);
                    set.close();
                    SerializableRowSet serializableRowSet = rowSet;
                    return serializableRowSet;
                }
                Statement statement = connection.createStatement();
                ResultSet set = statement.executeQuery(sql);
                SerializableRowSet rowSet = new SerializableRowSet(set, sql, dataSource, null);
                set.close();
                statement.close();
                SerializableRowSet serializableRowSet = rowSet;
                return serializableRowSet;
            }
            finally {
                connection.close();
            }
        }
        catch (NamingException e) {
            throw new OracleRemoteException("Naming error: " + e.getMessage(), e);
        }
    }

    public UserAdministrator getUserAdministrator() {
        return new DefaultUserAdministrator(this.application.getUserManager());
    }

    public void addMailSession(MailSessionInfo info) throws InstantiationException, IOException {
        this.application.getConfig().addMailSession(info);
        ((EnterpriseArchive)this.application.getConfig()).storeDeployment();
        this.application.setConfig(this.application.getConfig());
    }

    public void removeMailSession(String location) throws InstantiationException, IOException {
        this.application.getConfig().removeMailSession(location);
        ((EnterpriseArchive)this.application.getConfig()).storeDeployment();
        this.application.setConfig(this.application.getConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void copyTable(Map from, Map to) throws NamingException, SQLException, InstantiationException {
        debug = false;
        try {
            fromSourceName = (String)from.get("<data-source>");
            toSourceName = (String)to.get("<data-source>");
            fromSource = (DataSource)this.application.getContext().lookup(fromSourceName);
            toSource = (DataSource)this.application.getContext().lookup(toSourceName);
            fromSchema = this.application.getDatabaseSchema(fromSourceName);
            toSchema = this.application.getDatabaseSchema(toSourceName);
            if (debug) {
                System.out.println("toSchema: " + toSchema);
            }
            if (debug) {
                System.out.println("Copying from " + fromSourceName + ":" + from.get("<table-name>") + " to " + toSourceName + ":" + to.get("<table-name>"));
            }
            fromConnection = fromSource.getConnection();
            toConnection = toSource.getConnection();
            try {
                if (debug) {
                    System.out.println("A");
                }
                createTableStatement = new StringBuffer();
                try {
                    fromMetaData = fromConnection.getMetaData();
                    fromMetaDataResultSet = fromMetaData.getColumns(null, null, (String)from.get("<table-name>"), null);
                    createTableStatement.append((Object)("CREATE TABLE " + to.get("<table-name>") + " (\n"));
                    if (debug) {
                        System.out.println("B");
                    }
                    first = false;
                    while (fromMetaDataResultSet.next()) {
                        if (debug) {
                            System.out.println("C");
                        }
                        if (first) {
                            createTableStatement.append(", ");
                        }
                        first = true;
                        if (debug) {
                            System.out.println("Names: ");
                            for (i = 1; i < fromMetaDataResultSet.getMetaData().getColumnCount() + 1; ++i) {
                                System.out.println(fromMetaDataResultSet.getMetaData().getCatalogName(i));
                            }
                        }
                        columnName = fromMetaDataResultSet.getString("COLUMN_NAME");
                        columnTypeID = fromMetaDataResultSet.getInt("DATA_TYPE");
                        columnSize = fromMetaDataResultSet.getInt("COLUMN_SIZE");
                        switch (columnTypeID) {
                            case -5: {
                                columnType = DatabaseSchema.getDatabaseType("long");
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                columnType = DatabaseSchema.getDatabaseType("java.io.Serializable");
                                break;
                            }
                            case -7: {
                                columnType = DatabaseSchema.getDatabaseType("boolean");
                                break;
                            }
                            case 2004: {
                                columnType = DatabaseSchema.getDatabaseType("java.sql.Blob");
                                break;
                            }
                            case 1: {
                                columnType = "char(" + columnSize + ")";
                                break;
                            }
                            case 2005: {
                                columnType = DatabaseSchema.getDatabaseType("java.sql.Clob");
                                break;
                            }
                            case 91: {
                                columnType = DatabaseSchema.getDatabaseType("java.util.Date");
                                break;
                            }
                            case 3: 
                            case 6: {
                                columnType = DatabaseSchema.getDatabaseType("float");
                                break;
                            }
                            case 2: 
                            case 7: 
                            case 8: {
                                columnType = DatabaseSchema.getDatabaseType("double");
                                break;
                            }
                            case 4: {
                                columnType = DatabaseSchema.getDatabaseType("int");
                                break;
                            }
                            case 2000: {
                                columnType = DatabaseSchema.getDatabaseType("java.io.Serializable");
                                break;
                            }
                            case -1: {
                                columnType = DatabaseSchema.getDatabaseType("java.sql.Clob");
                                break;
                            }
                            case 5: {
                                columnType = DatabaseSchema.getDatabaseType("short");
                                break;
                            }
                            case 92: {
                                columnType = DatabaseSchema.getDatabaseType("java.util.Date");
                                break;
                            }
                            case 93: {
                                columnType = DatabaseSchema.getDatabaseType("java.util.Date");
                                break;
                            }
                            case -6: {
                                columnType = DatabaseSchema.getDatabaseType("byte");
                                break;
                            }
                            case 12: {
                                type = DatabaseSchema.getDatabaseType("java.lang.String");
                                if (type == null) {
                                    throw new SQLException("String type not supported by target source");
                                }
                                if (type.indexOf(40) >= 0) {
                                    type = type.substring(0, type.lastIndexOf(40));
                                }
                                if (columnSize <= 0) {
                                    columnSize = 255;
                                }
                                columnType = type + "(" + columnSize + ")";
                                break;
                            }
                            default: {
                                columnType = "varchar(255)";
                            }
                        }
                        if (columnType == null) {
                            throw new SQLException("Unsupported SQL type for the target source for column " + columnName);
                        }
                        columnExtra = "";
                        createTableStatement.append((Object)(columnName + " " + columnType + " " + columnExtra));
                    }
                    createTableStatement.append(")");
                    if (debug) {
                        System.out.println("Creating:  " + createTableStatement);
                    }
                    statement = toConnection.createStatement();
                    statement.execute(createTableStatement.toString());
                    statement.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                if (debug) {
                    System.out.println("D");
                }
                fromStatement = fromConnection.createStatement();
                fromResultSet = fromStatement.executeQuery("SELECT * FROM " + from.get("<table-name>"));
                try {
                    meta = fromResultSet.getMetaData();
                }
                catch (SQLException e) {
                    throw new SQLException("Error retrieving ResultSetMetaData from source ResultSet: " + e.getMessage());
                }
                columns = new ArrayList<String>();
                for (i = 1; i <= meta.getColumnCount(); ++i) {
                    columns.add(meta.getColumnLabel(i));
                }
                colsSQL = new StringBuffer();
                placeHolders = new StringBuffer();
                for (i = 0; i < columns.size(); ++i) {
                    colsSQL.append(columns.get(i));
                    placeHolders.append('?');
                    if (i >= columns.size() - 1) continue;
                    colsSQL.append(", ");
                    placeHolders.append(", ");
                }
                if (debug) {
                    System.out.println("E");
                }
                insertSQL = "INSERT INTO " + to.get("<table-name>") + " (" + colsSQL + ") VALUES (" + placeHolders + ")";
                try {
                    toStatement = toConnection.prepareStatement(insertSQL);
                }
                catch (SQLException e) {
                    throw new SQLException("Error creating destination insert PreparedStatement (" + insertSQL + "): " + e.getMessage());
                }
                if (debug) {
                    System.out.println("F");
                }
                while (fromResultSet.next()) {
                    if (debug) {
                        System.out.println("G");
                    }
                    try {
                        toStatement.clearParameters();
                    }
                    catch (SQLException e) {
                        throw new SQLException("Error clearing destination PreparedStatement: " + e.getMessage());
                    }
                    block112: for (y = 1; y <= meta.getColumnCount(); ++y) {
                        if (debug) {
                            System.out.println("H");
                        }
                        switch (meta.getColumnType(y)) {
                            case -5: {
                                if (debug) {
                                    System.out.println("BIGINT");
                                }
                                try {
                                    value = fromResultSet.getLong(y);
                                }
                                catch (SQLException e) {
                                    throw new SQLException("Error calling ResultSet.getLong(...) on the source: " + e.getMessage());
                                }
                                try {
                                    if (fromResultSet.wasNull()) {
                                        toStatement.setNull(y, -5);
                                        continue block112;
                                    }
                                    toStatement.setLong(y, value);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (fromResultSet.wasNull()) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.BIGINT) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setBigDecimal(...) on the destination: " + e.getMessage());
                                }
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 2004: {
                                try {
                                    if (debug) {
                                        System.out.println("BINARY");
                                    }
                                    try {
                                        data = IOUtils.getContent(fromResultSet.getBinaryStream(y));
                                    }
                                    catch (SQLException e) {
                                        throw new SQLException("Error calling ResultSet.getBinaryStream(...) on the source: " + e.getMessage());
                                    }
                                    try {
                                        toStatement.setBinaryStream(y, (InputStream)new ByteArrayInputStream(data), data.length);
                                        ** break;
                                    }
                                    catch (SQLException e) {
                                        throw new SQLException("Error calling PreparedStatement.setBinaryStream(...) on the destination: " + e.getMessage());
lbl217:
                                        // 1 sources

                                        continue block112;
                                    }
                                }
                                catch (IOException e) {
                                    throw new SQLException("IO Error piping binary stream: " + e);
                                }
                            }
                            case -7: {
                                if (debug) {
                                    System.out.println("BIT");
                                }
                                try {
                                    value = fromResultSet.getBoolean(y);
                                }
                                catch (SQLException e) {
                                    throw new SQLException("Error calling ResultSet.getBoolean(...) on the source: " + e.getMessage());
                                }
                                try {
                                    if (fromResultSet.wasNull()) {
                                        toStatement.setNull(y, -7);
                                        continue block112;
                                    }
                                    toStatement.setBoolean(y, value);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (fromResultSet.wasNull()) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.BIT) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setBoolean(...) on the destination: " + e.getMessage());
                                }
                            }
                            case 1: {
                                if (debug) {
                                    System.out.println("CHAR");
                                }
                                try {
                                    value = fromResultSet.getString(y);
                                }
                                catch (SQLException e) {
                                    throw new SQLException("Error calling ResultSet.getBigDecimal(...) on the source: " + e.getMessage());
                                }
                                try {
                                    if (fromResultSet.wasNull()) {
                                        toStatement.setNull(y, 1);
                                        continue block112;
                                    }
                                    toStatement.setString(y, value);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (value == null) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.CHAR) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setString(...) on the destination: " + e.getMessage());
                                }
                            }
                            case -1: 
                            case 2005: {
                                try {
                                    if (debug) {
                                        System.out.println("CLOB");
                                    }
                                    try {
                                        reader = fromResultSet.getCharacterStream(y);
                                    }
                                    catch (SQLException e) {
                                        throw new SQLException("Error calling ResultSet.getCharacterStream(...) on the source: " + e.getMessage());
                                    }
                                    try {
                                        if (reader == null) {
                                            toStatement.setNull(y, -1);
                                            ** break;
                                        }
                                        data = IOUtils.getContent(reader);
                                        toStatement.setCharacterStream(y, (Reader)new CharArrayReader(data), data.length);
                                        ** break;
                                    }
                                    catch (SQLException e) {
                                        if (reader == null) {
                                            throw new SQLException("Error calling PreparedStatement.setNull(..., Types.LONGVARCHAR) on the destination: " + e.getMessage());
                                        }
                                        throw new SQLException("Error calling PreparedStatement.setCharacterStream(...) on the destination: " + e.getMessage());
lbl276:
                                        // 2 sources

                                        continue block112;
                                    }
                                }
                                catch (IOException e) {
                                    throw new SQLException("IO Error piping character stream: " + e);
                                }
                            }
                            case 91: {
                                if (debug) {
                                    System.out.println("DATE");
                                }
                                date = fromResultSet.getDate(y);
                                try {
                                    if (fromResultSet.wasNull()) {
                                        toStatement.setNull(y, 91);
                                        continue block112;
                                    }
                                    toStatement.setDate(y, date);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (date == null) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.DATE) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setDate(...) on the destination: " + e.getMessage());
                                }
                            }
                            case 3: 
                            case 6: {
                                if (debug) {
                                    System.out.println("FLOAT/DECIMAL");
                                }
                                value = fromResultSet.getFloat(y);
                                try {
                                    if (fromResultSet.wasNull()) {
                                        toStatement.setNull(y, 6);
                                        continue block112;
                                    }
                                    toStatement.setFloat(y, value);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (fromResultSet.wasNull()) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.FLOAT) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setFloat(...) on the destination: " + e.getMessage());
                                }
                            }
                            case 2: 
                            case 7: 
                            case 8: {
                                if (debug) {
                                    System.out.println("DOUBLE/NUMERIC/REAL");
                                }
                                value = fromResultSet.getDouble(y);
                                try {
                                    if (fromResultSet.wasNull()) {
                                        toStatement.setNull(y, 8);
                                        continue block112;
                                    }
                                    toStatement.setDouble(y, value);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (fromResultSet.wasNull()) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.DOUBLE) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setDouble(...) on the destination: " + e.getMessage());
                                }
                            }
                            case 4: {
                                if (debug) {
                                    System.out.println("INTEGER");
                                }
                                value = fromResultSet.getInt(y);
                                try {
                                    if (fromResultSet.wasNull()) {
                                        toStatement.setNull(y, 4);
                                        continue block112;
                                    }
                                    toStatement.setInt(y, value);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (fromResultSet.wasNull()) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.INTEGER) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setInt(...) on the destination: " + e.getMessage());
                                }
                            }
                            case 2000: {
                                if (debug) {
                                    System.out.println("OBJECT");
                                }
                                try {
                                    object = fromResultSet.getObject(y);
                                }
                                catch (SQLException e) {
                                    throw new SQLException("Error calling ResultSet.getObject(...) on the source: " + e.getMessage());
                                }
                                try {
                                    if (object == null) {
                                        toStatement.setNull(y, 2000);
                                        continue block112;
                                    }
                                    toStatement.setObject(y, object);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (object == null) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.JAVA_OBJECT) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setObject(...) on the destination: " + e.getMessage());
                                }
                            }
                            case 5: {
                                if (debug) {
                                    System.out.println("SMALLINT");
                                }
                                value = fromResultSet.getShort(y);
                                try {
                                    if (fromResultSet.wasNull()) {
                                        toStatement.setNull(y, 5);
                                        continue block112;
                                    }
                                    toStatement.setShort(y, value);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (fromResultSet.wasNull()) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.SMALLINT) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setShort(...) on the destination: " + e.getMessage());
                                }
                            }
                            case 92: {
                                if (debug) {
                                    System.out.println("TIME");
                                }
                                time = fromResultSet.getTime(y);
                                try {
                                    if (time == null) {
                                        toStatement.setNull(y, 92);
                                        continue block112;
                                    }
                                    toStatement.setTime(y, time);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (time == null) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.TIME) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setTime(...) on the destination: " + e.getMessage());
                                }
                            }
                            case 93: {
                                if (debug) {
                                    System.out.println("TIMESTAMP");
                                }
                                time = fromResultSet.getTimestamp(y);
                                try {
                                    if (time == null) {
                                        toStatement.setNull(y, 93);
                                        continue block112;
                                    }
                                    toStatement.setTimestamp(y, time);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (time == null) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.TIMESTAMP) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setTimestamp(...) on the destination: " + e.getMessage());
                                }
                            }
                            case -6: {
                                if (debug) {
                                    System.out.println("TINYINT");
                                }
                                value = fromResultSet.getByte(y);
                                try {
                                    if (fromResultSet.wasNull()) {
                                        toStatement.setNull(y, -6);
                                        continue block112;
                                    }
                                    toStatement.setByte(y, value);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (fromResultSet.wasNull()) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.TINYINT) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setByte(...) on the destination: " + e.getMessage());
                                }
                            }
                            case 12: {
                                if (debug) {
                                    System.out.println("VARCHAR");
                                }
                                value = fromResultSet.getString(y);
                                if (debug) {
                                    System.out.println("VARCHAR VALUE: " + value);
                                }
                                try {
                                    if (fromResultSet.wasNull() || value == null) {
                                        toStatement.setNull(y, 12);
                                        continue block112;
                                    }
                                    toStatement.setString(y, value);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    if (value == null) {
                                        throw new SQLException("Error calling PreparedStatement.setNull(..., Types.VARCHAR) on the destination: " + e.getMessage());
                                    }
                                    throw new SQLException("Error calling PreparedStatement.setString(...) on the destination: " + e.getMessage());
                                }
                            }
                            default: {
                                if (debug) {
                                    System.out.println("DEFAULT");
                                }
                                try {
                                    serializable = fromResultSet.getObject(y);
                                }
                                catch (SQLException e) {
                                    throw new SQLException("Error calling ResultSet.getObject(...) on the source: " + e.getMessage());
                                }
                                try {
                                    toStatement.setObject(y, serializable);
                                    continue block112;
                                }
                                catch (SQLException e) {
                                    throw new SQLException("Error calling PreparedStatement.setObject(...) on the destination: " + e.getMessage());
                                }
                            }
                        }
                    }
                    toStatement.executeUpdate();
                }
                fromResultSet.close();
                fromStatement.close();
                toStatement.close();
            }
            finally {
                try {
                    fromConnection.close();
                }
                catch (SQLException e) {}
                try {
                    toConnection.close();
                }
                catch (SQLException e) {}
            }
        }
        catch (SQLException e) {
            if (debug) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    public ContextRemote getFileContext() throws NoInitialContextException {
        if (this.application.getConfig().getContext() == null) {
            throw new NoInitialContextException();
        }
        return new DefaultContextRemote(this.application.getConfig().getContext());
    }

    public Map getStatistics() {
        long time = System.currentTimeMillis();
        HashMap<String, Object> statistics = new HashMap<String, Object>();
        statistics.put("startTime", new Long(this.application.getStartTime()));
        statistics.put("uptime", new Long(time - this.application.getStartTime()));
        statistics.put("logEvents", this.application.getLogEvents());
        return statistics;
    }

    public String getDisplayName() {
        return this.application.getConfig().getDisplayName();
    }

    public HttpApplicationAdministrator createWebApp(String name, boolean jared) throws InstantiationException, IOException {
        try {
            Context context = this.application.getConfig().getContext();
            Context subContext = context.createSubcontext(name);
            HttpApplicationDescriptor descriptor = new HttpApplicationDescriptor((EnterpriseArchive)this.application.getConfig(), name, (HttpApplicationDescriptor)this.application.getServer().getConfig().getDefaultHttpApplicationConfig().getConfiguration(), this.application.getUserManager(), jared);
            descriptor.setContext(subContext);
            descriptor.store();
            EnterpriseArchive archive = (EnterpriseArchive)this.application.getConfig();
            archive.addModule(new WebModule(name), false);
            archive.store();
            archive.storeDeployment();
            return new DefaultHttpApplicationAdministrator(null, this.application.getHttpApplicationConfig(name));
        }
        catch (NamingException e) {
            throw new InstantiationException("Naming error: " + e.getMessage());
        }
    }

    public ApplicationClientAdministrator createApplicationClient(String name, boolean jared) throws InstantiationException, IOException {
        try {
            Context context = this.application.getConfig().getContext();
            Context subContext = context.createSubcontext(name);
            ApplicationClientArchive descriptor = new ApplicationClientArchive(name, context);
            descriptor.setContext(subContext);
            descriptor.store();
            EnterpriseArchive archive = (EnterpriseArchive)this.application.getConfig();
            ClientModule module = new ClientModule(name);
            archive.addModule(module, false);
            archive.store();
            archive.storeDeployment();
            return new DefaultApplicationClientAdministrator(this.application, module, descriptor);
        }
        catch (NamingException e) {
            throw new InstantiationException("Naming error: " + e.getMessage());
        }
    }

    public EJBPackageAdministrator createEJBPackage(String name, boolean jared) throws InstantiationException, IOException {
        try {
            Context context = this.application.getConfig().getContext();
            Context subContext = context.createSubcontext(name);
            EnterpriseArchive archive = (EnterpriseArchive)this.application.getConfig();
            EJBModule module = new EJBModule(name);
            EJBPackageDeployment deployment = new EJBPackageDeployment(archive, this.application.getEJBContainer(), context, module);
            EJBPackage descriptor = deployment.getPackage();
            descriptor.setContext(subContext);
            descriptor.store();
            archive.addModule(module, false);
            archive.store();
            archive.storeDeployment();
            return new DefaultEJBPackageAdministrator(this.application.getEJBContainer(), deployment);
        }
        catch (NamingException e) {
            throw new InstantiationException("Naming error: " + e.getMessage());
        }
    }

    public JMSServerAdministrator getJMSServerAdministrator() {
        JMSServer server = this.application.getServer().getJMSServer();
        if (server == null) {
            return null;
        }
        return new DefaultJMSServerAdministrator(server);
    }

    public List getLibraryPaths() {
        return this.application.getConfig().getLibraryPaths();
    }

    public void updateDataSource(DataSourceConfig config) throws IOException, InstantiationException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testDataSource(String location, String username, String password) throws RemoteException, IOException, InstantiationException {
        Connection connection = null;
        try {
            try {
                Object object = this.application.getContext().lookup(location);
                if (!(object instanceof DataSource)) {
                    throw new InstantiationException("Invalid object type at location: " + location);
                }
                DataSource dataSource = (DataSource)object;
                connection = username == null ? dataSource.getConnection() : dataSource.getConnection(username, password);
                DatabaseMetaData dmd = connection.getMetaData();
                ResultSet rs = dmd.getTableTypes();
                rs.next();
            }
            catch (NamingException e) {
                throw new InstantiationException(e.getMessage());
            }
            catch (SQLException e) {
                throw new RemoteException(e.getMessage());
            }
            Object var10_11 = null;
            if (connection == null) return true;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        connection.close();
        return true;
    }

    private void handleLib(Map settings) throws IOException {
        byte[] jar = (byte[])settings.get("jar");
        String jarName = (String)settings.get("jarName");
        if (jar != null && jarName == null) {
            throw new NullPointerException("jar was set but jarName was null");
        }
        if (jar != null) {
            File jarFile;
            List paths = this.application.getConfig().getLibraryPaths();
            String targetDirectory = null;
            for (int i = 0; i < paths.size(); ++i) {
                PathElement elem = (PathElement)paths.get(i);
                File pathDirectory = new File(elem.getPathName());
                if (!pathDirectory.isDirectory()) continue;
                targetDirectory = pathDirectory.getAbsolutePath();
            }
            if (targetDirectory == null) {
                String newPathName;
                PathElement newPathElement;
                targetDirectory = ConfigUtils.getURL(((EnterpriseArchive)this.application.getConfig()).getDeploymentURL(), "lib").getFile();
                ArrayList<PathElement> newLibraryPaths = new ArrayList<PathElement>(this.application.getConfig().getLibraryPaths());
                if (!newLibraryPaths.contains(newPathElement = new PathElement(newPathName = "lib" + File.separator + jarName, true))) {
                    newLibraryPaths.add(newPathElement);
                }
                this.application.getConfig().setLibraryPaths(newLibraryPaths);
            }
            if (!new File(targetDirectory).exists()) {
                new File(targetDirectory).mkdir();
            }
            if (!(jarFile = new File(targetDirectory + File.separator + jarName)).exists() || jarFile.length() != (long)jar.length) {
                FileOutputStream out = new FileOutputStream(jarFile);
                out.write(jar);
                out.close();
            }
        }
    }

    public void updateDataSource(Map p_mapSettings) throws RemoteException, IOException, InstantiationException {
    }

    public List listDataSourceInfo() throws InstantiationException {
        int i;
        HashMap dataSourceConfigs = this.application.getNativeDataSourceConfigs();
        ArrayList nativeDataSourceConfigs = new ArrayList(dataSourceConfigs.size());
        Iterator iter = dataSourceConfigs.values().iterator();
        while (iter.hasNext()) {
            nativeDataSourceConfigs.add(0, iter.next());
        }
        HashMap<String, ConnectionPoolConfig> connectionPoolConfigs = new HashMap<String, ConnectionPoolConfig>();
        dataSourceConfigs = this.application.getManagedDataSourceConfigs();
        ArrayList<ManagedDataSourceConfig> managedDataSourceConfigs = new ArrayList<ManagedDataSourceConfig>(dataSourceConfigs.size());
        iter = dataSourceConfigs.values().iterator();
        while (iter.hasNext()) {
            ManagedDataSourceConfig mdsc = (ManagedDataSourceConfig)iter.next();
            managedDataSourceConfigs.add(0, mdsc);
            String connectionPoolName = mdsc.getConnectionPoolName();
            if (connectionPoolConfigs.containsKey(connectionPoolName)) continue;
            connectionPoolConfigs.put(connectionPoolName, this.application.getDataSourceConnectionPool(connectionPoolName).getConfig());
        }
        ArrayList<Object> info = new ArrayList<Object>(nativeDataSourceConfigs.size() + managedDataSourceConfigs.size() + connectionPoolConfigs.size());
        for (i = 0; i < nativeDataSourceConfigs.size(); ++i) {
            info.add(nativeDataSourceConfigs.get(i));
        }
        for (i = 0; i < managedDataSourceConfigs.size(); ++i) {
            info.add(managedDataSourceConfigs.get(i));
        }
        iter = connectionPoolConfigs.values().iterator();
        while (iter.hasNext()) {
            info.add(iter.next());
        }
        return info;
    }

    private String getNameForLocation(HashMap configs, String location) {
        String name = null;
        Iterator iter = configs.values().iterator();
        while (name == null && iter.hasNext()) {
            DataSourceBaseConfig dsbc = (DataSourceBaseConfig)iter.next();
            if (!dsbc.getJndiName().equals(location)) continue;
            name = dsbc.getName();
        }
        return name;
    }

    public void removeDataSource(String location) throws RemoteException {
        try {
            String name = this.getNameForLocation(this.application.getNativeDataSourceConfigs(), location);
            if (name != null) {
                this.application.removeNativeDataSource(name);
                this.application.persistDataSourceConfig();
            } else {
                name = this.getNameForLocation(this.application.getManagedDataSourceConfigs(), location);
                if (name != null) {
                    this.application.removeManagedDataSourceAndConnectionPool(name);
                    this.application.persistDataSourceConfig();
                }
            }
        }
        catch (DataSourceException e) {
            throw new RemoteException(e.toString(), e);
        }
        catch (MBeanException e) {
            throw new RemoteException(e.toString(), e);
        }
        catch (IOException e) {
            throw new RemoteException(e.toString(), e);
        }
    }

    public void installDataSource(Map settings) throws DataSourceException, MBeanException, DataSourceConfigException, InstantiationException, ResourceException, IOException {
        int i;
        this.handleLib(settings);
        LegacyDataSourcesConfig ldsc = new LegacyDataSourcesConfig(settings);
        XMLDataSourcesConfig xmlDsc = new XMLDataSourcesConfig(ldsc);
        DataSourcesConfig dsc = xmlDsc.getDataSourcesConfig();
        NativeDataSourceConfig[] nativeDataSourceConfigs = dsc.getNativeDataSources();
        ManagedDataSourceConfig[] managedDataSourceConfigs = dsc.getManagedDataSources();
        ConnectionPoolConfig[] connectionPoolConfigs = dsc.getConnectionPools();
        for (i = 0; i < nativeDataSourceConfigs.length; ++i) {
            this.application.createNativeDataSource(nativeDataSourceConfigs[i].getName(), nativeDataSourceConfigs[i].getUser(), nativeDataSourceConfigs[i].getPassword(), nativeDataSourceConfigs[i].getJndiName(), new Integer(nativeDataSourceConfigs[i].getLoginTimeout()), nativeDataSourceConfigs[i].getDataSourceClass(), nativeDataSourceConfigs[i].getUrl(), null);
        }
        for (i = 0; i < connectionPoolConfigs.length; ++i) {
            this.application.createDataSourceConnectionPool(connectionPoolConfigs[i].getName(), connectionPoolConfigs[i].getConnectionFactoryConfig().getFactoryClass(), connectionPoolConfigs[i].getConnectionFactoryConfig().getUser(), connectionPoolConfigs[i].getConnectionFactoryConfig().getPassword(), connectionPoolConfigs[i].getConnectionFactoryConfig().getUrl());
        }
        for (i = 0; i < managedDataSourceConfigs.length; ++i) {
            this.application.createManagedDataSource(managedDataSourceConfigs[i].getName(), managedDataSourceConfigs[i].getUser(), managedDataSourceConfigs[i].getPassword(), managedDataSourceConfigs[i].getJndiName(), new Integer(managedDataSourceConfigs[i].getLoginTimeout()), managedDataSourceConfigs[i].getConnectionPoolName(), managedDataSourceConfigs[i].getTxLevel(), "", true);
        }
        this.application.persistDataSourceConfig();
    }

    public void updateEJBModule(byte[] data, String jarName) throws RemoteException {
        try {
            this.application.updateEJBModule(jarName, data);
        }
        catch (Exception e) {
            throw new RemoteException("ejb module update failed!: ", e);
        }
    }
}

