/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.auth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ConsoleCallbackHandler
implements CallbackHandler {
    private PrintStream out;
    private InputStream in = System.in;

    public ConsoleCallbackHandler() {
        this.out = System.out;
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            this.handle(callback);
        }
    }

    public void handle(Callback callback) throws UnsupportedCallbackException, IOException {
        if (callback instanceof ChoiceCallback) {
            ChoiceCallback choice = (ChoiceCallback)callback;
            this.out.println(choice.getPrompt());
            this.out.print("[");
            for (int i = 0; i < choice.getChoices().length; ++i) {
                if (i > 0) {
                    this.out.print(", ");
                }
                this.out.print(choice.getChoices()[i]);
            }
            this.out.print("]");
            if (choice.getDefaultChoice() >= 0) {
                this.out.print(" (" + choice.getChoices()[choice.getDefaultChoice()] + ")");
            }
            this.out.print(": ");
            this.out.flush();
            String response = this.readLine();
            if (response.trim().equals("")) {
                choice.setSelectedIndex(choice.getDefaultChoice());
            }
            for (int i = 0; i < choice.getChoices().length; ++i) {
                if (!response.equals(choice.getChoices()[i])) continue;
                choice.setSelectedIndex(i);
            }
        } else if (callback instanceof TextInputCallback) {
            TextInputCallback text = (TextInputCallback)callback;
            this.out.print(text.getPrompt());
            if (text.getDefaultText() != null) {
                this.out.print(" (" + text.getDefaultText() + ")");
            }
            this.out.print(": ");
            this.out.flush();
            String response = this.readLine();
            if (response.trim().equals("")) {
                text.setText(text.getDefaultText());
            } else {
                text.setText(response);
            }
        } else if (callback instanceof TextOutputCallback) {
            switch (((TextOutputCallback)callback).getMessageType()) {
                case 2: {
                    System.out.print("ERROR: ");
                    break;
                }
                case 1: {
                    System.out.print("WARNING: ");
                }
            }
            this.out.println(((TextOutputCallback)callback).getMessage());
        } else if (callback instanceof PasswordCallback) {
            this.out.print("Password: ");
            this.out.flush();
            String password = this.readLine();
            if (password.trim().length() > 0) {
                ((PasswordCallback)callback).setPassword(password.toCharArray());
            }
        } else if (callback instanceof NameCallback) {
            this.out.print(((NameCallback)callback).getPrompt());
            this.out.print(": ");
            this.out.flush();
            String name = this.readLine();
            if (name.trim().length() > 0) {
                ((NameCallback)callback).setName(name);
            }
        } else if (callback instanceof ConfirmationCallback) {
            ConfirmationCallback confirmation = (ConfirmationCallback)callback;
            System.out.print(confirmation.getPrompt());
            switch (confirmation.getOptionType()) {
                case 0: {
                    this.out.print(" [yes/no]");
                    break;
                }
                case 1: {
                    this.out.print(" [yes/no/cancel]");
                    break;
                }
                case 2: {
                    this.out.print(" [ok/cancel]");
                    break;
                }
                case -1: {
                    this.out.print(" [");
                    for (int i = 0; i < confirmation.getOptions().length; ++i) {
                        if (i > 0) {
                            this.out.print("/");
                        }
                        this.out.print(confirmation.getOptions()[i]);
                    }
                    this.out.print("]");
                }
            }
            if (confirmation.getDefaultOption() != -1 && confirmation.getDefaultOption() >= 0) {
                if (confirmation.getMessageType() == -1) {
                    this.out.print(" (" + confirmation.getOptions()[confirmation.getDefaultOption()] + ")");
                } else {
                    switch (confirmation.getDefaultOption()) {
                        case 0: {
                            this.out.print(" (yes)");
                            break;
                        }
                        case 1: {
                            this.out.print(" (no)");
                            break;
                        }
                        case 3: {
                            this.out.print(" (ok)");
                            break;
                        }
                        case 2: {
                            this.out.print(" (cancel)");
                        }
                    }
                }
            }
            this.out.print(": ");
            this.out.flush();
            String response = this.readLine();
            if (confirmation.getOptionType() == 0 || confirmation.getOptionType() == 1) {
                if (response.equalsIgnoreCase("yes") || response.equalsIgnoreCase("y")) {
                    confirmation.setSelectedIndex(0);
                } else if (response.equalsIgnoreCase("no") || response.equalsIgnoreCase("n")) {
                    confirmation.setSelectedIndex(1);
                }
            } else if (response.equalsIgnoreCase("ok") || response.equalsIgnoreCase("o")) {
                confirmation.setSelectedIndex(3);
            } else if (response.equalsIgnoreCase("cancel") || response.equalsIgnoreCase("c")) {
                confirmation.setSelectedIndex(2);
            }
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }

    public String readLine() throws IOException {
        return new BufferedReader(new InputStreamReader(this.in)).readLine().trim();
    }
}

