/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector;

import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.server.connector.ConnectionHandleContextFinalizer;
import com.evermind.util.JCAProperties;
import oracle.j2ee.connector.ConnectorProxy;
import oracle.j2ee.connector.proxy.AbstractProxy;

public class ConnectionHandleContext {
    private long m_useTimeToken;
    private ApplicationConnectionManager m_acm;
    private ConnectorProxy m_proxy;
    private boolean m_removed;
    private ConnectionHandleContextFinalizer m_finalizer = null;

    public ConnectionHandleContext(long useTimeToken, Throwable creationStacktrace, ApplicationConnectionManager acm, AbstractProxy proxy) {
        this.m_useTimeToken = useTimeToken;
        this.m_acm = acm;
        this.m_removed = false;
        this.m_proxy = (ConnectorProxy)proxy;
        if (JCAProperties.getJcaConnectionDebug()) {
            this.m_finalizer = new ConnectionHandleContextFinalizer(this, creationStacktrace);
        }
    }

    public long getUseTimeToken() {
        return this.m_useTimeToken;
    }

    public void removed() {
        this.m_removed = true;
        if (this.m_proxy != null) {
            this.m_proxy.oc4j_resetConnectionContext();
        }
    }

    public void closed() {
        if (this.m_proxy != null) {
            this.m_proxy.oc4j_closed();
        }
    }

    public Throwable getCreationStacktrace() {
        if (this.m_finalizer != null) {
            return this.m_finalizer.getCreationStacktrace();
        }
        return null;
    }

    public AbstractProxy getProxy() {
        return this.m_proxy;
    }

    protected boolean isRemoved() {
        return this.m_removed;
    }

    protected void doDMSOnFinalize() {
        if (this.m_useTimeToken != 0L) {
            if (this.m_acm.getUseTimeEvent() != null) {
                this.m_acm.getUseTimeEvent().abort(this.m_useTimeToken);
            }
            if (this.m_acm.getSharedPoolUseTimeEvent() != null) {
                this.m_acm.getSharedPoolUseTimeEvent().abort(this.m_useTimeToken);
            }
        }
    }
}

