/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceProviderDescriptor
extends AbstractDescribable
implements XMLizable,
Serializable {
    private String className;
    private Map properties;

    public ResourceProviderDescriptor() {
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    public ResourceProviderDescriptor(String name, String description, String className, Map map) throws InstantiationException {
        this.setName(name);
        this.setDescription(description);
        this.className = className;
        this.properties = map;
    }

    public ResourceProviderDescriptor(Node parent) throws InstantiationException {
        this.setName(XMLUtils.getNodeAttribute(parent, "name"));
        this.className = XMLUtils.getNodeAttribute(parent, "class");
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("property")) {
                    String propertyName = XMLUtils.getNodeAttribute(node, "name");
                    String propertyValue = XMLUtils.getNodeAttribute(node, "value");
                    if (propertyName == null) {
                        throw new InstantiationException("property tag with missing name attribute");
                    }
                    if (propertyName == null) {
                        throw new InstantiationException("property tag with missing value attribute");
                    }
                    if (this.properties == null) {
                        this.properties = new HashMap();
                    }
                    this.properties.put(propertyName, propertyValue);
                    continue;
                }
                if (name.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                throw new InstantiationException("Unknown property subtag: " + name);
            }
        }
    }

    public String getName() {
        return super.getName() == null ? this.getClassName() : super.getName();
    }

    public String getClassName() {
        return this.className == null ? "" : this.className;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.print(indention + "<resource-provider");
        if (this.getName() != null) {
            out.print(" name=\"" + XMLUtils.encode(this.getName()) + "\"");
        }
        out.print(" class=\"" + XMLUtils.encode(this.getClassName()) + "\"");
        out.println(">");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.properties != null) {
            XMLUtils.writeCompressedMap(this.properties, "property", out, "name", "value", indention + "\t");
        }
        out.println(indention + "</resource-provider>");
    }
}

