/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityRoleReference
extends AbstractDescribable
implements XMLizable,
Serializable {
    protected String link;

    public SecurityRoleReference() {
    }

    public SecurityRoleReference(Node parent) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("#text")) continue;
            String value = XMLUtils.getStringValue(node);
            if (name.equals("description")) {
                this.setDescription(value);
                continue;
            }
            if (name.equals("role-name")) {
                this.setName(value);
                continue;
            }
            if (!name.equals("role-link")) continue;
            this.link = value;
        }
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<security-role-ref>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<role-name>" + XMLUtils.encode(this.getName()) + "</role-name>");
        }
        if (this.link != null) {
            out.println(indention + "\t<role-link>" + XMLUtils.encode(this.link) + "</role-link>");
        }
        out.println(indention + "</security-role-ref>");
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("security-role-ref");
        buf.append("  role-name        : ");
        buf.append(this.getName());
        buf.append("\n");
        buf.append("  role-link        : ");
        buf.append(this.getLink());
        buf.append("\n");
        buf.append("  description      : ");
        buf.append(this.getDescription());
        buf.append("\n");
        return buf.toString();
    }
}

