/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.Module;
import com.evermind.server.http.deployment.SyntheticWebModuleDescriptor;
import com.evermind.xml.XMLUtils;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class WebModule
extends Module {
    protected String unpackedPath;
    protected String contextRoot = "/";
    protected boolean accessLog = false;
    public boolean synthetic = false;
    public SyntheticWebModuleDescriptor syntheticDescriptor;

    public WebModule(String path) {
        super(path);
    }

    public WebModule(String path, SyntheticWebModuleDescriptor syntheticDescriptor, boolean synthetic) {
        super(path);
        this.name = this.getName();
        this.syntheticDescriptor = syntheticDescriptor;
        this.synthetic = synthetic;
    }

    public WebModule(String path, String name, SyntheticWebModuleDescriptor syntheticDescriptor, boolean synthetic) {
        super(path);
        this.name = name;
        this.syntheticDescriptor = syntheticDescriptor;
        this.synthetic = synthetic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebModule(Node parent) throws InstantiationException {
        super(parent);
        if (parent.getNodeName().equals("module")) {
            Node webNode = XMLUtils.getSubnode(parent, "web");
            this.name = XMLUtils.getNodeAttribute(webNode, "id");
            if (webNode == null) throw new InstantiationException("No <web> tag found in <module> tag");
            this.path = this.checkPath(XMLUtils.getSubnodeValue(webNode, "web-uri"));
            if (this.path == null) {
                throw new InstantiationException("Missing <web-uri> tag in <web> tag");
            }
            this.contextRoot = XMLUtils.getSubnodeValue(webNode, "context-root");
            if (this.contextRoot != null) return;
            this.contextRoot = "/";
            return;
        } else {
            this.name = XMLUtils.getNodeAttribute(parent, "id");
            if (this.name == null) {
                throw new InstantiationException("Missing 'id' attribute in <web-module> tag");
            }
            this.path = XMLUtils.getNodeAttribute(parent, "path");
            if (this.path != null) return;
            throw new InstantiationException("Missing 'path' attribute in <web-module> tag");
        }
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String root) {
        this.contextRoot = root;
    }

    public boolean getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(boolean accessLog) {
        this.accessLog = accessLog;
    }

    public String toString() {
        return "<web-module id=\"" + XMLUtils.encode(this.getName()) + "\" path=\"" + XMLUtils.encode(this.path) + "\" />";
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.println(indention + this);
    }

    public String getPath() {
        if (this.unpackedPath != null) {
            return this.unpackedPath;
        }
        return super.getPath();
    }

    public void setUnpackedPath(String path) {
        this.unpackedPath = path;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<module>");
        out.println(indention + "\t<web>");
        out.println(indention + "\t\t<web-uri>" + XMLUtils.encode(this.path) + "</web-uri>");
        out.println(indention + "\t\t<context-root>" + XMLUtils.encode(this.contextRoot) + "</context-root>");
        out.println(indention + "\t</web>");
        out.println(indention + "</module>");
    }

    public String getPackagedPath() {
        return this.path;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public SyntheticWebModuleDescriptor getSyntheticDescriptor() {
        return this.syntheticDescriptor;
    }
}

