/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransactionSynchronization;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.DBEntityEJBObject;
import com.evermind.server.ejb.DummyRemote;
import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.EvermindEntityContext;
import com.evermind.server.ejb.InvocationContextPool;
import com.evermind.server.ejb.interceptor.MethodState;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.EJBProperties;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.DuplicateKeyException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public abstract class DBEntityEJBHome
extends EntityEJBHome
implements DummyRemote {
    protected boolean beingUsed;
    private static Logger m_logger = EJBTraceLogger.getLogger(DBEntityEJBHome.class);
    private static long currentID = 0L;

    public Object exportObject(DBEntityEJBObject obj) {
        return obj;
    }

    public Collection exportObjectCollection(Collection wrappers) {
        return wrappers;
    }

    public Enumeration exportObjectEnumeration(Enumeration wrappers) {
        return wrappers;
    }

    public Object getProtocolResponseObject(DBEntityEJBObject object) {
        return this.exportObject(object);
    }

    public Object getProtocolResponseObject(Collection object) {
        return this.exportObjectCollection(object);
    }

    public Object getProtocolResponseObject(Enumeration object) {
        return this.exportObjectEnumeration(object);
    }

    private final DBEntityEJBObject getWrapperInstanceNoCache(Object pKey, boolean create, boolean _needCtx) throws RemoteException {
        if (!create) {
            return null;
        }
        return this.createWrapperInstance(pKey, _needCtx);
    }

    public final EvermindEntityContext findContextInstanceTx(ThreadState thread, Object pKey, AbstractEJBObject wrapper) throws RemoteException {
        EvermindEntityContext context = this.getContextInstanceTx(thread, pKey, false);
        if (context != null && !context.canBeReleased && !context.wrapList.contains(wrapper)) {
            context.wrapList.add(wrapper);
        }
        return context;
    }

    public final EvermindEntityContext getContextInstanceTx(ThreadState thread, Object pKey) throws RemoteException {
        return this.getContextInstanceTx(thread, pKey, true);
    }

    private final EvermindEntityContext getContextInstanceTx(ThreadState thread, Object pKey, boolean createIfNotFound) throws RemoteException {
        EvermindEntityContext _context = null;
        Transaction tx = null;
        try {
            tx = ApplicationServer.getInstance().getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            m_logger.log(Level.WARNING, "getContextInstanceTx: SystemException during getTransaction " + (Object)((Object)systemException));
        }
        if (tx != null) {
            _context = ((ApplicationServerTransactionSynchronization)tx).getCachedContextInstance(this, pKey);
        }
        if (_context != null) {
            _context.canBeReleased = false;
            if (this.isRemote && _context.remoteHome == null) {
                _context.remoteHome = this;
            }
            if (!this.isRemote && _context.localHome == null) {
                _context.localHome = this;
            }
        } else if (createIfNotFound) {
            _context = this.getContextInstance();
        }
        return _context;
    }

    final DBEntityEJBObject createWrapperInstance(Object pKey) throws RemoteException {
        return this.createWrapperInstance(pKey, true);
    }

    final DBEntityEJBObject createWrapperInstance(Object pKey, boolean needCtx) throws RemoteException {
        EvermindEntityContext context = null;
        if (needCtx) {
            ThreadState thread = ThreadState.getCurrentState();
            context = this.getContextInstanceTx(thread, pKey);
        }
        DBEntityEJBObject dbObj = (DBEntityEJBObject)this.createBeanWrapperInstance(context, needCtx);
        dbObj.needToActivate = true;
        dbObj.beingUsed = false;
        dbObj.dbEntityObjectDebug = EJBProperties.getDBEntityObjectDebug();
        if (needCtx && !context.canBeReleased && !context.wrapList.contains(dbObj)) {
            context.wrapList.add(dbObj);
        }
        return dbObj;
    }

    public DBEntityEJBObject getWrapperInstance(Object pKey, long timeout, boolean create) throws RemoteException {
        return this.getWrapperInstance(pKey, timeout, create, true);
    }

    public DBEntityEJBObject getWrapperInstance(Object pKey, long timeout, boolean create, boolean _needCtx) throws RemoteException {
        DBEntityEJBObject _obj = this._getWrapperInstance(pKey, timeout, create, _needCtx);
        if (_obj != null) {
            _obj.setPK_X(pKey);
            this.exportObject(_obj);
        }
        return _obj;
    }

    private DBEntityEJBObject _getWrapperInstance(Object pKey, long timeout, boolean create, boolean _needCtx) throws RemoteException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering("DBEntityEJBHome", "_getWrapperInstance", new Object[]{pKey, new Boolean(create)});
        }
        return this.getWrapperInstanceNoCache(pKey, create, _needCtx);
    }

    public void addWrapperInstance(Object pKey, DBEntityEJBObject wrapper) throws DuplicateKeyException, RemoteException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering("DBEntityEJBHome", "addWrapperInstance", new Object[]{pKey});
        }
        if (wrapper != null) {
            this.exportObject(wrapper);
        }
    }

    public void removeWrapperInstance(EntityEJBObject object) throws RemoteException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "removeWrapperInstance: " + this.bindingPath + ": removing entity " + object + " from cache");
        }
    }

    public void removePKPool(DBEntityEJBObject wrapper) throws RemoteException {
    }

    public synchronized long getNextID() {
        return currentID++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void OC4J_invokeRemove(MethodState state, Object pk, Object[] params, ThreadState thread) throws Exception {
        ContextContainer previousContainer = thread.contextContainer;
        try {
            thread.contextContainer = this;
            InvocationContextPool.invoke(thread, state, pk, params, this.getLazyInstance(pk), this);
        }
        finally {
            thread.contextContainer = previousContainer;
        }
    }
}

