/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.DefaultIdentityGenerator;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.EntityContainer;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.EvermindEntityContext;
import com.evermind.server.ejb.FieldPersistenceManager;
import com.evermind.server.ejb.IdentityGenerator;
import com.evermind.server.ejb.InvocationContextPool;
import com.evermind.server.ejb.OracleEntityContext;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.logging.EJBLifecycleMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.util.ExtendedComparator;
import com.evermind.util.ExternalHashSet;
import java.rmi.RemoteException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.Timer;
import javax.naming.Context;

public abstract class EntityEJBHome
extends AbstractEJBHome
implements ExtendedComparator,
EntityContainer {
    public ExternalHashSet instances = new ExternalHashSet(this);
    public DataSourceConnectionContainer dataSourceContainer;
    private boolean hasExclusiveWriteAccess = true;
    protected int clusteringSchema;
    private IdentityGenerator identityGenerator;
    private static Logger m_logger = EJBTraceLogger.getLogger(EntityEJBHome.class);

    public boolean hasExclusiveWriteAccess() {
        return this.hasExclusiveWriteAccess;
    }

    public void setHasExclusiveWriteAccess(boolean access) {
        this.hasExclusiveWriteAccess = access;
    }

    public EvermindEntityContext getLocalContextInstance() {
        try {
            return this.getContextInstance();
        }
        catch (RemoteException e) {
            throw EJBUtils.createEJBException(e);
        }
    }

    public EvermindEntityContext createContextInstance() {
        return new EvermindEntityContext(this, this.createInstance());
    }

    public EvermindEntityContext getContextInstance() throws RemoteException {
        EvermindEntityContext context = (EvermindEntityContext)this.getBeanDescriptor().getBeanPool().allocateContext();
        if (this.isRemote) {
            context.remoteHome = this;
        } else {
            context.localHome = this;
        }
        return context;
    }

    public void releaseContextInstance(EvermindEntityContext context, boolean toBeDiscarded) {
        this.getBeanDescriptor().getBeanPool().releaseContext(context, toBeDiscarded);
    }

    public void releaseContextInstance(EvermindEntityContext context) {
        this.releaseContextInstance(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivateAndRelease(EvermindEntityContext context, boolean destroy, boolean txNotSuccessful) {
        if (this.isRemote ? context.remoteWrapper == null : context.localWrapper == null) {
            return;
        }
        try {
            block19: {
                try {
                    if (destroy) {
                        EJBLifecycleMessages.finerEntityContextDestroyed(this.getBeanDescriptor(), context.getPrimaryKey());
                    } else {
                        EJBLifecycleMessages.finerEntityContextPassivated(this.getBeanDescriptor(), context.getPrimaryKey());
                    }
                    if (m_logger.isLoggable(Level.FINE)) {
                        new Throwable().printStackTrace();
                    }
                    if (!context.isToBeDiscarded()) {
                        if (destroy) {
                            this.callEntityEjbRemove(context);
                        } else if (this.isRemote) {
                            if (!((EntityEJBObject)context.remoteWrapper).OC4J_isCacheable() && !((EntityBeanDescriptor)this.getBeanDescriptor()).isReadOnlyBMP()) {
                                this.callEntityEjbPassivate(context);
                            }
                        } else if (!((EntityEJBObject)context.localWrapper).OC4J_isCacheable() && !((EntityBeanDescriptor)this.getBeanDescriptor()).isReadOnlyBMP()) {
                            this.callEntityEjbPassivate(context);
                        }
                    }
                }
                catch (Throwable t) {
                    context.setObject(null);
                    this.OC4J_log(destroy ? "Error in ejbRemove" : "Error in ejbPassivate", t);
                    if (EJBTransactionManager.getTransaction() == null) break block19;
                    EJBTransactionManager.getInstance().setContainerRollbackOnly();
                }
            }
            Object var6_5 = null;
            if (this.isRemote) {
                ((EntityEJBObject)context.remoteWrapper).context = null;
                context.remoteWrapper = null;
            } else {
                ((EntityEJBObject)context.localWrapper).context = null;
                context.localWrapper = null;
            }
            this.releaseContextInstance(context, txNotSuccessful);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.isRemote) {
                ((EntityEJBObject)context.remoteWrapper).context = null;
                context.remoteWrapper = null;
            } else {
                ((EntityEJBObject)context.localWrapper).context = null;
                context.localWrapper = null;
            }
            this.releaseContextInstance(context, txNotSuccessful);
            throw throwable;
        }
    }

    protected abstract EntityBean createInstance();

    protected abstract void resetState(EntityBean var1);

    public abstract EJBObject getEJBObject(Object var1) throws EJBException, FinderException, RemoteException;

    public void setClusteringSchema(int clusteringSchema) {
        this.clusteringSchema = clusteringSchema;
    }

    protected FieldPersistenceManager getFieldPersistenceManager(String name) {
        List beans = this.ejbPackage.getPackage().getBeans();
        for (int i = 0; i < beans.size(); ++i) {
            BeanDescriptor descriptor = (BeanDescriptor)beans.get(i);
            if (!(descriptor instanceof ExposableBeanDescriptor) || !this.getClass().getName().equals(((ExposableBeanDescriptor)descriptor).getRemoteHomeWrapperName())) continue;
            EntityBeanDescriptor entity = (EntityBeanDescriptor)descriptor;
            ContainerManagedField field = null;
            StringTokenizer tokenizer = new StringTokenizer(name, ":");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (field == null) {
                    field = entity.getContainerManagedField(token, entity);
                    continue;
                }
                if ((field = field.getPropertyField(token)) != null) continue;
                throw new RuntimeException("Field '" + field.getName() + "' does not have a child named '" + token + "'");
            }
            return field.getPersistenceManager();
        }
        return null;
    }

    public static final long OC4J_getCurrentTime() {
        return HttpDateFormat.currentTimeMillis();
    }

    public IdentityGenerator getIdentityGenerator() {
        if (this.identityGenerator == null) {
            this.identityGenerator = new DefaultIdentityGenerator(this.container);
        }
        return this.identityGenerator;
    }

    public abstract EntityEJBObject createBeanWrapperInstance(EvermindEntityContext var1, boolean var2);

    public AbstractEJBObject getOneToOneOwnerFor(String _beanName, Object _pk, ApplicationServerTransaction _tx) {
        return null;
    }

    public EJBContext getContextWithID(Object _pk) {
        OracleEntityContext context = (OracleEntityContext)this.getBeanDescriptor().getBeanPool().allocateContext();
        try {
            context.setPrimaryKey(_pk);
        }
        catch (RemoteException e) {
            throw EJBUtils.createEJBException(e);
        }
        return context;
    }

    public void releaseContextWithID(EJBContext context, boolean toBeDiscarded) {
        OracleEntityContext ctx = (OracleEntityContext)context;
        ctx.timersvc = null;
        if (!toBeDiscarded) {
            try {
                ctx.unsetPrimaryKey();
            }
            catch (Exception _e) {
                toBeDiscarded = true;
                m_logger.log(Level.WARNING, "Error release context to backend", _e);
            }
        }
        this.getBeanDescriptor().getBeanPool().releaseContext(ctx, toBeDiscarded);
    }

    private void callEntityEjbPassivate(EvermindEntityContext context) {
        try {
            this.getBeanDescriptor().getLifecycleManager().prePassivate(context.getObject(), context);
        }
        catch (Throwable e) {
            this.OC4J_log("ejbPassivate failed: " + e.getMessage(), e);
        }
    }

    private void callEntityEjbRemove(EvermindEntityContext context) {
        try {
            this.getBeanDescriptor().getLifecycleManager().preDestroy(context.getObject(), context);
        }
        catch (Throwable e) {
            this.OC4J_log("ejbRemove failed: " + e.getMessage(), e);
        }
    }

    protected void __reSetContext(Context context) {
        context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeTimer(Timer timer, Object primaryKey) throws Exception {
        ThreadState thread = ThreadState.getCurrentState();
        ContextContainer oldContainer = thread.contextContainer;
        try {
            thread.contextContainer = this;
            InvocationContextPool.invoke(thread, this._desc.getTimeoutMethodState(), primaryKey, new Object[]{timer}, this._desc.isTopLinkCMP() ? this.getLazyInstance(primaryKey) : null, this);
        }
        finally {
            thread.contextContainer = oldContainer;
        }
    }
}

