/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.ArchiveContext;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;

public class IncrementalDeploymentHandler {
    private static Logger m_logger = EJBTraceLogger.getLogger(IncrementalDeploymentHandler.class);
    public static final String META_INF_PATH = "META-INF/";
    public static final String BACKUP_SUFFIX = "_backup_version";
    private String ejbModuleName;
    private MemoryArchiveContext backupEJBArchiveContext = null;

    public IncrementalDeploymentHandler(String ejbModuleName) {
        this.ejbModuleName = ejbModuleName;
    }

    public void updateEJBModule(byte[] newJarData, EJBPackageDeployment pkgDeployment) throws InstantiationException {
        boolean oc4jEjbJarModified = false;
        boolean toplinkEjbJarModified = false;
        String orionEjbJarXml = null;
        String toplinkEjbJarXml = null;
        String pmDeployDescPath = null;
        try {
            boolean fullRedeployNeeded;
            MemoryArchiveContext newJarCtx = new MemoryArchiveContext(newJarData, false);
            Context oldJarCtx = pkgDeployment.getContext();
            String appDeployDescPath = pkgDeployment.getPackage().getDeploymentDescriptorPath();
            orionEjbJarXml = META_INF_PATH + appDeployDescPath;
            oc4jEjbJarModified = this.isDeploymentDescriptorChanged(oldJarCtx, newJarCtx, orionEjbJarXml);
            if (pkgDeployment.getPackage().getPersistenceManagerDescriptor() != null && pkgDeployment.getPackage().getPersistenceManagerDescriptor().isTopLinkPM()) {
                pmDeployDescPath = pkgDeployment.getPackage().getPersistenceManagerDescriptor().getDescriptorName();
                toplinkEjbJarXml = META_INF_PATH + pmDeployDescPath;
                toplinkEjbJarModified = this.isDeploymentDescriptorChanged(oldJarCtx, newJarCtx, toplinkEjbJarXml);
            }
            boolean bl = fullRedeployNeeded = this.isEjbJarModified(pkgDeployment, newJarCtx, oldJarCtx) || oc4jEjbJarModified || toplinkEjbJarModified;
            if (fullRedeployNeeded) {
                Context deployContext = pkgDeployment.getDeploymentContext();
                try {
                    String deployCacheName = pkgDeployment.getDeploymentCacheName();
                    deployContext.unbind(deployCacheName);
                }
                catch (NamingException e) {
                    // empty catch block
                }
                if (oc4jEjbJarModified) {
                    deployContext.rebind(appDeployDescPath, newJarCtx.lookup(orionEjbJarXml));
                }
                if (toplinkEjbJarModified) {
                    deployContext.rebind(pmDeployDescPath, newJarCtx.lookup(toplinkEjbJarXml));
                }
            }
            this.updateArchiveContent(newJarData, pkgDeployment);
        }
        catch (Exception ex) {
            this.recoverBackupEJBModule(oc4jEjbJarModified, toplinkEjbJarModified, orionEjbJarXml, toplinkEjbJarXml, pmDeployDescPath, pkgDeployment);
            throw (InstantiationException)new InstantiationException(ex.getMessage()).initCause(ex);
        }
    }

    public boolean isEjbJarModified(EJBPackageDeployment pkgDeployment, Context newJarCtx, Context oldJarCtx) throws InstantiationException {
        boolean ejbJarModified = false;
        try {
            String ejbJarXml = pkgDeployment.getPackage().getAssemblyDescriptorPath();
            boolean isEjbJarIncluded = ContextUtils.isInContext(newJarCtx, ejbJarXml);
            if (!isEjbJarIncluded) {
                if (pkgDeployment.getPackage().getCompatibility() < 3) {
                    newJarCtx.close();
                    throw new InstantiationException("Incremental Deployment fails, ejb-jar.xml is not in the updated ejb jar file, most likely, the new jar file is corrupted.");
                }
            } else {
                ejbJarModified = this.isFileTimestampsChanged(oldJarCtx, newJarCtx, ejbJarXml);
            }
        }
        catch (Exception ex) {
            throw (InstantiationException)new InstantiationException(ex.getMessage()).initCause(ex);
        }
        return ejbJarModified;
    }

    public void updateArchiveContent(byte[] newJarData, EJBPackageDeployment pkgDeployment) throws NamingException, IOException {
        String ejbModulePath = this.getEJBModulePath(pkgDeployment);
        Context appContext = pkgDeployment.getApplicationContext();
        byte[] oldJarData = (byte[])appContext.lookup(ejbModulePath);
        appContext.rebind(ejbModulePath + BACKUP_SUFFIX, (Object)oldJarData);
        Context ejbContext = pkgDeployment.getContext();
        if (ejbContext instanceof ArchiveContext) {
            ejbContext.close();
        }
        appContext.rebind(ejbModulePath, (Object)newJarData);
        ContextUtils.flush(appContext);
    }

    public boolean isBackupEJBArchiveExisted(EJBPackageDeployment pkgDeployment) {
        boolean isBackupEJBArchiveExisted = false;
        try {
            pkgDeployment.getApplicationContext().lookup(this.getEJBModulePath(pkgDeployment) + BACKUP_SUFFIX);
            isBackupEJBArchiveExisted = true;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return isBackupEJBArchiveExisted;
    }

    public MemoryArchiveContext getBackupEJBArchiveContext(EJBPackageDeployment pkgDeployment) {
        if (this.backupEJBArchiveContext == null && this.isBackupEJBArchiveExisted(pkgDeployment)) {
            try {
                String backupModuleName = this.getEJBModulePath(pkgDeployment) + BACKUP_SUFFIX;
                byte[] data = (byte[])pkgDeployment.getApplicationContext().lookup(backupModuleName);
                this.backupEJBArchiveContext = new MemoryArchiveContext(pkgDeployment.getContext(), backupModuleName, data, 0, data.length, false);
            }
            catch (Exception e) {
                m_logger.log(Level.WARNING, "Unexpected error creating context for ejb backup archive.");
            }
        }
        return this.backupEJBArchiveContext;
    }

    public void deleteBackupEJBArchive(EJBPackageDeployment pkgDeployment) {
        if (this.isBackupEJBArchiveExisted(pkgDeployment)) {
            try {
                Context appContext = pkgDeployment.getApplicationContext();
                appContext.unbind(this.getEJBModulePath(pkgDeployment) + BACKUP_SUFFIX);
                ContextUtils.flush(appContext);
            }
            catch (Exception e) {
                m_logger.log(Level.WARNING, "Error removing prior ejb module archive; error.");
            }
        }
        if (this.backupEJBArchiveContext != null) {
            this.backupEJBArchiveContext.unload();
            this.backupEJBArchiveContext = null;
        }
    }

    private void recoverBackupEJBModule(boolean oc4jEjbJarModified, boolean toplinkEjbJarModified, String orionEjbJarXml, String toplinkEjbJarXml, String pmDeployDescPath, EJBPackageDeployment pkgDeployment) throws InstantiationException {
        m_logger.log(Level.WARNING, "Incremental deployment on updated ejb module fails. Check the server log for the cause. The container is attempting to recover the previous EJB module deployment");
        try {
            if (this.backupEJBArchiveContext != null) {
                this.backupEJBArchiveContext.rebind(pkgDeployment.getModule().getName(), (Object)this.backupEJBArchiveContext.getData());
            }
            if (oc4jEjbJarModified) {
                pkgDeployment.getDeploymentContext().rebind(pkgDeployment.getPackage().getDeploymentDescriptorPath(), this.backupEJBArchiveContext.lookup(orionEjbJarXml));
            }
            if (toplinkEjbJarModified) {
                pkgDeployment.getDeploymentContext().rebind(pmDeployDescPath, this.backupEJBArchiveContext.lookup(toplinkEjbJarXml));
            }
        }
        catch (Exception ex) {
            throw (InstantiationException)new InstantiationException().initCause(ex);
        }
    }

    private boolean isDeploymentDescriptorChanged(Context oldJarContext, Context newJarContext, String descFilePath) throws InstantiationException {
        boolean isXmlInOldJar = ContextUtils.isInContext(oldJarContext, descFilePath);
        boolean isXmlInNewJar = ContextUtils.isInContext(newJarContext, descFilePath);
        boolean isChanged = !isXmlInOldJar && !isXmlInNewJar ? false : (!isXmlInOldJar && isXmlInNewJar || isXmlInOldJar && !isXmlInNewJar ? true : this.isFileTimestampsChanged(oldJarContext, newJarContext, descFilePath));
        return isChanged;
    }

    private boolean isFileTimestampsChanged(Context oldContext, Context newContext, String filePath) {
        return ContextUtils.getFileLastModified(newContext, filePath) != ContextUtils.getFileLastModified(oldContext, filePath);
    }

    private String getEJBModulePath(EJBPackageDeployment pkgDeployment) {
        return pkgDeployment.getModule().getPath();
    }

    public String getEjbModuleName() {
        return this.ejbModuleName;
    }

    public void setEjbModuleName(String ejbModuleName) {
        this.ejbModuleName = ejbModuleName;
    }
}

