/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.CMRCollectionField;
import com.evermind.server.ejb.ChangedValue;
import com.evermind.server.ejb.DataSourceConnection;
import com.evermind.server.ejb.EvermindEntityContext;
import com.evermind.server.ejb.ORSetIterator;
import java.sql.SQLException;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;

public abstract class ORSet
extends AbstractSet
implements CMRCollectionField {
    public EvermindEntityContext context;
    public Object primaryKey;
    protected Object[] objects;
    protected int deleted;
    protected boolean dirty;
    protected boolean loaded = false;

    public abstract Object[] getObjects();

    public abstract void checkScope();

    public abstract boolean isImmutable();

    public abstract void persist(DataSourceConnection var1) throws SQLException;

    public abstract void deleteEntries(DataSourceConnection var1) throws SQLException;

    public Object getReplacement() {
        return new HashSet(this);
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public Iterator iterator() {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        return new ORSetIterator(this);
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean notifyRemoved) {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        for (int i = 0; i < this.objects.length; ++i) {
            if (this.objects[i] instanceof ChangedValue) {
                ChangedValue changed = (ChangedValue)this.objects[i];
                if (changed.newValue == null) continue;
                if (notifyRemoved) {
                    this.notifyRemovedObject(changed.newValue);
                }
                changed.newValue = null;
                ++this.deleted;
                continue;
            }
            if (notifyRemoved) {
                this.notifyRemovedObject(this.objects[i]);
            }
            this.objects[i] = new ChangedValue(this.objects[i], null);
            ++this.deleted;
        }
        this.dirty = true;
    }

    public int size() {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        return this.objects.length - this.deleted;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setToLoaded() {
        this.loaded = true;
    }

    public boolean add(Object object) {
        return this.add(object, true, true);
    }

    public boolean add(Object object, boolean triggerChange, boolean notifyAdded) {
        if (object == null) {
            throw new IllegalArgumentException("Illegal adding of null to a collection cmr-field, see the EJB specification 10.3.8");
        }
        if (!this.isLoaded() || this.objects == null) {
            this.objects = this.getObjects();
        }
        if (triggerChange) {
            this.dirty = true;
        }
        for (int i = 0; i < this.objects.length; ++i) {
            Object other = this.objects[i];
            if (other instanceof ChangedValue) {
                ChangedValue change = (ChangedValue)other;
                if (change.newValue == null || !object.equals(change.newValue)) continue;
                change.newValue = object;
                return false;
            }
            if (!object.equals(other)) continue;
            this.objects[i] = object;
            return false;
        }
        if (notifyAdded) {
            this.notifyAddedObject(object);
        }
        Object[] oldArray = this.objects;
        Object[] newArray = new Object[this.objects.length + 1];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        newArray[oldArray.length] = triggerChange ? new ChangedValue(null, object) : object;
        this.objects = newArray;
        return true;
    }

    public void remove(int pos) {
        this.dirty = true;
        if (this.objects[pos] instanceof ChangedValue) {
            if (((ChangedValue)this.objects[pos]).newValue != null) {
                this.notifyRemovedObject(((ChangedValue)this.objects[pos]).newValue);
                ++this.deleted;
                ((ChangedValue)this.objects[pos]).newValue = null;
            }
        } else {
            this.notifyRemovedObject(this.objects[pos]);
            ++this.deleted;
            this.objects[pos] = new ChangedValue(this.objects[pos], null);
        }
    }

    public boolean remove(Object object) {
        return this.remove(object, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(Object object, boolean triggerChange, boolean notifyRemoved) {
        int i;
        block16: {
            if (this.objects == null) {
                this.objects = this.getObjects();
            }
            if (triggerChange) {
                i = 0;
                break block16;
            }
            int i2 = 0;
            while (i2 < this.objects.length) {
                Object other = this.objects[i2];
                if (other instanceof ChangedValue) {
                    ChangedValue change = (ChangedValue)other;
                    if (change.newValue != null && (other == change.newValue || other.equals(change.newValue))) {
                        Object[] newObjects = new Object[this.objects.length - 1];
                        System.arraycopy(this.objects, 0, newObjects, 0, i2);
                        System.arraycopy(this.objects, i2 + 1, newObjects, i2, this.objects.length - (i2 + 1));
                        this.objects = newObjects;
                        return true;
                    }
                } else if (object == other || object.equals(other)) {
                    Object[] newObjects = new Object[this.objects.length - 1];
                    System.arraycopy(this.objects, 0, newObjects, 0, i2);
                    System.arraycopy(this.objects, i2 + 1, newObjects, i2, this.objects.length - (i2 + 1));
                    this.objects = newObjects;
                    return true;
                }
                ++i2;
            }
            return false;
        }
        while (i < this.objects.length) {
            Object other = this.objects[i];
            if (other instanceof ChangedValue) {
                ChangedValue change = (ChangedValue)other;
                if (change.newValue != null && (object == change.newValue || object.equals(change.newValue))) {
                    if (notifyRemoved) {
                        this.notifyRemovedObject(change.newValue);
                    }
                    change.newValue = null;
                    ++this.deleted;
                    this.dirty = true;
                    return true;
                }
            } else if (object == other || object.equals(other)) {
                if (notifyRemoved) {
                    this.notifyRemovedObject(other);
                }
                this.objects[i] = new ChangedValue(other, null);
                ++this.deleted;
                this.dirty = true;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void __setDirty(Object referer) {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearRemoved() {
        if (this.deleted == 0) {
            return;
        }
        int length = this.objects.length;
        for (int i = 0; i < length; ++i) {
            if (!(this.objects[i] instanceof ChangedValue)) continue;
            this.objects[i] = this.objects[length-- - 1];
            --i;
        }
        if (length != this.objects.length) {
            Object[] newValues = new Object[length];
            System.arraycopy(this.objects, 0, newValues, 0, length);
            this.objects = newValues;
        }
        this.deleted = 0;
    }

    public void __clearDirty() {
    }

    public void updateManyToMany(Object instance, boolean add) {
        if (add) {
            this.add(instance, false, true);
        } else {
            this.remove(instance, false, true);
        }
    }

    public void initializeObject(Object object) {
    }

    public void notifyAddedObject(Object object) {
        this.initializeObject(object);
    }

    public void notifyRemovedObject(Object object) {
    }

    public EvermindEntityContext __getContext() {
        return this.context;
    }
}

