/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.io.IOUtils;
import com.evermind.security.User;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.EJBContainerConfig;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.RemoteStatefulSessionEJBObject;
import com.evermind.server.ejb.SessionContainer;
import com.evermind.server.ejb.StatefulSessionContext;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.TimeoutExpiredException;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.logging.EJBLifecycleMessages;
import com.evermind.server.ejb.logging.EJBRuntimeMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.ConfigUtils;
import com.evermind.util.EJBProperties;
import com.evermind.util.LongHashMap;
import com.evermind.util.LongLinkedEntry;
import com.oracle.bricks.j2ee.ReplicationPolicy;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBObject;

public abstract class StatefulSessionEJBHome
extends AbstractEJBHome
implements SessionContainer {
    private static final String DEFINED_INITIAL_ID = EJBProperties.getEJBSFSBInitID();
    private final Object idGeneratorLock;
    private long currentID;
    private LongHashMap instances;
    public ReplicationPolicy replicationPolicy;
    public long sessionTimeout;
    protected long lastCacheCheck;
    protected long cacheCheckInterval;
    protected int lastResourceCheckInterval;
    public boolean allowPassivate;
    private static Logger m_logger = EJBTraceLogger.getLogger(StatefulSessionEJBHome.class);

    public StatefulSessionEJBHome() {
        block5: {
            this.idGeneratorLock = new Object();
            this.instances = new LongHashMap();
            this.cacheCheckInterval = 10000L;
            this.lastResourceCheckInterval = (int)(System.currentTimeMillis() / 1000L);
            this.allowPassivate = true;
            this.cacheCheckInterval = 30000L;
            this.currentID = (long)EJBUtils.getRandomInt() << 32;
            if (DEFINED_INITIAL_ID != null) {
                try {
                    int firstIndex = DEFINED_INITIAL_ID.indexOf("0x") == 0 ? 2 : 0;
                    int digit = DEFINED_INITIAL_ID.indexOf("0x") == 0 ? 16 : 10;
                    this.currentID = Long.valueOf(DEFINED_INITIAL_ID.substring(firstIndex), digit);
                }
                catch (NumberFormatException e) {
                    if (!m_logger.isLoggable(Level.FINE)) break block5;
                    m_logger.log(Level.FINE, "Ignored SFSB Initial ID: " + DEFINED_INITIAL_ID);
                }
            }
        }
        if (this.currentID < 0L) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Remove signed bit from + " + this.currentID);
            }
            this.currentID &= Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextID() {
        Object object = this.idGeneratorLock;
        synchronized (object) {
            return Long.MAX_VALUE == this.currentID ? (this.currentID = 0L) : (this.currentID = this.currentID + 1L);
        }
    }

    public StatefulSessionEJBObject getEJBObject(long id) {
        StatefulSessionEJBObject object = (StatefulSessionEJBObject)this.instances.get(id);
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, this + "StatefulSessionEJBHome.getEJBObject(" + id + ")=" + object);
        }
        return object;
    }

    public File getPassivationDirectory(boolean create) {
        File dirFile = null;
        try {
            SessionBeanDescriptor sessionDescriptor = (SessionBeanDescriptor)this.getBeanDescriptor();
            EJBContainerConfig config = this.container.getConfig();
            if (sessionDescriptor.getPersistenceFilename() == null || config.getPersistenceURL() == null) {
                return null;
            }
            URL dirURL = ConfigUtils.getURL(config.getPersistenceURL(), sessionDescriptor.getPersistenceFilename());
            dirFile = new File(dirURL.getFile());
            if (!dirFile.exists()) {
                if (create) {
                    IOUtils.makePath(new File(dirFile.getCanonicalPath() + File.separator + "dummy"));
                } else {
                    dirFile = null;
                }
            }
        }
        catch (Throwable t) {
            dirFile = null;
        }
        return dirFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkMaxInstancesCount() {
        long newCallTimeout = this._desc.getCallTimeout();
        Object object = this._desc.__poolLock;
        synchronized (object) {
            while (true) {
                Object var9_6;
                long startTime = System.currentTimeMillis();
                if (this._desc.getMaxInstances() <= 0 || this._desc.__activeInstancesCount < this._desc.getMaxInstances()) {
                    ++this._desc.__activeInstancesCount;
                    this._desc.updateActiveInstancesHighWaterMark();
                    return;
                }
                boolean passivatedBean = this.passivateLRUSession();
                newCallTimeout -= System.currentTimeMillis() - startTime;
                if (passivatedBean) continue;
                startTime = System.currentTimeMillis();
                try {
                    try {
                        ++this._desc.__waitingForInstance;
                        if (newCallTimeout >= 0L) {
                            EJBLifecycleMessages.finerWaitingSFSBContextInstance(this._desc, this._desc.__poolLock);
                            this._desc.__poolLock.wait(newCallTimeout);
                        }
                    }
                    catch (InterruptedException e) {
                        m_logger.log(Level.WARNING, "Caught interruptedException: " + e.getMessage());
                        var9_6 = null;
                        --this._desc.__waitingForInstance;
                        if ((newCallTimeout -= System.currentTimeMillis() - startTime) > 0L) continue;
                        throw new TimeoutExpiredException("timeout expired waiting for an instance");
                    }
                    var9_6 = null;
                    --this._desc.__waitingForInstance;
                }
                catch (Throwable throwable) {
                    var9_6 = null;
                    --this._desc.__waitingForInstance;
                    if ((newCallTimeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new TimeoutExpiredException("timeout expired waiting for an instance");
                    }
                    throw throwable;
                }
                if ((newCallTimeout -= System.currentTimeMillis() - startTime) <= 0L) break;
            }
            throw new TimeoutExpiredException("timeout expired waiting for an instance");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean passivateLRUSession() {
        if (!this.allowPassivate) {
            return false;
        }
        StatefulSessionEJBObject oldestBeanObject = null;
        LongHashMap longHashMap = this.instances;
        synchronized (longHashMap) {
            Iterator i = this.instances.entrySet().iterator();
            while (i.hasNext()) {
                StatefulSessionEJBObject object = (StatefulSessionEJBObject)((LongLinkedEntry)i.next()).getValue();
                if (object.OC4J_isPassivated() || object.isInCall() || !object.allowPassivate) continue;
                if (oldestBeanObject == null) {
                    oldestBeanObject = object;
                    continue;
                }
                if (oldestBeanObject.lastAccessedTime <= object.lastAccessedTime) continue;
                oldestBeanObject = object;
            }
        }
        if (oldestBeanObject != null) {
            try {
                if (!oldestBeanObject.OC4J_isPassivated()) {
                    return oldestBeanObject.passivateBean();
                }
            }
            catch (Exception e) {
                EJBLifecycleMessages.finerErrorInSFSBPassivation(this.getBeanDescriptor(), e);
            }
        }
        return false;
    }

    public void remove(long id) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, this + "StatefulSessionEJBHome.remove(" + id + ")");
        }
        StatefulSessionEJBObject sfsbObject = (StatefulSessionEJBObject)this.instances.get(id);
        try {
            this.container.replicationService.remove(sfsbObject);
            sfsbObject.remove_X();
        }
        catch (Throwable t) {
            this.OC4J_log("Error removing session id " + id, t);
        }
    }

    public void setCacheCheckInterval() {
        if (this.sessionTimeout > 0L && this.sessionTimeout < this.cacheCheckInterval) {
            this.cacheCheckInterval = this.sessionTimeout;
        }
        if (this.allowPassivate) {
            long idletimeInMillis = (long)((SessionBeanDescriptor)this.getBeanDescriptor()).getIdletime() * 1000L;
            long resourceCheckIntervalInMillis = (long)((SessionBeanDescriptor)this.getBeanDescriptor()).getResourceCheckInterval() * 1000L;
            if (this.cacheCheckInterval <= 0L && idletimeInMillis > 0L || idletimeInMillis < this.cacheCheckInterval && idletimeInMillis > 0L) {
                this.cacheCheckInterval = idletimeInMillis;
            }
            if (this.cacheCheckInterval <= 0L && resourceCheckIntervalInMillis > 0L || resourceCheckIntervalInMillis < this.cacheCheckInterval && resourceCheckIntervalInMillis > 0L) {
                this.cacheCheckInterval = resourceCheckIntervalInMillis;
            }
        }
    }

    public void cleanUpMaintenance() {
        this.processTimedOutSessions(this.allowPassivate);
        if (this.allowPassivate) {
            this.passivateOutOfResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTimedOutSessions(boolean passivate) {
        StatefulSessionEJBObject object;
        Iterator i;
        long idleTimeout = (long)((SessionBeanDescriptor)this.getBeanDescriptor()).getIdletime() * 1000L;
        if (!(this.sessionTimeout > 0L || idleTimeout > 0L && passivate)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long invalidationTime = currentTime - this.sessionTimeout;
        long passivationTime = currentTime - idleTimeout;
        ArrayList<StatefulSessionEJBObject> removeList = new ArrayList<StatefulSessionEJBObject>();
        ArrayList<StatefulSessionEJBObject> passivateList = new ArrayList<StatefulSessionEJBObject>();
        LongHashMap longHashMap = this.instances;
        synchronized (longHashMap) {
            i = this.instances.entrySet().iterator();
            while (i.hasNext()) {
                object = (StatefulSessionEJBObject)((LongLinkedEntry)i.next()).getValue();
                if (object.lastAccessedTime > currentTime) {
                    object.lastAccessedTime = currentTime;
                }
                if (this.sessionTimeout > 0L && object.lastAccessedTime < invalidationTime) {
                    removeList.add(object);
                    continue;
                }
                if (!passivate || idleTimeout <= 0L || object.lastAccessedTime >= passivationTime) continue;
                passivateList.add(object);
            }
        }
        Iterator i2 = removeList.iterator();
        while (i2.hasNext()) {
            StatefulSessionEJBObject object2 = (StatefulSessionEJBObject)i2.next();
            currentTime = System.currentTimeMillis();
            invalidationTime = currentTime - this.sessionTimeout;
            try {
                if (object2.lastAccessedTime >= invalidationTime || object2.isInCall()) continue;
                EJBLifecycleMessages.finerSessionTimedOut(this.getBeanDescriptor(), object2.OC4J_getId());
                object2.remove_X();
            }
            catch (Throwable t) {
                this.OC4J_log("Error removing timed out session", t);
            }
        }
        int sessionPassivateCount = 0;
        i = passivateList.iterator();
        while (i.hasNext()) {
            object = (StatefulSessionEJBObject)i.next();
            currentTime = System.currentTimeMillis();
            passivationTime = currentTime - idleTimeout;
            try {
                if (object.lastAccessedTime >= passivationTime || !object.allowPassivate || object.OC4J_isPassivated() || object.isInCall()) continue;
                object.passivateBean();
                ++sessionPassivateCount;
            }
            catch (Throwable t) {
                EJBLifecycleMessages.finerErrorInSFSBPassivation(this.getBeanDescriptor(), t);
            }
        }
        if (sessionPassivateCount > 0) {
            EJBLifecycleMessages.finePassivatedSessions(this.getBeanDescriptor(), sessionPassivateCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passivateOutOfResources() {
        SessionBeanDescriptor beanDescriptor = (SessionBeanDescriptor)this.getBeanDescriptor();
        int resourceCheckInterval = beanDescriptor.getResourceCheckInterval();
        int passivateCount = beanDescriptor.getPassivateCount();
        if (resourceCheckInterval <= 0 || passivateCount <= 0 || !this.hasResourceThreshhold(beanDescriptor)) {
            return;
        }
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        if (resourceCheckInterval + this.lastResourceCheckInterval < currentTime) {
            this.lastResourceCheckInterval = currentTime + resourceCheckInterval;
            if (this.memoryThreshholdExceeded(beanDescriptor) || this.maxInstanceThreshholdExceeded(beanDescriptor)) {
                StatefulSessionEJBObject object;
                StatefulSessionEJBObject[] lruBeans = null;
                int insertPos = 0;
                LongHashMap longHashMap = this.instances;
                synchronized (longHashMap) {
                    if (this.instances.size() <= 0) {
                        return;
                    }
                    lruBeans = new StatefulSessionEJBObject[this.instances.size()];
                    Iterator iterator = this.instances.entrySet().iterator();
                    while (iterator.hasNext()) {
                        object = (StatefulSessionEJBObject)((LongLinkedEntry)iterator.next()).getValue();
                        if (object.OC4J_isPassivated() || object.isInCall() || !object.allowPassivate) continue;
                        lruBeans[insertPos] = object;
                        ++insertPos;
                    }
                    if (insertPos > 0) {
                        this.quickSortForLRU(lruBeans, insertPos);
                    }
                }
                int sessionPassivateCount = 0;
                for (int i = 0; i < insertPos && lruBeans[i] != null; ++i) {
                    try {
                        object = lruBeans[i];
                        if (object.OC4J_isPassivated() || object.isInCall() || !object.allowPassivate) continue;
                        object.passivateBean();
                        if (++sessionPassivateCount < passivateCount) continue;
                        break;
                    }
                    catch (Throwable t) {
                        EJBLifecycleMessages.finerErrorInSFSBPassivation(this.getBeanDescriptor(), t);
                    }
                }
                if (sessionPassivateCount > 0) {
                    EJBLifecycleMessages.finePassivatedSessions(this.getBeanDescriptor(), sessionPassivateCount);
                }
            }
        }
    }

    private boolean hasResourceThreshhold(SessionBeanDescriptor beanDescriptor) {
        return beanDescriptor.getMemoryThreshold() > 0 || beanDescriptor.getMaxInstancesThreshold() > 0 && beanDescriptor.getMaxInstances() > 0;
    }

    private boolean memoryThreshholdExceeded(SessionBeanDescriptor beanDescriptor) {
        if (beanDescriptor.getMemoryThreshold() <= 0) {
            return false;
        }
        double freeMemory = Runtime.getRuntime().freeMemory();
        double totalMemory = Runtime.getRuntime().totalMemory();
        int memoryUsed = (int)Math.round((totalMemory - freeMemory) / totalMemory * 100.0);
        if (memoryUsed >= beanDescriptor.getMemoryThreshold()) {
            EJBRuntimeMessages.warningMaxMemoryThresholdReached(beanDescriptor, memoryUsed, beanDescriptor.getMemoryThreshold());
            return true;
        }
        return false;
    }

    private boolean maxInstanceThreshholdExceeded(SessionBeanDescriptor beanDescriptor) {
        if (beanDescriptor.getMaxInstancesThreshold() <= 0 || this.getBeanDescriptor().getMaxInstances() <= 0) {
            return false;
        }
        int maxInstancesPercentage = (int)Math.round((double)this.getBeanDescriptor().__activeInstancesCount / (double)this.getBeanDescriptor().getMaxInstances() * 100.0);
        if (maxInstancesPercentage >= beanDescriptor.getMaxInstancesThreshold()) {
            EJBRuntimeMessages.warningMaxInstanceThresholdReached(beanDescriptor, maxInstancesPercentage, beanDescriptor.getMaxInstancesThreshold());
            return true;
        }
        return false;
    }

    private void quickSortForLRU(StatefulSessionEJBObject[] arrayOfBeans, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (lo >= hi) {
            return;
        }
        if (lo == hi - 1) {
            if (arrayOfBeans[lo].lastAccessedTime > arrayOfBeans[hi].lastAccessedTime) {
                StatefulSessionEJBObject tempObject = arrayOfBeans[lo];
                arrayOfBeans[lo] = arrayOfBeans[hi];
                arrayOfBeans[hi] = tempObject;
            }
            return;
        }
        StatefulSessionEJBObject pivotObject = arrayOfBeans[(lo + hi) / 2];
        arrayOfBeans[(lo + hi) / 2] = arrayOfBeans[hi];
        arrayOfBeans[hi] = pivotObject;
        while (lo < hi) {
            while (arrayOfBeans[lo].lastAccessedTime <= pivotObject.lastAccessedTime && lo < hi) {
                ++lo;
            }
            while (pivotObject.lastAccessedTime <= arrayOfBeans[hi].lastAccessedTime && lo < hi) {
                --hi;
            }
            if (lo >= hi) continue;
            StatefulSessionEJBObject tempObject = arrayOfBeans[lo];
            arrayOfBeans[lo] = arrayOfBeans[hi];
            arrayOfBeans[hi] = tempObject;
        }
        arrayOfBeans[hi0] = arrayOfBeans[hi];
        arrayOfBeans[hi] = pivotObject;
        this.quickSortForLRU(arrayOfBeans, lo0, lo - 1);
        this.quickSortForLRU(arrayOfBeans, hi + 1, hi0);
    }

    private void quickSortForLRU(StatefulSessionEJBObject[] arrayOfBeans, int arrayLength) {
        this.quickSortForLRU(arrayOfBeans, 0, arrayLength - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSessions() {
        ArrayList itemsToRemove;
        StatefulSessionEJBHome statefulSessionEJBHome = this;
        synchronized (statefulSessionEJBHome) {
            itemsToRemove = new ArrayList(this.instances.values());
        }
        EJBLifecycleMessages.warningInvalidatingSessions(this.getBeanDescriptor());
        for (int i = 0; i < itemsToRemove.size(); ++i) {
            try {
                StatefulSessionEJBObject object = (StatefulSessionEJBObject)itemsToRemove.get(i);
                if (object.isInCall()) continue;
                object.remove_X();
                continue;
            }
            catch (Throwable t) {
                this.OC4J_log("Error removing session", t);
            }
        }
    }

    public LongHashMap getInstances() {
        return this.instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstance(StatefulSessionEJBObject wrapper) {
        LongHashMap longHashMap = this.instances;
        synchronized (longHashMap) {
            this.instances.put(wrapper.OC4J_getId(), (Object)wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstance(StatefulSessionEJBObject wrapper) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, this + "Removing Session Bean with id of: " + wrapper.OC4J_getId());
        }
        LongHashMap longHashMap = this.instances;
        synchronized (longHashMap) {
            this.instances.remove(wrapper.OC4J_getId());
        }
        try {
            this.container.replicationService.remove(wrapper);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentID(long currentID) {
        Object object = this.idGeneratorLock;
        synchronized (object) {
            this.currentID = currentID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCurrentID() {
        Object object = this.idGeneratorLock;
        synchronized (object) {
            return this.currentID;
        }
    }

    public Object getSession(long id, long checksum) {
        User user = ThreadState.getCurrentState().getUser();
        return this.getSession(id, checksum, user == null ? null : user.getName());
    }

    public StatefulSessionEJBObject getSession(long id, long checksum, String username) {
        return this.getSession(id, checksum, username, true);
    }

    public StatefulSessionEJBObject getSession(long id, long checksum, String username, boolean lookup) {
        StatefulSessionEJBObject object = (StatefulSessionEJBObject)this.instances.get(id);
        EJBLifecycleMessages.finerSFSBSessionInfo(this.getBeanDescriptor(), id, checksum, username, object);
        if (object != null && object.OC4J_getChecksum() == checksum) {
            return object;
        }
        if (lookup) {
            this.container.replicationService.requestSession(this.bindingPath, id, checksum);
            StatefulSessionEJBObject obj = this.getSession(id, checksum, username, false);
            this.container.replicationService.reified(obj, id);
            return obj;
        }
        return null;
    }

    public abstract StatefulSessionEJBObject getWrapperInstance(StatefulSessionContext var1, long var2, long var4, String var6);

    public EJBObject getRemoteSession(long id, long checksum) {
        RemoteStatefulSessionEJBObject obj = (RemoteStatefulSessionEJBObject)this.getSession(id, checksum);
        return obj;
    }
}

