/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.EJBInternalInputStream;
import com.evermind.server.ejb.EJBInternalOutputStream;
import com.evermind.server.ejb.EJBPrivileged;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.InvocationContextPool;
import com.evermind.server.ejb.LocalReplicationService;
import com.evermind.server.ejb.RemoteStatefulSessionEJBHome;
import com.evermind.server.ejb.RemoteStatefulSessionEJBObject;
import com.evermind.server.ejb.SessionReplicationService;
import com.evermind.server.ejb.StatefulSessionContext;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionObjectInfo;
import com.evermind.server.ejb.TimeoutExpiredException;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.interceptor.MethodState;
import com.evermind.server.ejb.interceptor.system.DMSInterceptor;
import com.evermind.server.ejb.interceptor.system.TxLifecycleCallback;
import com.evermind.server.ejb.logging.EJBLifecycleMessages;
import com.evermind.server.ejb.logging.EJBRuntimeMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.rmi.ObjectInfo;
import com.evermind.server.rmi.ObjectInfoFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.SessionSynchronization;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import oracle.as.j2ee.transaction.TransactionState;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.util.ClassUtils;

public class StatefulSessionEJBObject
extends AbstractEJBObject
implements ObjectInfoFactory,
TxLifecycleCallback {
    protected Object object;
    private long id;
    private long checksum;
    protected long creationTime;
    protected long lastAccessedTime;
    protected boolean invalidated;
    protected boolean invalidated_but_not_removed_yet = false;
    protected StatefulSessionContext context;
    private String user;
    private int callerWaiting;
    private boolean shouldReplicate;
    private boolean denyRemoveInTransaction;
    private boolean containerManagedTransactions;
    protected boolean passivated;
    protected boolean allowPassivate = true;
    protected Transaction suspendedBMTTransaction = null;
    protected static PhaseEventIntf afterCompletion__1_clientPE = null;
    static final long serialVersionUID = ClassUtils.computeSerialVersionUID("com.evermind.server.ejb.StatefulSessionEJBObject");
    private static Logger m_logger = EJBTraceLogger.getLogger(StatefulSessionEJBObject.class);

    public StatefulSessionEJBObject(AbstractEJBHome home, StatefulSessionContext context, boolean _isRemote) {
        super(home);
        long id = 0L;
        id = !_isRemote ? ((StatefulSessionEJBHome)context.localHome).getNextID() : ((StatefulSessionEJBHome)context.remoteHome).getNextID();
        long checksum = 0L;
        while (checksum == 0L) {
            checksum = EJBUtils.getRandomLong();
        }
        this.init(home, context, _isRemote, id, checksum, null);
        this.lastAccessedTime = this.creationTime = StatefulSessionEJBObject.OC4J_getCurrentTime();
        if (this.shouldReplicate) {
            this.user = EJBPrivileged.getUserName(ThreadState.getCurrentState());
            home.container.replicationService.create(this);
        }
    }

    public StatefulSessionEJBObject(AbstractEJBHome home, StatefulSessionContext context, long id, long checksum, String user, boolean _isRemote) {
        super(home);
        this.init(home, context, _isRemote, id, checksum, user);
    }

    private void init(AbstractEJBHome home, StatefulSessionContext context, boolean isRemote, long id, long checksum, String user) {
        SessionReplicationService rs;
        this.isRemote = isRemote;
        this.context = context;
        this.setObject(context.object);
        this.id = id;
        this.checksum = checksum;
        this.user = user;
        if (!isRemote) {
            this.context.localWrapper = this;
        } else {
            this.context.remoteWrapper = this;
        }
        if (isRemote && !((rs = home.container.replicationService) instanceof LocalReplicationService)) {
            this.shouldReplicate = true;
        }
        this.containerManagedTransactions = home.containerManagedTransactions;
        if (home.getBeanDescriptor().getEJBPackage().getCompatibility() < 3) {
            this.denyRemoveInTransaction = true;
        }
    }

    public final Object getObject() {
        return this.object;
    }

    public final void setObject(Object object) {
        this.object = object;
    }

    public void remove_X() throws RemoteException, RemoveException {
        this.remove_X(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_X(boolean withActivateBean, boolean forceRelease, boolean directCallFromClient) throws RemoteException, RemoveException {
        if (directCallFromClient && this.invalidated || this.invalidated && !this.invalidated_but_not_removed_yet) {
            this.throwPassivisationException();
        }
        if (this.denyRemoveInTransaction) {
            ApplicationServerTransaction currentTransaction;
            ApplicationServerTransaction applicationServerTransaction = currentTransaction = this.transaction != null ? this.transaction : (ApplicationServerTransaction)this.suspendedBMTTransaction;
            if (currentTransaction != null) {
                throw new RemoveException("Cannot remove a session that is a part of an active transaction (Transaction id: " + currentTransaction.getIDString() + ", status: " + TransactionState.toString(currentTransaction.getTransactionState()) + ")");
            }
        }
        StatefulSessionEJBHome sfsh = (StatefulSessionEJBHome)this.getMyHome();
        sfsh.removeInstance(this);
        boolean wasPassivated = true;
        StatefulSessionEJBObject statefulSessionEJBObject = this;
        synchronized (statefulSessionEJBObject) {
            ThreadState state = ThreadState.getCurrentState();
            ContextContainer previousContainer = state.contextContainer;
            wasPassivated = this.passivated;
            try {
                state.contextContainer = sfsh;
                try {
                    if (this.passivated && withActivateBean) {
                        this.activateBean(false, true, false);
                    }
                    if (!this.invalidated) {
                        this.OC4J_invalidate(true);
                    }
                }
                catch (Throwable t) {
                    sfsh.OC4J_log("Error in ejbRemove()", t);
                }
                this.invalidated = true;
            }
            finally {
                state.contextContainer = previousContainer;
            }
        }
        if (!wasPassivated || forceRelease) {
            this.releaseBeanInstance();
        } else {
            this.resetBeanInstance();
        }
        this.invalidated_but_not_removed_yet = false;
    }

    protected boolean isIdentical_X(StatefulSessionEJBObject other) throws RemoteException {
        if (this.invalidated) {
            this.throwPassivisationException();
        }
        this.lastAccessedTime = StatefulSessionEJBObject.OC4J_getCurrentTime();
        return other.getClass() == this.getClass() && other.id == this.id;
    }

    public static long OC4J_getCurrentTime() {
        return HttpDateFormat.currentTimeMillis();
    }

    public String toString() {
        return "session " + this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction(ThreadState state, boolean success) throws RemoteException {
        StatefulSessionEJBObject statefulSessionEJBObject = this;
        synchronized (statefulSessionEJBObject) {
            this.transaction = null;
        }
        if (this.getObject() instanceof SessionSynchronization) {
            long ctoken = 0L;
            try {
                if (ApplicationServer.DMS_GATE) {
                    if (afterCompletion__1_clientPE == null) {
                        afterCompletion__1_clientPE = DMSInterceptor.createDMSBeanMethodPE(this.getMyHome().getBeanDescriptor().getBeanNoun(), null, "afterCompletion", "oc4j_ejb_method", "client");
                    }
                    ctoken = afterCompletion__1_clientPE.start();
                }
                byte oldAction = this.getContext().getActionTaken();
                try {
                    this.getContext().setActionTaken((byte)17);
                    state.timerDisallowed = true;
                    try {
                        ((SessionSynchronization)this.getObject()).afterCompletion(success);
                    }
                    catch (Exception e) {
                        this.getMyHome().OC4J_log(e);
                    }
                    state.timerDisallowed = false;
                }
                finally {
                    this.getContext().setActionTaken(oldAction);
                }
            }
            finally {
                if (ApplicationServer.DMS_GATE) {
                    afterCompletion__1_clientPE.stop(ctoken);
                }
            }
        }
        try {
            if (this.invalidated && this.invalidated_but_not_removed_yet) {
                this.remove_X(false, true, false);
            }
        }
        catch (Throwable t) {
            this.getMyHome().OC4J_log("Error removing invalidated session", t);
        }
    }

    public void afterBegin() throws RemoteException {
        if (this.context != null && this.context.object != null && this.context.object instanceof SessionSynchronization) {
            ((SessionSynchronization)this.context.object).afterBegin();
        }
    }

    public final void beforeCompletion() throws RemoteException {
        if (this.context != null && this.context.object != null && this.context.object instanceof SessionSynchronization) {
            ((SessionSynchronization)this.context.object).beforeCompletion();
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    private void throwPassivisationException() throws NoSuchObjectException {
        throw new NoSuchObjectException("Session has timed out or was invalidated");
    }

    private void throwLocalPassivisationException() {
        throw new NoSuchObjectLocalException("Session has timed out or was invalidated");
    }

    public final boolean OC4J_isInvalidated() {
        return this.invalidated;
    }

    public void OC4J_invalidate(boolean invokePreDestroy) {
        this.invalidated = true;
        this.invalidated_but_not_removed_yet = true;
        if (invokePreDestroy) {
            try {
                this.invokePreDestroy();
            }
            catch (Throwable e) {
                this.getMyHome().OC4J_log("Error invoking ejbRemove/PreDestroy", e);
            }
        }
    }

    public Object passivate() throws Exception {
        Object bean = this.getObject();
        this.setObject(null);
        this.getBeanDescriptor().getLifecycleManager().prePassivate(bean, this.getContext());
        this.passivated = true;
        return bean;
    }

    private void invokePostActivate() throws EJBException, RemoteException {
        this.getBeanDescriptor().getInterceptorManager().initializeUserInterceptorsForBean(this.getContext());
        this.getBeanDescriptor().getLifecycleManager().postActivate(this.getObject(), this.getContext());
        this.passivated = false;
    }

    private void invokePreDestroy() throws Throwable {
        if (this.getObject() != null) {
            this.getBeanDescriptor().getLifecycleManager().preDestroy(this.getObject(), this.getContext());
        }
    }

    public final boolean OC4J_isPassivated() {
        return this.passivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseBeanInstance() {
        Object object = this.getBeanDescriptor().__poolLock;
        synchronized (object) {
            --this.getBeanDescriptor().__activeInstancesCount;
            this.resetBeanInstance();
            if (this.getBeanDescriptor().__waitingForInstance > 0) {
                this.getBeanDescriptor().__poolLock.notify();
            }
        }
    }

    protected synchronized void resetBeanInstance() {
        this.context.object = null;
        this.context.attributes = null;
        this.context.setUserInterceptorInstances(null);
        if (this.context.getXPCManager() != null) {
            this.context.getXPCManager().closePersistenceContexts();
        }
        this.setObject(null);
    }

    public boolean passivateBean() throws Exception {
        return this.passivateBean(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passivateBean(boolean withReleaseBeanInstance, boolean withEJBPassivate) throws Exception {
        boolean returnValue = false;
        Object beanObject = null;
        File file = null;
        StatefulSessionEJBHome sfsh = (StatefulSessionEJBHome)this.getMyHome();
        StatefulSessionEJBObject statefulSessionEJBObject = this;
        synchronized (statefulSessionEJBObject) {
            if (this.isInCall() || this.invalidated || this.getObject() == null || !this.allowPassivate) {
                return false;
            }
            try {
                File dirFile = sfsh.getPassivationDirectory(true);
                if (dirFile == null) {
                    return false;
                }
                file = new File(dirFile.getCanonicalPath() + File.separator + this.id + ".ser");
                FileOutputStream fileOut = new FileOutputStream(file);
                EJBInternalOutputStream out = new EJBInternalOutputStream(fileOut);
                ThreadState state = ThreadState.getCurrentState();
                ContextContainer oldContext = state.contextContainer;
                try {
                    state.contextContainer = sfsh;
                    out.writeLong(this.id);
                    out.writeLong(this.checksum);
                    out.writeUTF(this.user == null ? "" : this.user);
                    out.writeLong(this.creationTime);
                    out.writeLong(this.lastAccessedTime);
                    out.sessionContext = this.context;
                    out.writeObject(this.context.attributes);
                    beanObject = this.getObject();
                    if (!this.passivated && withEJBPassivate) {
                        this.passivate();
                    }
                    out.writeObject(beanObject);
                    out.writeObject(this.context.getUserInterceptorInstances());
                    returnValue = true;
                    Object var14_15 = null;
                    state.contextContainer = oldContext;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    state.contextContainer = oldContext;
                    out.flush();
                    out.close();
                    fileOut.close();
                    throw throwable;
                }
                out.flush();
                out.close();
                fileOut.close();
                {
                }
            }
            catch (Throwable t) {
                this.allowPassivate = false;
                EJBLifecycleMessages.warningSFSBSerializingSession(this.getBeanDescriptor(), t.getMessage());
            }
        }
        if (!returnValue) {
            if (file != null) {
                file.delete();
            }
            if (beanObject != null) {
                statefulSessionEJBObject = this;
                synchronized (statefulSessionEJBObject) {
                    this.setObject(beanObject);
                }
                try {
                    this.invokePostActivate();
                }
                catch (Throwable t) {
                    EJBLifecycleMessages.warningSFSBInEjbActivate(this.getBeanDescriptor());
                    throw new Exception("Error in ejbActivate() after an unsuccesful passivate");
                }
            }
        } else {
            ++this.getBeanDescriptor().__passivatedInstancesCount;
            if (withReleaseBeanInstance) {
                this.releaseBeanInstance();
            } else {
                this.resetBeanInstance();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateBean(boolean withCheckMaxInstances, boolean withEJBActivate, boolean withRemove) throws RemoteException {
        StatefulSessionEJBHome sfsh = (StatefulSessionEJBHome)this.getMyHome();
        File file = null;
        boolean maxInstancesIncremented = false;
        try {
            File dirFile = sfsh.getPassivationDirectory(false);
            if (dirFile == null) {
                throw new FileNotFoundException("Activation cannot find the Passivation directory");
            }
            if (withCheckMaxInstances) {
                sfsh.checkMaxInstancesCount();
                maxInstancesIncremented = true;
            }
            StatefulSessionEJBObject statefulSessionEJBObject = this;
            synchronized (statefulSessionEJBObject) {
                FileInputStream fileIn;
                block24: {
                    block23: {
                        if (this.passivated) break block23;
                        return;
                    }
                    file = new File(dirFile.getCanonicalPath() + File.separator + this.id + ".ser");
                    ThreadState state = ThreadState.getCurrentState();
                    ContextContainer oldContext = state.contextContainer;
                    fileIn = null;
                    EJBInternalInputStream in = null;
                    try {
                        state.contextContainer = sfsh;
                        fileIn = new FileInputStream(file);
                        in = new EJBInternalInputStream((InputStream)fileIn, sfsh);
                        long tempId = in.readLong();
                        long tempChecksum = in.readLong();
                        String tempUsername = in.readUTF();
                        long tempCreationTime = in.readLong();
                        long tempLastAccessedTime = in.readLong();
                        in.sessionContext = this.context;
                        this.context.attributes = (Hashtable)in.readObject();
                        this.context.object = in.readObject();
                        this.context.setUserInterceptorInstances((Object[])in.readObject());
                        this.setObject(this.context.object);
                        if (withEJBActivate) {
                            this.invokePostActivate();
                        }
                        Object var23_20 = null;
                        --this.getBeanDescriptor().__passivatedInstancesCount;
                        state.contextContainer = oldContext;
                        if (in == null) break block24;
                    }
                    catch (Throwable throwable) {
                        Object var23_21 = null;
                        --this.getBeanDescriptor().__passivatedInstancesCount;
                        state.contextContainer = oldContext;
                        if (in != null) {
                            in.close();
                        }
                        if (fileIn != null) {
                            fileIn.close();
                        }
                        throw throwable;
                    }
                    in.close();
                }
                if (fileIn != null) {
                    fileIn.close();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                if (withRemove && !(t instanceof TimeoutExpiredException)) {
                    this.remove_X(false, maxInstancesIncremented, false);
                }
            }
            catch (Throwable t2) {
                this.OC4J_log("activateBean encounters an Error in removing session id " + this.id, t2);
            }
            if (t instanceof TimeoutExpiredException) {
                this.OC4J_log("Error in activation, TimeoutExpiredException is thrown", t);
                throw (TimeoutExpiredException)((Object)t);
            }
            String message = "Error deserializing EJB-session '" + sfsh.OC4J_getBindingPath() + "': " + (t instanceof FileNotFoundException ? "Bean not found" : t.getMessage());
            this.OC4J_log(message, t);
            throw new RemoteException(message);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public final long OC4J_getId() {
        return this.id;
    }

    public final long OC4J_getChecksum() {
        return this.checksum;
    }

    public final String OC4J_getUserName() {
        return this.user;
    }

    public final void OC4J_setUserName(String user) {
        this.user = user;
    }

    public final long OC4J_getCreationTime() {
        return this.creationTime;
    }

    public final long OC4J_getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public final StatefulSessionContext getContext() {
        return this.context;
    }

    public boolean isInCall() {
        return this.currentCaller != null || this.transaction != null || this.suspendedBMTTransaction != null;
    }

    public ObjectInfo createObjectInfo() {
        return new StatefulSessionObjectInfo(((ExposableBeanDescriptor)this.getBeanDescriptor()).getQualifiedLocation(), this.OC4J_getId(), this.OC4J_getChecksum());
    }

    public synchronized boolean OC4J_transactionStartCall(InvocationContext ctx) throws Exception {
        if (this.currentCaller != null) {
            if (this.currentCaller == ctx.getCurrentThreadState()) {
                String message = "Recursive call to non-reentrant bean";
                if (ctx.getMethodState().isLocal()) {
                    throw EJBUtils.createEJBException(message);
                }
                throw new OracleRemoteException(message);
            }
            String message = "Second thread call to stateful session bean";
            if (ctx.getMethodState().isLocal()) {
                throw EJBUtils.createEJBException(message);
            }
            throw new OracleRemoteException(message);
        }
        this.currentCaller = ctx.getCurrentThreadState();
        this.lastAccessedTime = StatefulSessionEJBObject.OC4J_getCurrentTime();
        return false;
    }

    public void OC4J_transactionPreExecute(InvocationContext ctx) throws Exception {
        ApplicationServerTransaction tx;
        if (this.invalidated) {
            if (ctx.getMethodState().isLocal()) {
                this.throwLocalPassivisationException();
            } else {
                this.throwPassivisationException();
            }
        }
        if (this.passivated) {
            if (ctx.getMethodState().isLocal()) {
                try {
                    this.activateBean(true, true, true);
                }
                catch (RemoteException e) {
                    throw EJBUtils.createEJBException(e);
                }
            } else {
                this.activateBean(true, true, true);
            }
            ctx.setTarget(this.object);
        }
        if (this.containerManagedTransactions && this.transaction == null && (tx = (ApplicationServerTransaction)EJBTransactionManager.getTransaction()) != null) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.fine("Registering stateful session " + this + " with transaction " + EJBTransactionManager.getTransaction());
            }
            tx.registerBean(this, false);
            this.transaction = tx;
        }
    }

    public synchronized void OC4J_transactionEndCall(InvocationContext ctx, boolean reentrant) throws Exception {
        if (this.shouldReplicate) {
            try {
                RemoteStatefulSessionEJBObject sfsbObj = (RemoteStatefulSessionEJBObject)this;
                RemoteStatefulSessionEJBHome sfsbH = (RemoteStatefulSessionEJBHome)sfsbObj.getMyHome();
                if (sfsbH.replicationPolicy.isOnCall() || sfsbH.replicationPolicy.isOnChange()) {
                    sfsbH.container.replicationService.MigrateSFSBAtEndCall(sfsbObj);
                }
            }
            catch (ClassCastException e) {
            }
            catch (NamingException e) {
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentCaller = null;
        if (this.callerWaiting > 0) {
            this.notify();
        }
    }

    public void OC4J_transactionPostSuspend(InvocationContext ctx) throws Exception {
        if (this.suspendedBMTTransaction != null) {
            if (ctx.getMethodState().isLocal()) {
                EJBTransactionManager.getInstance().resumeLocal(this.suspendedBMTTransaction);
            } else {
                EJBTransactionManager.getInstance().resumeRemote(this.suspendedBMTTransaction);
            }
            this.suspendedBMTTransaction = null;
        }
    }

    public void OC4J_transactionPreResume(InvocationContext ctx) throws Exception {
        Transaction tx = EJBTransactionManager.getTransaction();
        if (tx != null && tx.getStatus() == 0) {
            this.suspendedBMTTransaction = ctx.getMethodState().isLocal() ? EJBTransactionManager.getInstance().suspendLocal() : EJBTransactionManager.getInstance().suspendRemote();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OC4J_transactionSystemException(InvocationContext ctx, Throwable t) {
        try {
            this.OC4J_invalidate(false);
            if (EJBTransactionManager.getTransaction() == null) {
                this.remove_X();
            }
        }
        catch (Throwable t1) {
            this.getMyHome().OC4J_log("Error in ejbRemove", t1);
        }
        finally {
            this.invalidated = true;
            this.context.object = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean OC4J_transactionRetry(InvocationContext ctx, Throwable t) {
        StatefulSessionEJBObject statefulSessionEJBObject = this;
        synchronized (statefulSessionEJBObject) {
            this.transaction = null;
        }
        return !this.invalidated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object OC4J_invokeMethod(MethodState state, Object[] params, ThreadState thread) throws Exception {
        ContextContainer previousContainer = thread.contextContainer;
        try {
            thread.contextContainer = this.home;
            Object object = InvocationContextPool.invoke(thread, state, this.object, this.context, params, this, this.home);
            return object;
        }
        finally {
            thread.contextContainer = previousContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void OC4J_waitForWrapper() {
        long startTime = System.currentTimeMillis();
        long callTimeout = this.getBeanDescriptor().getCallTimeout();
        while (this.currentCaller != null) {
            ++this.callerWaiting;
            try {
                this.wait(this.getBeanDescriptor().getCallTimeout());
            }
            catch (InterruptedException e) {
                break;
            }
            finally {
                --this.callerWaiting;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - startTime <= callTimeout) continue;
            break;
        }
        if (this.currentCaller != null) {
            EJBRuntimeMessages.warningTimeoutWaitingForActiveCalls(this.getBeanDescriptor().getName(), 1);
        }
    }

    public void OC4J_setAllowPassivate(boolean allowPassivate) {
        this.allowPassivate = allowPassivate;
    }
}

