/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.Compilable;
import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.util.ByteString;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public abstract class ClassCompilation
implements Compilable {
    private static int id = 0;
    protected List handledMethods = new ArrayList();
    protected List methods = new ArrayList();
    protected ByteString source = new ByteString(256);
    public ByteString staticFuncSource = new ByteString(256);
    public ByteString staticDeclSource = new ByteString(256);
    protected String className;
    protected Class interfaceClass;

    public boolean areYouRemote() {
        return true;
    }

    public ClassCompilation(String className, Class interfaceClass) {
        this(className, interfaceClass, true);
    }

    public ClassCompilation(String className, Class interfaceClass, boolean addCounter) {
        this.interfaceClass = interfaceClass;
        String interfaceName = interfaceClass.getName();
        int dotPos = interfaceName.lastIndexOf(46);
        if (dotPos >= 0) {
            interfaceName = interfaceName.substring(dotPos + 1);
        }
        this.className = addCounter ? interfaceName + '_' + className + ClassCompilation.getNextID() : interfaceName;
    }

    protected void addDmsImports() {
        this.source.append("// DMS begins\n");
        this.source.append("import com.evermind.server.ApplicationServer;\nimport oracle.dms.instrument.PhaseEventIntf;\n");
        this.source.append("// DMS ends\n");
    }

    public ByteString getSource() {
        return this.source;
    }

    public String getName() {
        return this.className;
    }

    public void resetSource() {
        this.handledMethods = null;
        this.source.reset();
        this.staticFuncSource.reset();
        this.staticDeclSource.reset();
        if (this.methods != null && this.methods.size() > 0) {
            for (int i = 0; i < this.methods.size(); ++i) {
                MethodCompilation meth = (MethodCompilation)this.methods.get(i);
                meth.reset();
            }
            this.methods = new ArrayList(0);
        }
    }

    protected void appendMethods() {
        for (int i = 0; i < this.methods.size(); ++i) {
            this.source.append(((MethodCompilation)this.methods.get(i)).getSource());
            this.staticDeclSource.append(((MethodCompilation)this.methods.get((int)i)).staticDeclSource);
            this.staticFuncSource.append(((MethodCompilation)this.methods.get((int)i)).staticFuncSource);
        }
    }

    public abstract void compile() throws CompilationException;

    public void preCompile() throws CompilationException {
    }

    protected void compileMethods() throws CompilationException {
        this.compileMethods(this.interfaceClass);
    }

    protected void compileMethods(Class intfClass) throws CompilationException {
        Method[] methodDefinitions = intfClass.getMethods();
        for (int i = 0; i < methodDefinitions.length; ++i) {
            Method method = methodDefinitions[i];
            if (Modifier.isStatic(method.getModifiers()) || method.getName().equals("<clinit>")) continue;
            boolean handled = false;
            for (int y = 0; y < this.handledMethods.size(); ++y) {
                Method handledMethod = (Method)this.handledMethods.get(y);
                if (!handledMethod.getName().equals(method.getName()) || !((Object)Arrays.asList(handledMethod.getParameterTypes())).equals(Arrays.asList(method.getParameterTypes()))) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            this.handledMethods.add(method);
            MethodCompilation methodCompilation = this.compileMethod(methodDefinitions[i]);
            if (methodCompilation == null) continue;
            this.methods.add(methodCompilation);
        }
    }

    public abstract MethodCompilation compileMethod(Method var1) throws CompilationException;

    public static int getNextID() {
        return id++;
    }

    protected void appendStaticFunction() {
        if (this.staticFuncSource.length() > 0) {
            this.source.append("\n");
            this.source.append("static {\n");
            this.source.append("if (ApplicationServer.DMS_GATE) {\n");
            this.source.append(this.staticFuncSource);
            this.source.append("\n}\n}\n");
        }
    }

    protected void appendStaticDeclaration() {
        this.source.append(this.staticDeclSource);
    }

    public static String convertRemoteException(String stmt1) {
        return ClassCompilation.convertRemoteException(stmt1, true);
    }

    public static String convertRemoteException(String stmt1, boolean local) {
        if (local) {
            return "\n{\ntry{\n" + stmt1 + ";\n}catch(java.rmi.RemoteException ex) {\nthrow com.evermind.server.ejb.EJBUtils.createEJBException(ex);\n}\n}\n";
        }
        return "\n{" + stmt1 + ";\n}\n";
    }

    protected void addSharedImports() {
        this.source.append("import javax.security.jacc.*;\nimport java.util.logging.*;\nimport com.evermind.server.ejb.interceptor.MethodState;\nimport com.evermind.server.ejb.interceptor.InvocationContextImpl;\nimport com.evermind.server.ejb.interceptor.system.JACCInterceptor;\nimport com.evermind.server.ejb.interceptor.system.SecurityRoleInterceptor;\nimport com.evermind.server.ejb.interceptor.system.DMSInterceptor;\nimport com.evermind.server.ejb.interceptor.system.ExcludeInterceptor;\nimport com.evermind.server.ejb.deployment.ExposableBeanDescriptor;\n\n");
    }

    public Vector getDependentClasses() {
        return null;
    }
}

