/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.BeanMethodCompilation;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

public class InterceptorBeanMethodCompilation
extends BeanMethodCompilation {
    static /* synthetic */ Class class$java$lang$Exception;

    public InterceptorBeanMethodCompilation(ClassCompilation compilation, BeanDescriptor descriptor, Method method, boolean homeMethod, boolean entityMethod, String beanMethodName, boolean local) throws CompilationException {
        super(compilation, descriptor, method, homeMethod, entityMethod, beanMethodName, local);
        this.synced = false;
    }

    public void compile() throws CompilationException {
        this.addMethodWrapperStart();
        this.addInterceptorInvocation();
        this.addMethodWrapperEnd();
    }

    protected void addInterceptorInvocation() {
        Class<?> returnType = this.method.getReturnType();
        if (returnType != Void.TYPE) {
            if (returnType.isPrimitive()) {
                String tempReturnTypeName = ClassUtils.getNonPrimitiveType(returnType).getName();
                this.source.append(tempReturnTypeName + " tempReturn = (" + tempReturnTypeName + ") ");
            } else if (returnType == Object.class) {
                this.source.append("response = ");
            } else {
                this.source.append("response = (" + this.getResponseTypeName() + ") ");
            }
        }
        this.source.append("OC4J_invokeMethod(" + this.getMethodStateVariableName() + ",params, thread);\n");
        if (returnType != Void.TYPE && returnType.isPrimitive()) {
            this.source.append("response = ");
            this.source.append(ClassUtils.getConvertSource("tempReturn", ClassUtils.getNonPrimitiveType(returnType), returnType));
            this.source.append(";\n");
        }
    }

    protected void appendExceptionConversionStart() {
        this.source.append("try {\n");
    }

    protected void appendExceptionConversionEnd() {
        this.source.append("} ");
        boolean throwsException = false;
        List appExceptions = this.gatherApplicationExceptions(false);
        Iterator i = appExceptions.iterator();
        while (i.hasNext()) {
            Class ex = (Class)i.next();
            if (ex == (class$java$lang$Exception == null ? InterceptorBeanMethodCompilation.class$("java.lang.Exception") : class$java$lang$Exception)) {
                throwsException = true;
            }
            this.source.append("catch (" + ex.getName() + " e) {\n" + "throw e;\n" + "}\n");
        }
        if (!throwsException) {
            this.source.append("catch (Exception e) {\n__throwUncheckedException(e);\n}\n");
        }
    }

    protected void appendRunAsStart() {
    }

    protected void appendRunAsEnd() {
    }

    protected void appendSecurityCheck() {
    }

    protected void addMethodWrapperDmsStart() {
    }

    protected void addMethodWrapperDmsEnd() {
    }

    protected void appendExcludeMethod() {
    }
}

