/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.server.ejb.compilation.MessageDrivenBeanMethodCompilation;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptor;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageDrivenBeanCompilation
extends ClassCompilation {
    private MessageDrivenBeanDescriptor m_descriptor;
    private int tabCnt = 0;
    private static Logger m_logger = EJBTraceLogger.getLogger(MessageDrivenBeanCompilation.class);

    public boolean areYouRemote() {
        return false;
    }

    public MessageDrivenBeanCompilation(MessageDrivenBeanDescriptor descriptor) throws InstantiationException {
        super("MessageEndpoint", descriptor.getMessageListener());
        this.m_descriptor = descriptor;
    }

    public void compile() throws CompilationException {
        this.writeln("import javax.ejb.EJBException;");
        this.writeln("import javax.resource.spi.endpoint.MessageEndpoint;");
        this.writeln("import javax.transaction.xa.XAResource;");
        this.writeln("import com.evermind.server.ejb.interceptor.MethodState;");
        this.writeln("import com.evermind.server.ejb.MessageInflowContract;");
        this.writeln("import com.evermind.server.ejb.PrimitiveTypeCache;");
        this.writeln("import oracle.j2ee.connector.messageinflow.*;");
        this.writeln();
        this.writeln("public class " + this.className);
        this.increaseIndent();
        this.writeln("extends oracle.j2ee.connector.messageinflow.MessageEndpointImpl");
        this.writeln("implements MessageEndpoint," + this.interfaceClass.getName());
        this.decreaseIndent();
        this.beginClass();
        this.writeln("public " + this.className + "(MessageInflowContract mdbHome, XAResource res, MessageEndpointFactoryImpl factory)");
        this.beginMethod();
        this.writeln("super(mdbHome, res, factory);");
        this.endMethod();
        this.compileMethods();
        this.appendMethods();
        this.endClass();
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Generating wrapper = " + this.getName() + " for :" + this.m_descriptor.getName());
            m_logger.log(Level.FINE, "Generated code follows: " + this.source);
        }
        this.m_descriptor.setEndpointWrapperName(this.getName());
    }

    public MethodCompilation compileMethod(Method method) throws CompilationException {
        MessageDrivenBeanMethodCompilation methodWrapper = new MessageDrivenBeanMethodCompilation(this, method);
        ((MethodCompilation)methodWrapper).compile();
        return methodWrapper;
    }

    public void cleanSource() {
        this.resetSource();
    }

    void writeln(String s) {
        this.indent();
        this.source.append(s + "\n");
    }

    void writeln() {
        this.source.append("\n");
    }

    void beginMethod() {
        this.writeln("{");
        this.increaseIndent();
    }

    void endMethod() {
        this.endBlock();
    }

    void decreaseIndent() {
        --this.tabCnt;
    }

    void increaseIndent() {
        ++this.tabCnt;
    }

    void indent() {
        for (int i = 0; i < this.tabCnt; ++i) {
            this.source.append("\t");
        }
    }

    void endBlock() {
        this.decreaseIndent();
        this.writeln("}");
    }

    void beginBlock() {
        this.writeln("{");
        this.increaseIndent();
    }

    void beginClass() {
        this.beginBlock();
    }

    void endClass() {
        this.endBlock();
    }
}

