/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.MessageDrivenBeanCompilation;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Method;

public class MessageDrivenBeanMethodCompilation
extends MethodCompilation {
    private int tabCnt = 1;

    public MessageDrivenBeanMethodCompilation(MessageDrivenBeanCompilation declaringClass, Method mthd) {
        super(declaringClass, mthd);
    }

    public void compile() throws CompilationException {
        String methodStateVar = "onMessageMethodState" + MethodCompilation.getNextID();
        this.writeln();
        this.writeln("private MethodState " + methodStateVar + ";\n");
        this.addMethodHeader();
        this.beginMethod();
        String returnVal = null;
        Class<?> returnType = this.method.getReturnType();
        if (returnType != Void.TYPE) {
            returnVal = "retVal";
            this.writeln("Object " + returnVal + " = null;");
        }
        this.writeln("if (" + methodStateVar + " == null) {\n");
        this.increaseIndent();
        this.beginTryBlock();
        this.writeln("java.lang.Class msgListenerIface = Class.forName(\"" + this.declaringClass.interfaceClass.getName() + "\");");
        this.startPartialLn("java.lang.reflect.Method thisMthd = msgListenerIface.getMethod(\"" + this.method.getName() + "\", ");
        Class<?>[] params = this.method.getParameterTypes();
        int numParams = params.length;
        if (numParams > 0) {
            this.continuePartialLn("new Class[] {");
            for (int i = 0; i < numParams; ++i) {
                if (i > 0) {
                    this.continuePartialLn(" , ");
                }
                this.continuePartialLn("Class.forName(\"" + params[i].getName() + "\")");
            }
            this.continuePartialLn("}");
        } else {
            this.continuePartialLn("null");
        }
        this.endPartialLn(");");
        this.writeln(methodStateVar + " = " + "((com.evermind.server.ejb.MessageDrivenHome)getMdbHome()).getMethodState(thisMthd);\n");
        this.endBlock();
        this.beginCatchBlock("Exception e");
        this.writeln("throw com.evermind.server.ejb.EJBUtils.createEJBException(\"Unable to determine the method used for delivery\");");
        this.endBlock();
        this.endBlock();
        this.appendParamsToObjectArray();
        this.writeln("");
        this.beginTryBlock();
        String invocationStr = "invokeMessageInflowCallbacks(" + methodStateVar + ", params);";
        if (returnVal != null) {
            this.writeln("retVal = " + invocationStr);
        } else {
            this.writeln(invocationStr);
        }
        this.endBlock();
        this.beginCatchBlock("Throwable t");
        if (this.exceptions.length > 0) {
            this.writeln("// handle declared application exception");
            int i = 0;
            do {
                this.writeln("if(t.getClass().isAssignableFrom(" + this.exceptions[i].getName() + ".class)) {");
                this.writeln("   throw (" + this.exceptions[i].getName() + ") t;");
                this.writeln("} ");
                if (++i >= this.exceptions.length) continue;
                this.writeln(" else ");
            } while (i < this.exceptions.length);
        }
        this.writeln("// handle system exception if no application exception is declared or matched");
        this.writeln("if(t instanceof EJBException) {");
        this.writeln("   throw (EJBException) t;");
        this.writeln("} else {");
        this.writeln("   throw com.evermind.server.ejb.EJBUtils.createEJBException(new Exception(t));");
        this.writeln("}");
        this.endBlock();
        if (returnVal != null) {
            if (returnType.isPrimitive()) {
                Class primitiveWrapper = ClassUtils.getNonPrimitiveType(returnType);
                String formatedReturnVal = "((" + primitiveWrapper.getName() + ")" + returnVal + ")";
                this.writeln("return " + ClassUtils.getConvertSource(formatedReturnVal, primitiveWrapper, returnType) + ";");
            } else {
                this.writeln("return (" + this.getResponseTypeName() + ")" + returnVal + ";");
            }
        }
        this.endMethod();
    }

    void addMethodHeader() {
        this.indent();
        this.appendMethodWrapperStart(false);
    }

    void startPartialLn(String s) {
        this.indent();
        this.source.append(s);
    }

    void continuePartialLn(String s) {
        this.source.append(s);
    }

    void endPartialLn(String s) {
        this.source.append(s);
        this.writeln();
    }

    void writeln(String s) {
        this.indent();
        this.source.append(s + "\n");
    }

    void writeln() {
        this.source.append("\n");
    }

    void beginMethod() {
        this.writeln("{");
        this.increaseIndent();
    }

    void endMethod() {
        this.endBlock();
    }

    void beginTryBlock() {
        this.writeln("try");
        this.writeln("{");
        this.increaseIndent();
    }

    void beginCatchBlock(String s) {
        this.writeln("catch (" + s + ")");
        this.writeln("{");
        this.increaseIndent();
    }

    void decreaseIndent() {
        --this.tabCnt;
    }

    void increaseIndent() {
        ++this.tabCnt;
    }

    void indent() {
        for (int i = 0; i < this.tabCnt; ++i) {
            this.source.append("\t");
        }
    }

    void endBlock() {
        this.decreaseIndent();
        this.writeln("}");
    }
}

