/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class ContainerManagedRelation
extends AbstractDescribable
implements XMLizable {
    private String type;
    private boolean synthetic;
    private boolean unspecifiedCMRField;
    private ContainerManagedField resolved;

    public ContainerManagedRelation(Node node) throws InstantiationException {
        this.unspecifiedCMRField = this.synthetic;
        this.setName(XMLUtils.getSubnodeValue(node, "cmr-field-name"));
        this.setDescription(XMLUtils.getSubnodeValue(node, "description"));
        this.setType(XMLUtils.getSubnodeValue(node, "cmr-field-type"));
        if (this.getName() == null) {
            throw new InstantiationException("relationship-role-source with missing cmr-field-name subtag");
        }
    }

    public ContainerManagedRelation(String name, String type, boolean synthetic) {
        this.unspecifiedCMRField = this.synthetic;
        this.setName(name);
        this.setType(type);
        this.setSynthetic(synthetic);
        this.unspecifiedCMRField = synthetic;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean unspecifiedCMRField() {
        return this.unspecifiedCMRField;
    }

    public void writeXML(PrintWriter out, String indention) {
        if (!this.synthetic) {
            out.println(indention + "<cmr-field>");
            if (this.getDescription() != null) {
                out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
            }
            if (this.getName() != null) {
                out.println(indention + "\t<cmr-field-name>" + XMLUtils.encode(this.getName()) + "</cmr-field-name>");
            }
            if (this.type != null) {
                out.println(indention + "\t<cmr-field-type>" + XMLUtils.encode(this.type) + "</cmr-field-type>");
            }
            out.println(indention + "</cmr-field>");
        }
    }

    public void setResolved(ContainerManagedField resolved) {
        this.resolved = resolved;
    }

    public ContainerManagedField getResolved() {
        return this.resolved;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.getName() + (this.getType() == null ? "" : " (" + this.getType() + ")");
    }
}

