/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.deployment.InjectableReference;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PersistenceContextReference
extends InjectableReference
implements XMLizable,
Serializable {
    public static final String PERSISTENCE_CTX_CLASS_NAME = "javax.persistence.EntityManager";
    public static final String TRANSACTION = "TRANSACTION";
    public static final String EXTENDED = "EXTENDED";
    public static final String PERSISTENCE_CTX_REF_TAG = "persistence-context-ref";
    private static final String DESCRIPTION_TAG = "description";
    public static final String PERSISTENCE_CTX_REF_NAME_TAG = "persistence-context-ref-name";
    private static final String PERSISTENCE_UNIT_NAME_TAG = "persistence-unit-name";
    private static final String PERSISTENCE_CTX_TYPE_TAG = "persistence-context-type";
    private static final String PERSISTENCE_PROPERTY_TAG = "persistence-property";
    private static final String PROPERTY_NAME_TAG = "name";
    private static final String PROPERTY_VALUE_TAG = "value";
    private String unitName = "";
    private String unitType = "TRANSACTION";
    private Map properties;

    public PersistenceContextReference(String name) {
        super(name);
        this.setReferenceClass(PERSISTENCE_CTX_CLASS_NAME);
    }

    public PersistenceContextReference(Node node) throws InstantiationException {
        this.setReferenceClass(PERSISTENCE_CTX_CLASS_NAME);
        this.parseXML(node);
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String name) {
        this.unitName = name;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public void setUnitType(String unitType) {
        this.unitType = unitType;
    }

    public Map getProperties() {
        if (this.properties == null) {
            return Collections.EMPTY_MAP;
        }
        return this.properties;
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public void parseXML(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (XMLUtils.isCommentOrID(nodeName)) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals(PERSISTENCE_CTX_REF_NAME_TAG)) {
                    this.setName(value);
                    continue;
                }
                if (nodeName.equals(DESCRIPTION_TAG)) {
                    this.setDescription(value);
                    continue;
                }
                if (nodeName.equals(PERSISTENCE_UNIT_NAME_TAG)) {
                    this.setUnitName(value);
                    continue;
                }
                if (nodeName.equals(PERSISTENCE_CTX_TYPE_TAG)) {
                    if (value.equalsIgnoreCase(TRANSACTION)) {
                        this.setUnitType(TRANSACTION);
                        continue;
                    }
                    if (value.equalsIgnoreCase(EXTENDED)) {
                        this.setUnitType(EXTENDED);
                        continue;
                    }
                    throw new InstantiationException("Unknown <persistence-context-type> value: " + value);
                }
                if (nodeName.equals(PERSISTENCE_PROPERTY_TAG)) {
                    this.addProperty(XMLUtils.getSubnodeValue(node, PROPERTY_NAME_TAG), XMLUtils.getSubnodeValue(node, PROPERTY_VALUE_TAG));
                    continue;
                }
                if (this.parseInjectionTarget(node)) continue;
                throw new InstantiationException("Unknown <persistence-context-ref> subtag: " + nodeName);
            }
        }
        if (this.getName() == null || this.getName().equals("")) {
            throw new InstantiationException("<persistence-context-ref> tag with missing <persistence-context-ref-name> subtag");
        }
    }

    public void writeXML(PrintWriter out, String indentation) {
        out.println(indentation + "<" + PERSISTENCE_CTX_REF_TAG + ">");
        this.writeTag(DESCRIPTION_TAG, this.getDescription(), out, indentation);
        this.writeTag(PERSISTENCE_CTX_REF_NAME_TAG, this.getName(), out, indentation);
        this.writeTag(PERSISTENCE_UNIT_NAME_TAG, this.getUnitName(), out, indentation);
        this.writeInjectableXML(out, indentation + "\t");
        out.println(indentation + "</" + PERSISTENCE_CTX_REF_TAG + ">");
    }

    protected void writeTag(String tagName, String tagValue, PrintWriter out, String indentation) {
        if (tagValue != null) {
            out.println(indentation + "\t<" + tagName + ">" + XMLUtils.encode(tagValue) + "</" + tagName + ">");
        }
    }

    public String toString() {
        return "PersistenceUnit: " + this.getUnitName();
    }
}

