/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.deployment.AnnotationManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.BeanDescriptorAnnotationParser;
import com.evermind.server.ejb.deployment.EJBJarAnnotations;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.InitMethod;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.RemoveMethod;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.logging.EJBAnnotationMessages;
import com.oracle.bricks.j2ee.ReplicationPolicy;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.Init;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.jws.WebService;
import oracle.j2ee.deployment.AnnotationParsingMessages;
import oracle.j2ee.ejb.StatefulDeployment;
import oracle.j2ee.ejb.StatelessDeployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBeanDescriptorAnnotationParser
extends BeanDescriptorAnnotationParser {
    private static SessionBeanDescriptorAnnotationParser instance = new SessionBeanDescriptorAnnotationParser();

    private SessionBeanDescriptorAnnotationParser() {
    }

    public static SessionBeanDescriptorAnnotationParser getInstance() {
        return instance;
    }

    @Override
    protected BeanDescriptor getDescriptor(EJBPackage ejbPackage, Class cls) {
        Stateful annot;
        String ejbName = null;
        if (cls.isAnnotationPresent(EJBJarAnnotations.STATEFUL_ANNOTATION)) {
            annot = (Stateful)SessionBeanDescriptorAnnotationParser.getAnnotation(cls, EJBJarAnnotations.STATEFUL_ANNOTATION);
            if (!SessionBeanDescriptorAnnotationParser.valueIsEmpty(annot.mappedName())) {
                AnnotationParsingMessages.infoIgnoredAnnotationAttribute("mappedName", "@Stateful", cls.getName());
            }
            ejbName = annot.name();
        } else {
            annot = (Stateless)SessionBeanDescriptorAnnotationParser.getAnnotation(cls, EJBJarAnnotations.STATELESS_ANNOTATION);
            if (!SessionBeanDescriptorAnnotationParser.valueIsEmpty(annot.mappedName())) {
                AnnotationParsingMessages.infoIgnoredAnnotationAttribute("mappedName", "@Stateless", cls.getName());
            }
            ejbName = annot.name();
        }
        if (SessionBeanDescriptorAnnotationParser.valueIsEmpty(ejbName)) {
            ejbName = this.getDefaultBeanName(cls);
        }
        EJBAnnotationMessages.fineEJBName(cls.getName(), ejbName);
        SessionBeanDescriptor descriptor = (SessionBeanDescriptor)ejbPackage.getBean(ejbName);
        if (descriptor == null) {
            descriptor = new SessionBeanDescriptor(ejbPackage, ejbName);
            ejbPackage.addBean(descriptor);
        }
        return descriptor;
    }

    @Override
    protected Set<String> getBusinessMethods(BeanDescriptor descriptor, Class cls) throws InstantiationException {
        HashSet<String> methods = new HashSet<String>();
        SessionBeanDescriptor desc = (SessionBeanDescriptor)descriptor;
        HashSet interfaceNames = new HashSet(desc.getRemoteInterfaceNames());
        interfaceNames.addAll(desc.getLocalInterfaceNames());
        for (Object interfaceName : interfaceNames) {
            try {
                Class<?> interf = cls.getClassLoader().loadClass((String)interfaceName);
                methods.addAll(EJBUtils.getMethodsWithUniqueSingatureForInterface(interf));
            }
            catch (ClassNotFoundException ex) {
                throw (InstantiationException)new InstantiationException("Fail to load interface " + interfaceName + " while parsing the annotation.").initCause(ex);
            }
        }
        return methods;
    }

    @Override
    public void parseInjectedMethodAndCallbacks(BeanDescriptor descriptor, Method method) throws InstantiationException {
        super.parseInjectedMethodAndCallbacks(descriptor, method);
        if (descriptor.isStateless()) {
            this.parseTimeoutMethod(descriptor, method);
        } else {
            this.parseRemoveMethod(descriptor, method);
            this.parseInitMethod(descriptor, method);
        }
    }

    private void parseRemoveMethod(BeanDescriptor descriptor, Method method) {
        Object annot = method.getAnnotation(EJBJarAnnotations.REMOVE_ANNOTATION);
        if (annot != null) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.REMOVE_ANNOTATION.getName(), method.getName());
            ((SessionBeanDescriptor)descriptor).getRemoveMethods().add(new RemoveMethod(new MethodDescriptor(null, method, 0), ((Remove)annot).retainIfException()));
        }
    }

    private void parseInitMethod(BeanDescriptor descriptor, Method method) {
        Object annot = method.getAnnotation(EJBJarAnnotations.INIT_ANNOTATION);
        if (annot != null) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.INIT_ANNOTATION.getName(), method.getName());
            ((SessionBeanDescriptor)descriptor).getInitMethods().add(new InitMethod(new MethodDescriptor(null, method, 0), ((Init)annot).value()));
        }
    }

    @Override
    protected void parseBeanAnnotations(BeanDescriptor desc, Class cls, AnnotationManager annotationManager) throws InstantiationException {
        StatefulDeployment deployment;
        Class singleBeanInterface;
        super.parseBeanAnnotations(desc, cls, annotationManager);
        SessionBeanDescriptor descriptor = (SessionBeanDescriptor)desc;
        if (cls.isAnnotationPresent(EJBJarAnnotations.STATEFUL_ANNOTATION)) {
            descriptor.setBeanType(1);
        } else {
            descriptor.setBeanType(2);
        }
        Object annot = cls.getAnnotation(EJBJarAnnotations.WEB_SERVICE_ANNOTATION);
        if (annot != null && !SessionBeanDescriptorAnnotationParser.valueIsEmpty(((WebService)annot).endpointInterface())) {
            descriptor.setServiceEndpointName(((WebService)annot).endpointInterface());
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.WEB_SERVICE_ANNOTATION.getName());
            EJBAnnotationMessages.finerWSEndpointInterface(descriptor.getServiceEndpointName());
        }
        if ((annot = cls.getAnnotation(EJBJarAnnotations.LOCAL_HOME_ANNOTATION)) != null && !SessionBeanDescriptorAnnotationParser.valueIsEmpty(((LocalHome)annot).value())) {
            descriptor.setLocalHomeName(((LocalHome)annot).value().getName());
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.LOCAL_HOME_ANNOTATION.getName());
            EJBAnnotationMessages.finerLocalHomeInterface(descriptor.getLocalHomeName());
        }
        if ((annot = cls.getAnnotation(EJBJarAnnotations.REMOTE_HOME_ANNOTATION)) != null && !SessionBeanDescriptorAnnotationParser.valueIsEmpty(((RemoteHome)annot).value())) {
            descriptor.setRemoteHomeName(((RemoteHome)annot).value().getName());
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.REMOTE_HOME_ANNOTATION.getName());
            EJBAnnotationMessages.finerRemoteHomeInterface(descriptor.getRemoteHomeName());
        }
        if ((annot = cls.getAnnotation(EJBJarAnnotations.REMOTE_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.REMOTE_ANNOTATION.getName());
            if (((Remote)annot).value().length == 0) {
                singleBeanInterface = EJBUtils.getSingleBussinessInterface(cls);
                if (singleBeanInterface != null && !singleBeanInterface.isAnnotationPresent(EJBJarAnnotations.REMOTE_ANNOTATION)) {
                    descriptor.addRemoteInterfaceName(singleBeanInterface.getName());
                    EJBAnnotationMessages.finerRemoteInterface(singleBeanInterface.getName());
                }
            } else {
                for (Class intf : ((Remote)annot).value()) {
                    descriptor.addRemoteInterfaceName(intf.getName());
                    EJBAnnotationMessages.finerRemoteInterface(intf.getName());
                }
            }
        }
        if ((annot = cls.getAnnotation(EJBJarAnnotations.LOCAL_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.LOCAL_ANNOTATION.getName());
            if (((Local)annot).value().length == 0) {
                singleBeanInterface = EJBUtils.getSingleBussinessInterface(cls);
                if (singleBeanInterface != null && !singleBeanInterface.isAnnotationPresent(EJBJarAnnotations.LOCAL_ANNOTATION)) {
                    descriptor.addLocalInterfaceName(singleBeanInterface.getName());
                    EJBAnnotationMessages.finerLocalInterface(singleBeanInterface.getName());
                }
            } else {
                for (Class intf : ((Local)annot).value()) {
                    descriptor.addLocalInterfaceName(intf.getName());
                    EJBAnnotationMessages.finerLocalInterface(intf.getName());
                }
            }
        }
        Collection interfaces = EJBUtils.getImplementedBusinessInterfaces(cls);
        for (Class intf : interfaces) {
            String intfName = intf.getName();
            boolean isRemote = false;
            boolean isLocal = false;
            boolean isWebService = false;
            if (intf.isAnnotationPresent(EJBJarAnnotations.REMOTE_ANNOTATION)) {
                AnnotationParsingMessages.fineParsingAnnotatedClass(intf.getName(), EJBJarAnnotations.REMOTE_ANNOTATION.getName());
                isRemote = true;
            }
            if (intf.isAnnotationPresent(EJBJarAnnotations.LOCAL_ANNOTATION)) {
                AnnotationParsingMessages.fineParsingAnnotatedClass(intf.getName(), EJBJarAnnotations.LOCAL_ANNOTATION.getName());
                isLocal = true;
            }
            if (intf.isAnnotationPresent(EJBJarAnnotations.WEB_SERVICE_ANNOTATION)) {
                AnnotationParsingMessages.fineParsingAnnotatedClass(intf.getName(), EJBJarAnnotations.WEB_SERVICE_ANNOTATION.getName());
                isWebService = true;
            }
            if (descriptor.getRemoteInterfaceNames().contains(intfName)) {
                if (!isLocal) continue;
                throw new InstantiationException("Ambiguous definition of remote/local for interface " + intfName + ": marked Remote on bean class and Local on interface");
            }
            if (descriptor.getLocalInterfaceNames().contains(intfName)) {
                if (!isRemote) continue;
                throw new InstantiationException("Ambiguous definition of remote/local for interface " + intfName + ": marked Local on bean class and Remote on interface");
            }
            if (isLocal && isRemote) {
                throw new InstantiationException("Only one of @Local or @Remote can be present on the bean's interface: " + intfName);
            }
            if (isLocal && isWebService) {
                throw new InstantiationException("Only one of @Local or @WebService can be present on the bean's interface: " + intfName);
            }
            if (isRemote) {
                descriptor.addRemoteInterfaceName(intfName);
                EJBAnnotationMessages.finerRemoteInterface(intfName);
                continue;
            }
            if (isLocal) {
                descriptor.addLocalInterfaceName(intfName);
                EJBAnnotationMessages.finerLocalInterface(intfName);
                continue;
            }
            if (isWebService) {
                descriptor.setServiceEndpointName(intfName);
                EJBAnnotationMessages.finerWSEndpointInterface(intfName);
                continue;
            }
            if (EJBJarAnnotations.REMOTE_CLASS.isAssignableFrom(intf)) {
                descriptor.addRemoteInterfaceName(intfName);
                EJBAnnotationMessages.finerRemoteInterface(intfName);
                continue;
            }
            if (interfaces.size() != 1) continue;
            descriptor.addLocalInterfaceName(intfName);
            EJBAnnotationMessages.finerLocalInterface(intfName);
        }
        if (descriptor.isStateful()) {
            deployment = (StatefulDeployment)SessionBeanDescriptorAnnotationParser.getAnnotation(cls, EJBJarAnnotations.STATEFUL_DEPLOYMENT);
            if (deployment != null) {
                AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.STATEFUL_DEPLOYMENT.getName());
                if (!SessionBeanDescriptorAnnotationParser.valueIsEmpty(deployment.location())) {
                    descriptor.setLocation(deployment.location());
                }
                if (!SessionBeanDescriptorAnnotationParser.valueIsEmpty(deployment.localLocation())) {
                    descriptor.setLocalLocation(deployment.localLocation());
                }
                if (deployment.maxInstances() != 0) {
                    descriptor.setMaxInstances(deployment.maxInstances());
                }
                if (!deployment.copyByValue()) {
                    descriptor.setCopyByValue(deployment.copyByValue());
                }
                if ((long)deployment.callTimeout() != 90000L) {
                    descriptor.setCallTimeout(deployment.callTimeout());
                }
                if (deployment.maxTransactionRetries() != 0) {
                    descriptor.setMaxTxRetries(deployment.maxTransactionRetries());
                }
                if (deployment.transactionRetryWait() != 0) {
                    descriptor.setTxRetryWait(deployment.transactionRetryWait());
                }
                if (!SessionBeanDescriptorAnnotationParser.valueIsEmpty(deployment.persistenceFileName())) {
                    descriptor.setPersistenceFilename(deployment.persistenceFileName());
                }
                if (!SessionBeanDescriptorAnnotationParser.valueIsEmpty(deployment.replicationType())) {
                    descriptor.getReplicationPolicy().setReplicationTrigger(ReplicationPolicy.convertReplicationTrigger(deployment.replicationType()));
                }
                if (deployment.timeout() != 1800) {
                    descriptor.setTimeout(deployment.timeout());
                }
                if (deployment.idletime() != 300) {
                    descriptor.setIdletime(deployment.idletime());
                }
                if (deployment.memoryThreshold() != 80) {
                    descriptor.setMemoryThreshold(deployment.memoryThreshold());
                }
                if (deployment.maxInstancesThreshold() != 90) {
                    descriptor.setMaxInstancesThreshold(deployment.maxInstancesThreshold());
                }
                if (deployment.resourceCheckInterval() != 180) {
                    descriptor.setResourceCheckInterval(deployment.resourceCheckInterval());
                }
                if (deployment.passivateCount() != -1) {
                    descriptor.setPassivateCount(deployment.passivateCount());
                }
                if (!SessionBeanDescriptorAnnotationParser.valueIsEmpty(deployment.interceptorType())) {
                    descriptor.setInterceptorType(deployment.interceptorType());
                }
                if (deployment.transactionTimeout() != -1) {
                    descriptor.setTransactionTimeout(deployment.transactionTimeout());
                }
            }
        } else {
            deployment = (StatelessDeployment)SessionBeanDescriptorAnnotationParser.getAnnotation(cls, EJBJarAnnotations.STATELESS_DEPLOYMENT);
            if (deployment != null) {
                AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.STATELESS_DEPLOYMENT.getName());
                if (!SessionBeanDescriptorAnnotationParser.valueIsEmpty(deployment.location())) {
                    descriptor.setLocation(deployment.location());
                }
                if (!SessionBeanDescriptorAnnotationParser.valueIsEmpty(deployment.localLocation())) {
                    descriptor.setLocalLocation(deployment.localLocation());
                }
                if (deployment.maxInstances() != 0) {
                    descriptor.setMaxInstances(deployment.maxInstances());
                }
                if (deployment.minInstances() != 0) {
                    descriptor.setMinInstances(deployment.minInstances());
                }
                if (deployment.poolCacheTimeout() != 60) {
                    descriptor.setCacheTimeout(deployment.poolCacheTimeout());
                }
                if (!deployment.copyByValue()) {
                    descriptor.setCopyByValue(deployment.copyByValue());
                }
                if (deployment.callTimeout() != 90000L) {
                    descriptor.setCallTimeout(deployment.callTimeout());
                }
                if (deployment.maxTransactionRetries() != 0) {
                    descriptor.setMaxTxRetries(deployment.maxTransactionRetries());
                }
                if (deployment.transactionRetryWait() != 0) {
                    descriptor.setTxRetryWait(deployment.transactionRetryWait());
                }
                if (!SessionBeanDescriptorAnnotationParser.valueIsEmpty(deployment.interceptorType())) {
                    descriptor.setInterceptorType(deployment.interceptorType());
                }
                if (deployment.transactionTimeout() != -1) {
                    descriptor.setTransactionTimeout(deployment.transactionTimeout());
                }
            }
        }
    }
}

