/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor;

import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.InterceptorBinding;
import com.evermind.server.ejb.deployment.InterceptorDescriptor;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.MethodState;
import com.evermind.server.ejb.interceptor.UserInterceptor;
import com.evermind.server.ejb.interceptor.joinpoint.AbstractEJBJoinPointImpl;
import com.evermind.server.ejb.interceptor.joinpoint.EJBJoinPoint;
import com.evermind.server.ejb.interceptor.joinpoint.EJBJoinPointImpl;
import com.evermind.server.ejb.interceptor.joinpoint.EJBTimeoutJoinPoint;
import com.evermind.server.ejb.interceptor.joinpoint.EmptyLifecycleJoinPoint;
import com.evermind.server.ejb.interceptor.joinpoint.EntityLifecycle;
import com.evermind.server.ejb.interceptor.joinpoint.SessionLifecycle;
import com.evermind.server.ejb.interceptor.joinpoint.StatelessCreateJoinPointImpl;
import com.evermind.server.ejb.interceptor.joinpoint.TopLinkRemoveJoinPoint;
import com.evermind.server.ejb.interceptor.joinpoint.ToplinkCollectionFinderJoinPointImpl;
import com.evermind.server.ejb.interceptor.joinpoint.ToplinkEnumerationFinderJoinPointImpl;
import com.evermind.server.ejb.interceptor.joinpoint.ToplinkSingleFinderJoinPointImpl;
import com.evermind.server.ejb.interceptor.system.DMSInterceptor;
import com.evermind.server.ejb.interceptor.system.ExcludeInterceptor;
import com.evermind.server.ejb.interceptor.system.JAASInterceptor;
import com.evermind.server.ejb.interceptor.system.JACCInterceptor;
import com.evermind.server.ejb.interceptor.system.OrionTimeoutMethodInterceptor;
import com.evermind.server.ejb.interceptor.system.RunAsInterceptor;
import com.evermind.server.ejb.interceptor.system.RunningStateInterceptor;
import com.evermind.server.ejb.interceptor.system.SecurityRoleInterceptor;
import com.evermind.server.ejb.interceptor.system.SetContextActionInterceptor;
import com.evermind.server.ejb.interceptor.system.StatefulCreateInterceptor;
import com.evermind.server.ejb.interceptor.system.StatefulRemoveInterceptor;
import com.evermind.server.ejb.interceptor.system.TopLinkBusinessMethodInterceptor;
import com.evermind.server.ejb.interceptor.system.TopLinkCreateInterceptor;
import com.evermind.server.ejb.interceptor.system.TopLinkRemoveInterceptor;
import com.evermind.server.ejb.interceptor.system.TxBeanManagedInterceptor;
import com.evermind.server.ejb.interceptor.system.TxMandatoryInterceptor;
import com.evermind.server.ejb.interceptor.system.TxNeverInterceptor;
import com.evermind.server.ejb.interceptor.system.TxNotSupportedInterceptor;
import com.evermind.server.ejb.interceptor.system.TxRequiredInterceptor;
import com.evermind.server.ejb.interceptor.system.TxRequiredRetryInterceptor;
import com.evermind.server.ejb.interceptor.system.TxRequiresNewInterceptor;
import com.evermind.server.ejb.interceptor.system.TxRequiresNewRetryInterceptor;
import com.evermind.server.ejb.interceptor.system.TxSupportsInterceptor;
import com.evermind.server.ejb.interceptor.system.TxTimeoutRequiresNewInterceptor;
import com.evermind.server.ejb.interceptor.system.XPCPropagationInterceptor;
import com.evermind.server.ejb.logging.EJBInterceptorMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.EntityBean;
import javax.ejb.SessionBean;
import javax.ejb.TimedObject;
import javax.naming.Context;

public class InterceptorManager {
    private InterceptorBinding defaultInterceptorBinding;
    private InterceptorBinding classInterceptorBinding;
    private List methodInterceptorBindings;
    private Map userInterceptors;
    private UserInterceptor beanInterceptors;
    protected List userInterceptorsList;
    protected boolean usesSingletonInterceptors = true;
    private boolean singletonInjectionComplete = false;

    public EJBJoinPoint createJoinPoint(MethodState methodState) {
        AbstractEJBJoinPointImpl joinPoint = this.getJoinPoint(methodState);
        if (joinPoint != null) {
            joinPoint.setInterceptors(this.getInterceptors(methodState));
        }
        return joinPoint;
    }

    private AbstractEJBJoinPointImpl getJoinPoint(MethodState methodState) {
        if (methodState.isHome()) {
            return this.getHomeJoinPoint(methodState);
        }
        return this.getBeanJoinPoint(methodState);
    }

    private AbstractEJBJoinPointImpl getHomeJoinPoint(MethodState methodState) {
        if (methodState.getBeanDescriptor().isStateless() && methodState.getMethodType() == 6) {
            return new StatelessCreateJoinPointImpl();
        }
        if (methodState.getBeanDescriptor().isStateful()) {
            return new EJBJoinPointImpl(methodState.getBeanMethod());
        }
        if (methodState.getBeanDescriptor().isTopLinkCMP() && methodState.getMethodType() == 3) {
            if (methodState.getInterfaceMethod().getReturnType() == Collection.class) {
                return new ToplinkCollectionFinderJoinPointImpl();
            }
            if (methodState.getInterfaceMethod().getReturnType() == Enumeration.class) {
                return new ToplinkEnumerationFinderJoinPointImpl();
            }
            return new ToplinkSingleFinderJoinPointImpl();
        }
        if (methodState.getMethodType() == 18) {
            return new TopLinkRemoveJoinPoint();
        }
        if (methodState.getBeanMethod() == null) {
            return null;
        }
        return new EJBJoinPointImpl(methodState.getBeanMethod());
    }

    private AbstractEJBJoinPointImpl getBeanJoinPoint(MethodState methodState) {
        if (methodState.getMethodType() == 18) {
            return new TopLinkRemoveJoinPoint();
        }
        if (methodState.getBeanMethod() == null) {
            if (methodState.getMethodType() == 6 || methodState.getMethodType() == 8 || methodState.getMethodType() == 9 || methodState.getMethodType() == 10) {
                return new EmptyLifecycleJoinPoint();
            }
            return null;
        }
        if (methodState.getMethodType() == 14 && TimedObject.class.isAssignableFrom(methodState.getBeanDescriptor().getEJBClass())) {
            return new EJBTimeoutJoinPoint(methodState);
        }
        if (SessionBean.class.isAssignableFrom(methodState.getBeanDescriptor().getEJBClass())) {
            if (methodState.getMethodType() == 4) {
                return new SessionLifecycle.SetSessionContextJoinPointImpl();
            }
            if (methodState.getMethodType() == 8) {
                return new SessionLifecycle.PreDestroyJoinPointImpl();
            }
            if (methodState.getMethodType() == 9) {
                return new SessionLifecycle.PostActivateJoinPointImpl();
            }
            if (methodState.getMethodType() == 10) {
                return new SessionLifecycle.PrePassivateJoinPointImpl();
            }
        }
        if (EntityBean.class.isAssignableFrom(methodState.getBeanDescriptor().getEJBClass())) {
            if (methodState.getMethodType() == 4) {
                return new EntityLifecycle.SetEntityContextJoinPointImpl();
            }
            if (methodState.getMethodType() == 5) {
                return new EntityLifecycle.UnSetEntityContextJoinPointImpl();
            }
            if (methodState.getMethodType() == 8) {
                return new EntityLifecycle.PreDestroyJoinPointImpl();
            }
            if (methodState.getMethodType() == 9) {
                return new EntityLifecycle.PostActivateJoinPointImpl();
            }
            if (methodState.getMethodType() == 10) {
                return new EntityLifecycle.PrePassivateJoinPointImpl();
            }
            if (methodState.getMethodType() == 11) {
                return new EntityLifecycle.PostLoadJoinPointImpl();
            }
            if (methodState.getMethodType() == 12) {
                return new EntityLifecycle.PreStoreJoinPointImpl();
            }
        }
        return new EJBJoinPointImpl(methodState.getBeanMethod());
    }

    private List getInterceptors(MethodState methodState) {
        List userInterceptors = this.getUserInterceptors(methodState);
        ArrayList interceptors = new ArrayList(userInterceptors.size() + 12);
        byte methodType = methodState.getMethodType();
        switch (methodType) {
            case 6: {
                if (methodState.isHome() && methodState.getBeanDescriptor().isStateless()) {
                    this.addInterceptor(DMSInterceptor.getInstance(methodState, false), interceptors);
                    this.addInterceptor(JACCInterceptor.getInstance(), interceptors);
                    this.addInterceptor(SecurityRoleInterceptor.getInstance(methodState), interceptors);
                    break;
                }
                if (methodState.isHome() && methodState.getBeanDescriptor().isStateful()) {
                    this.addInterceptor(DMSInterceptor.getInstance(methodState, false), interceptors);
                    this.addInterceptor(ExcludeInterceptor.getInstance(methodState), interceptors);
                    this.addInterceptor(JACCInterceptor.getInstance(), interceptors);
                    this.addInterceptor(SecurityRoleInterceptor.getInstance(methodState), interceptors);
                    this.addInterceptor(RunAsInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                    this.addInterceptor(TxSupportsInterceptor.getInstance(), interceptors);
                    this.addInterceptor(JAASInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                    this.addInterceptor(StatefulCreateInterceptor.getInstance(), interceptors);
                    this.addLifecycleCallbackInterceptors(methodState, interceptors);
                    break;
                }
                this.addLifecycleCallbackInterceptors(methodState, interceptors);
                interceptors.addAll(userInterceptors);
                break;
            }
            case 2: {
                if (methodState.getBeanDescriptor().isTopLinkCMP()) {
                    this.addInterceptor(DMSInterceptor.getInstance(methodState, false), interceptors);
                    this.addInterceptor(ExcludeInterceptor.getInstance(methodState), interceptors);
                    this.addInterceptor(JACCInterceptor.getInstance(), interceptors);
                    this.addInterceptor(SecurityRoleInterceptor.getInstance(methodState), interceptors);
                    this.addInterceptor(RunAsInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                    this.addTransactionInterceptor(methodState, interceptors);
                    this.addInterceptor(TopLinkBusinessMethodInterceptor.getInstance(), interceptors);
                    this.addInterceptor(JAASInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                    this.addInterceptor(SetContextActionInterceptor.getInstance(), interceptors);
                    this.addInterceptor(DMSInterceptor.getInstance(methodState, true), interceptors);
                    break;
                }
                this.addInterceptor(JAASInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                this.addInterceptor(SetContextActionInterceptor.getInstance(), interceptors);
                this.addInterceptor(DMSInterceptor.getInstance(methodState, true), interceptors);
                break;
            }
            case 3: {
                if (methodState.getBeanDescriptor().isTopLinkCMP()) {
                    this.addInterceptor(DMSInterceptor.getInstance(methodState, false), interceptors);
                    this.addInterceptor(ExcludeInterceptor.getInstance(methodState), interceptors);
                    this.addInterceptor(JACCInterceptor.getInstance(), interceptors);
                    this.addInterceptor(SecurityRoleInterceptor.getInstance(methodState), interceptors);
                    this.addTransactionInterceptor(methodState, interceptors);
                    this.addInterceptor(SetContextActionInterceptor.getInstance(), interceptors);
                    break;
                }
                this.addInterceptor(JAASInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                this.addInterceptor(SetContextActionInterceptor.getInstance(), interceptors);
                this.addInterceptor(DMSInterceptor.getInstance(methodState, true), interceptors);
                break;
            }
            case 18: {
                if (methodState.isHome()) {
                    this.addInterceptor(TopLinkRemoveInterceptor.getInstance(), interceptors);
                }
                this.addInterceptor(DMSInterceptor.getInstance(methodState, false), interceptors);
                this.addInterceptor(ExcludeInterceptor.getInstance(methodState), interceptors);
                this.addInterceptor(JACCInterceptor.getInstance(), interceptors);
                this.addInterceptor(SecurityRoleInterceptor.getInstance(methodState), interceptors);
                this.addInterceptor(RunAsInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                this.addTransactionInterceptor(methodState, interceptors);
                this.addInterceptor(JAASInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                break;
            }
            case 19: {
                this.addInterceptor(DMSInterceptor.getInstance(methodState, false), interceptors);
                this.addInterceptor(ExcludeInterceptor.getInstance(methodState), interceptors);
                this.addInterceptor(JACCInterceptor.getInstance(), interceptors);
                this.addInterceptor(SecurityRoleInterceptor.getInstance(methodState), interceptors);
                this.addInterceptor(RunAsInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                this.addTransactionInterceptor(methodState, interceptors);
                this.addInterceptor(JAASInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                this.addInterceptor(TopLinkCreateInterceptor.getInstance(), interceptors);
                this.addInterceptor(SetContextActionInterceptor.getInstance(), interceptors);
                this.addInterceptor(DMSInterceptor.getInstance(methodState, true), interceptors);
                break;
            }
            case 1: {
                if (methodState.getBeanDescriptor().isSession() || methodState.getBeanDescriptor().isTopLinkCMP()) {
                    this.addInterceptor(DMSInterceptor.getInstance(methodState, false), interceptors);
                    this.addInterceptor(ExcludeInterceptor.getInstance(methodState), interceptors);
                    this.addInterceptor(JACCInterceptor.getInstance(), interceptors);
                    this.addInterceptor(SecurityRoleInterceptor.getInstance(methodState), interceptors);
                    this.addInterceptor(RunAsInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                    this.addTransactionInterceptor(methodState, interceptors);
                    if (methodState.getBeanDescriptor().isTopLinkCMP()) {
                        this.addInterceptor(TopLinkBusinessMethodInterceptor.getInstance(), interceptors);
                    }
                    this.addInterceptor(XPCPropagationInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                    this.addInterceptor(StatefulRemoveInterceptor.getInstance(methodState), interceptors);
                }
                this.addInterceptor(JAASInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                this.addInterceptor(DMSInterceptor.getInstance(methodState, true), interceptors);
                if (methodState.getBeanDescriptor().getEJBPackage().getCompatibility() >= 3) {
                    this.addInterceptor(SetContextActionInterceptor.getInstance(), interceptors);
                }
                interceptors.addAll(userInterceptors);
                break;
            }
            case 13: {
                this.addInterceptor(RunAsInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                this.addInterceptor(SetContextActionInterceptor.getInstance(), interceptors);
                this.addInterceptor(DMSInterceptor.getInstance(methodState, true), interceptors);
                interceptors.addAll(userInterceptors);
                break;
            }
            case 14: {
                if (methodState.getBeanDescriptor().isEntity()) {
                    this.addInterceptor(RunningStateInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                }
                this.addInterceptor(RunAsInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
                this.addTimeoutTransactionInterceptor(methodState, interceptors);
                if (methodState.getBeanDescriptor().isTopLinkCMP()) {
                    this.addInterceptor(TopLinkBusinessMethodInterceptor.getInstance(), interceptors);
                } else if (methodState.getBeanDescriptor().isEntity()) {
                    this.addInterceptor(OrionTimeoutMethodInterceptor.getInstance(), interceptors);
                }
                this.addInterceptor(SetContextActionInterceptor.getInstance(), interceptors);
                this.addInterceptor(DMSInterceptor.getInstance(methodState, true), interceptors);
                break;
            }
            default: {
                this.addLifecycleCallbackInterceptors(methodState, interceptors);
                interceptors.addAll(userInterceptors);
            }
        }
        return interceptors;
    }

    private void addTransactionInterceptor(MethodState state, List interceptors) {
        BeanDescriptor descriptor = state.getBeanDescriptor();
        if (descriptor.getTransactionType() == 0) {
            int transactionType = descriptor.getTransactionType(state.getInterfaceMethod(), state.isHome(), state.isLocal());
            switch (transactionType) {
                case 3: {
                    this.addInterceptor(TxMandatoryInterceptor.getInstance(), interceptors);
                    break;
                }
                case 5: {
                    this.addInterceptor(TxNeverInterceptor.getInstance(), interceptors);
                    break;
                }
                case 2: {
                    this.addInterceptor(TxNotSupportedInterceptor.getInstance(), interceptors);
                    break;
                }
                case 1: {
                    if (descriptor.getMaxTxRetries() > 0) {
                        this.addInterceptor(TxRequiredRetryInterceptor.getInstance(), interceptors);
                        break;
                    }
                    this.addInterceptor(TxRequiredInterceptor.getInstance(), interceptors);
                    break;
                }
                case 6: {
                    if (descriptor.getMaxTxRetries() > 0) {
                        this.addInterceptor(TxRequiresNewRetryInterceptor.getInstance(), interceptors);
                        break;
                    }
                    this.addInterceptor(TxRequiresNewInterceptor.getInstance(), interceptors);
                    break;
                }
                case 4: {
                    this.addInterceptor(TxSupportsInterceptor.getInstance(), interceptors);
                }
            }
        } else {
            this.addInterceptor(TxBeanManagedInterceptor.getInstance(), interceptors);
        }
    }

    private void addTimeoutTransactionInterceptor(MethodState state, List interceptors) {
        BeanDescriptor descriptor = state.getBeanDescriptor();
        if (descriptor.getTransactionType() == 0) {
            int transactionType = descriptor.getTransactionType(state.getBeanMethod(), state.isHome(), state.isLocal());
            if (transactionType == 6) {
                this.addInterceptor(TxTimeoutRequiresNewInterceptor.getInstance(), interceptors);
                return;
            }
            this.addInterceptor(TxNotSupportedInterceptor.getInstance(), interceptors);
        } else {
            this.addInterceptor(TxBeanManagedInterceptor.getInstance(), interceptors);
        }
    }

    private void addLifecycleCallbackInterceptors(MethodState methodState, List interceptors) {
        this.addInterceptor(SetContextActionInterceptor.getInstance(), interceptors);
        if (methodState.getBeanDescriptor().isEntity() && methodState.getMethodType() != 4 && methodState.getMethodType() != 5) {
            this.addInterceptor(JAASInterceptor.getInstance(methodState.getBeanDescriptor()), interceptors);
        }
        this.addInterceptor(DMSInterceptor.getInstance(methodState, true), interceptors);
    }

    private void addInterceptor(Interceptor interceptor, List list) {
        if (interceptor != null) {
            list.add(interceptor);
        }
    }

    public InterceptorManager initialize(BeanDescriptor beanDescriptor) {
        Iterator iter;
        HashSet userInterceptorNames = new HashSet();
        List bindings = beanDescriptor.getPackage().getDefaultInterceptorBindings();
        if (bindings != null) {
            this.defaultInterceptorBinding = (InterceptorBinding)bindings.get(0);
            userInterceptorNames.addAll(this.defaultInterceptorBinding.getInterceptorClassNames());
        }
        if ((bindings = (List)beanDescriptor.getPackage().getInterceptorBindings().get(beanDescriptor.getName())) != null) {
            this.methodInterceptorBindings = new ArrayList(bindings.size());
            iter = bindings.iterator();
            while (iter.hasNext()) {
                InterceptorBinding binding = (InterceptorBinding)iter.next();
                if (binding.isClassLevel()) {
                    if (this.classInterceptorBinding != null) {
                        throw DeploymentException.multipleClassInterceptorBindings(beanDescriptor, binding.getEjbName());
                    }
                    this.classInterceptorBinding = binding;
                } else {
                    this.methodInterceptorBindings.add(binding);
                }
                userInterceptorNames.addAll(binding.getInterceptorClassNames());
            }
        }
        iter = userInterceptorNames.iterator();
        this.userInterceptors = new HashMap(userInterceptorNames.size() + 1);
        this.userInterceptorsList = new ArrayList(userInterceptorNames.size());
        int i = 0;
        while (iter.hasNext()) {
            String interceptorName = (String)iter.next();
            InterceptorDescriptor interceptorDescriptor = (InterceptorDescriptor)beanDescriptor.getPackage().getInterceptorDescriptors().get(interceptorName);
            if (interceptorDescriptor == null) {
                throw DeploymentException.missingInterceptorDef(beanDescriptor, interceptorName);
            }
            UserInterceptor userInterceptor = new UserInterceptor(interceptorDescriptor, beanDescriptor, i);
            this.usesSingletonInterceptors &= userInterceptor.usesSingletonUserInterceptors();
            this.userInterceptors.put(interceptorName, userInterceptor);
            this.userInterceptorsList.add(userInterceptor);
            ++i;
        }
        this.beanInterceptors = new UserInterceptor(beanDescriptor.getBeanInterceptor(), beanDescriptor);
        return this;
    }

    public List getUserInterceptors(MethodState methodState) {
        byte methodType = methodState.getMethodType();
        if (methodType != 1 && methodType != 13 && methodType != 6 && methodType != 8 && methodType != 9 && methodType != 10) {
            return Collections.EMPTY_LIST;
        }
        String beanName = methodState.getBeanDescriptor().getName();
        String methodName = "UNKNOWN";
        if (methodState.getBeanMethod() != null) {
            methodName = methodState.getBeanMethod().getName();
        }
        EJBInterceptorMessages.finestGetUserInterceptorsForMethodStart(beanName, methodName);
        ArrayList interceptorClassNames = new ArrayList();
        InterceptorBinding classBinding = this.classInterceptorBinding;
        InterceptorBinding methodBinding = this.getMethodInterceptorBinding(methodState);
        if (!(this.defaultInterceptorBinding == null || methodBinding.isExcludeDefaultInterceptors() || classBinding != null && classBinding.isExcludeDefaultInterceptors())) {
            interceptorClassNames.addAll(this.defaultInterceptorBinding.getInterceptorClassNames());
            EJBInterceptorMessages.finestGetDefaultInterceptors(beanName, methodName, this.defaultInterceptorBinding.toString());
        }
        if (classBinding != null && !methodBinding.isExcludeClassInterceptors()) {
            interceptorClassNames.addAll(classBinding.getInterceptorClassNames());
            EJBInterceptorMessages.finestGetClassInterceptors(beanName, methodName, classBinding.toString());
        }
        if (!methodBinding.getInterceptorClassNames().isEmpty()) {
            interceptorClassNames.addAll(methodBinding.getInterceptorClassNames());
            EJBInterceptorMessages.finestGetMethodInterceptors(beanName, methodName, methodBinding.toString());
        }
        ArrayList interceptors = new ArrayList(interceptorClassNames.size() + 1);
        Iterator iter = interceptorClassNames.iterator();
        while (iter.hasNext()) {
            UserInterceptor callbacks = (UserInterceptor)this.userInterceptors.get(iter.next());
            interceptors.addAll(callbacks.getInterceptors(methodType));
        }
        interceptors.addAll(this.beanInterceptors.getInterceptors(methodType));
        EJBInterceptorMessages.finestGetUserInterceptorsForMethodEnd(beanName, methodName);
        return interceptors;
    }

    private InterceptorBinding getMethodInterceptorBinding(MethodState methodState) {
        if (this.methodInterceptorBindings == null || methodState.getBeanMethod() == null) {
            return new InterceptorBinding();
        }
        String beanName = methodState.getBeanDescriptor().getName();
        String methodName = methodState.getBeanMethod().getName();
        EJBInterceptorMessages.finestRuntimeInterceptorBindingForMethodStart(beanName, methodName);
        InterceptorBinding binding = new InterceptorBinding(beanName);
        Iterator methodBindings = this.methodInterceptorBindings.iterator();
        while (methodBindings.hasNext()) {
            InterceptorBinding nextBinding = (InterceptorBinding)methodBindings.next();
            int newLevel = nextBinding.getMethodDescriptor().implies(beanName, methodState.getBeanMethod(), 0);
            if (newLevel <= 0) continue;
            if (!nextBinding.isInterceptorOrderDefined()) {
                binding.setExcludeClassInterceptors(binding.isExcludeClassInterceptors() || nextBinding.isExcludeClassInterceptors());
                binding.setExcludeDefaultInterceptors(binding.isExcludeDefaultInterceptors() || nextBinding.isExcludeDefaultInterceptors());
                binding.addInterceptorClassNames(nextBinding.getInterceptorClassNames());
                EJBInterceptorMessages.finestAugmentRuntimeInterceptorBinding(beanName, methodName, nextBinding.toString());
                continue;
            }
            binding.setExcludeClassInterceptors(true);
            binding.setExcludeDefaultInterceptors(true);
            binding.getInterceptorClassNames().clear();
            binding.addInterceptorClassNames(nextBinding.getInterceptorClassNames());
            binding.setIsInterceptorOrderDefined(true);
            EJBInterceptorMessages.finestOverrideRuntimeInterceptorBinding(beanName, methodName, nextBinding.toString());
        }
        EJBInterceptorMessages.finestRuntimeInterceptorBindingForMethodEnd(beanName, methodName);
        return binding;
    }

    public void initializeUserInterceptorsForBean(AbstractEJBContext ctx) {
        if (this.userInterceptorsList.isEmpty() || this.usesSingletonInterceptors) {
            return;
        }
        if (ctx.getUserInterceptorInstances() == null) {
            this.createUserInterceptorInstances(ctx);
        } else {
            this.reorderUserInterceptorInstances(ctx);
        }
    }

    private void createUserInterceptorInstances(AbstractEJBContext ctx) {
        ArrayList<Object> interceptorInstances = new ArrayList<Object>(this.userInterceptorsList.size());
        Iterator i = this.userInterceptorsList.iterator();
        while (i.hasNext()) {
            interceptorInstances.add(((UserInterceptor)i.next()).getNewInterceptorInstance());
        }
        ctx.setUserInterceptorInstances(interceptorInstances.toArray());
    }

    private void reorderUserInterceptorInstances(AbstractEJBContext ctx) {
        Object[] interceptorInstances = ctx.getUserInterceptorInstances();
        Iterator<Object> i = new ArrayList<Object>(Arrays.asList(interceptorInstances)).iterator();
        while (i.hasNext()) {
            Object instance;
            interceptorInstances[((UserInterceptor)this.userInterceptors.get((Object)instance.getClass().getName())).getIndex()] = instance = i.next();
        }
    }

    public void resolveDependencies(AbstractEJBContext ctx, Context j2eeContext) throws InstantiationException {
        if (this.singletonInjectionComplete) {
            return;
        }
        Iterator iter = this.userInterceptorsList.iterator();
        while (iter.hasNext()) {
            ((UserInterceptor)iter.next()).resolveDependencies(ctx, j2eeContext);
        }
        if (this.usesSingletonInterceptors) {
            this.singletonInjectionComplete = true;
        }
    }

    public List getUserInterceptorsList() {
        return this.userInterceptorsList;
    }
}

