/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor.system;

import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.ApplicationException;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.interceptor.system.TxLifecycleCallback;
import com.evermind.server.ejb.logging.EJBTransactionMessages;
import java.rmi.NoSuchObjectException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.transaction.Transaction;

public abstract class AbstractTxInterceptor
implements Interceptor {
    protected Transaction suspend(boolean local) throws Exception {
        if (local) {
            return EJBTransactionManager.getInstance().suspendLocal();
        }
        return EJBTransactionManager.getInstance().suspendRemote();
    }

    protected void resume(Transaction tx, boolean local) throws Exception {
        if (local) {
            EJBTransactionManager.getInstance().resumeLocal(tx);
        } else {
            EJBTransactionManager.getInstance().resumeRemote(tx);
        }
    }

    protected Exception convertAndHandleMethodException(Throwable e, InvocationContext ctx, boolean userTx) {
        EJBException rootCause;
        if (e instanceof NoSuchObjectException || e instanceof NoSuchObjectLocalException) {
            return (Exception)e;
        }
        if (e instanceof EJBException && EJBUtils.isRecoverableSystemException(rootCause = EJBUtils.unwrapSystemException((EJBException)e))) {
            return rootCause;
        }
        ApplicationException ae = EJBUtils.getApplicationException(e, ctx.getMethodState().getBeanDescriptor().getEJBPackage());
        if (ae != null) {
            if (ae.getRollback()) {
                EJBTransactionManager.getInstance().setContainerRollbackOnly();
            }
        } else {
            TxLifecycleCallback callback;
            e = ctx.getMethodState().isLocal() ? EJBUtils.getLocalUserException(e, userTx) : EJBUtils.getUserException(e, userTx);
            if (this.getTransaction() != null) {
                EJBTransactionManager.getInstance().setContainerRollbackOnly();
            }
            if ((callback = ctx.getTxLifecycleCallback()) != null) {
                callback.OC4J_transactionSystemException(ctx, e);
            }
            EJBTransactionMessages.severeMethodException(ctx.getMethodState().getBeanDescriptor(), ctx.getMethod(), e);
        }
        return (Exception)e;
    }

    protected Transaction getTransaction() {
        return EJBTransactionManager.getTransaction();
    }
}

