/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.logging;

import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.logging.EJBMessages;
import com.evermind.server.ejb.logging.i18n.EJBLifecycleMessageBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.CustomerLogger;

public class EJBLifecycleMessages
extends EJBMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.ejb.lifecycle", EJBLifecycleMessageBundle.class.getName());

    public static void finerEntityContextDestroyed(BeanDescriptor desc, Object pk) {
        if (EJBLifecycleMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-07001", new Object[]{EJBLifecycleMessages.getApplicationName(desc), EJBLifecycleMessages.getModuleName(desc), EJBLifecycleMessages.getBeanName(desc), pk});
        }
    }

    public static void finerEntityContextPassivated(BeanDescriptor desc, Object pk) {
        if (EJBLifecycleMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-07002", new Object[]{EJBLifecycleMessages.getApplicationName(desc), EJBLifecycleMessages.getModuleName(desc), EJBLifecycleMessages.getBeanName(desc), pk});
        }
    }

    public static void finerErrorInSFSBPassivation(BeanDescriptor desc, Throwable e) {
        if (EJBLifecycleMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-07003", new Object[]{EJBLifecycleMessages.getApplicationName(desc), EJBLifecycleMessages.getModuleName(desc), EJBLifecycleMessages.getBeanName(desc), e});
        }
    }

    public static void finerWaitingSFSBContextInstance(BeanDescriptor desc, Object instance) {
        if (EJBLifecycleMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-07004", new Object[]{EJBLifecycleMessages.getApplicationName(desc), EJBLifecycleMessages.getModuleName(desc), EJBLifecycleMessages.getBeanName(desc), instance});
        }
    }

    public static void finerSFSBSessionInfo(BeanDescriptor desc, long id, long checksum, String username, Object sfsbo) {
        if (EJBLifecycleMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-07006", new Object[]{EJBLifecycleMessages.getApplicationName(desc), EJBLifecycleMessages.getModuleName(desc), EJBLifecycleMessages.getBeanName(desc), new Long(id), new Long(checksum), username, sfsbo});
        }
    }

    public static void warningSFSBSerializingSession(BeanDescriptor desc, String msg) {
        if (EJBLifecycleMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-07007", new Object[]{EJBLifecycleMessages.getApplicationName(desc), EJBLifecycleMessages.getModuleName(desc), EJBLifecycleMessages.getBeanName(desc), msg});
        }
    }

    public static void warningSFSBInEjbActivate(BeanDescriptor desc) {
        if (EJBLifecycleMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-07008", new Object[]{EJBLifecycleMessages.getApplicationName(desc), EJBLifecycleMessages.getModuleName(desc), EJBLifecycleMessages.getBeanName(desc)});
        }
    }

    public static void finerSessionTimedOut(BeanDescriptor desc, long id) {
        if (EJBLifecycleMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-07005", new Object[]{EJBLifecycleMessages.getApplicationName(desc), EJBLifecycleMessages.getModuleName(desc), EJBLifecycleMessages.getBeanName(desc), new Long(id)});
        }
    }

    public static void finePassivatedSessions(BeanDescriptor desc, int count) {
        if (EJBLifecycleMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-07009", new Object[]{EJBLifecycleMessages.getApplicationName(desc), EJBLifecycleMessages.getModuleName(desc), EJBLifecycleMessages.getBeanName(desc), new Integer(count)});
        }
    }

    public static void warningInvalidatingSessions(BeanDescriptor desc) {
        m_logger.log(Level.WARNING, "J2EE EJB-07010", new Object[]{EJBLifecycleMessages.getApplicationName(desc), EJBLifecycleMessages.getModuleName(desc), EJBLifecycleMessages.getBeanName(desc)});
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }
}

