/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.logging;

import com.evermind.server.ejb.BeanPoolConfig;
import com.evermind.server.ejb.logging.DiagnosticContext;
import com.evermind.server.ejb.logging.EJBMessages;
import com.evermind.server.ejb.logging.i18n.EJBPoolingMessageBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBContext;
import oracle.j2ee.util.CustomerLogger;

public class EJBPoolingMessages
extends EJBMessages {
    public static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.ejb.pooling", EJBPoolingMessageBundle.class.getName());

    public static void fineInitializingBeanPooling(BeanPoolConfig config) {
        if (EJBPoolingMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-06001", new Object[]{config.getContextId(), new Integer(config.getMinInstances()), new Integer(config.getMaxInstances()), new Long(config.getCallTimeout()), new Integer(config.getCacheTimeout())});
        }
    }

    public static void fineShutdownBeanPool(DiagnosticContext ctx) {
        if (EJBPoolingMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-06002", new Object[]{ctx.getContextId()});
        }
    }

    public static void fineExpiringBeanPoolInstances(DiagnosticContext ctx) {
        if (EJBPoolingMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-06003", new Object[]{ctx.getContextId()});
        }
    }

    public static void fineMinInstancesUpdated(DiagnosticContext ctx, int newMin) {
        if (EJBPoolingMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-06004", new Object[]{ctx.getContextId(), new Integer(newMin)});
        }
    }

    public static void fineMaxInstancesUpdated(DiagnosticContext ctx, int newMax) {
        if (EJBPoolingMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-06005", new Object[]{ctx.getContextId(), new Integer(newMax)});
        }
    }

    public static void finestAllocateInstance(DiagnosticContext dCtx, EJBContext ctx) {
        if (EJBPoolingMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE EJB-06006", new Object[]{dCtx.getContextId(), ctx.toString() + System.identityHashCode(ctx)});
        }
    }

    public static void finestReleaseInstance(DiagnosticContext dCtx, EJBContext ctx) {
        if (EJBPoolingMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE EJB-06007", new Object[]{dCtx.getContextId(), ctx.toString() + System.identityHashCode(ctx)});
        }
    }

    public static void finerCreateInstance(DiagnosticContext ctx) {
        if (EJBPoolingMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-06008", new Object[]{ctx.getContextId()});
        }
    }

    public static void finerDestroyInstance(DiagnosticContext dCtx, EJBContext ctx, boolean discard) {
        if (EJBPoolingMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-06009", new Object[]{dCtx.getContextId(), ctx.toString() + System.identityHashCode(ctx), discard});
        }
    }

    public static void warningTimeoutReached(DiagnosticContext ctx) {
        if (EJBPoolingMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-06010", new Object[]{ctx.getContextId()});
        }
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }
}

