/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import com.evermind.server.ejb.logging.PersistenceMessages;
import com.evermind.server.ejb.persistence.EntityManagerProxy;
import com.evermind.server.ejb.persistence.PersistenceUnit;
import com.evermind.server.ejb.persistence.XPCEntityManagerProxy;
import com.evermind.server.ejb.persistence.XPCManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public class PersistenceUnitImpl
implements PersistenceUnit {
    private String name;
    private String relativePath;
    private EntityManagerFactory emf;
    private EntityManagerProxy txProxy;
    private Map pcRefCount = new HashMap();

    public PersistenceUnitImpl(String name, String relativePath, EntityManagerFactory emf) {
        this.name = name;
        this.relativePath = relativePath;
        this.emf = emf;
        this.txProxy = new EntityManagerProxy(this, Collections.EMPTY_MAP);
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getName() {
        return this.name;
    }

    public Object getEntityManagerFactory() {
        return this.emf;
    }

    public Object getEntityManagerProxy(Map properties) {
        if (properties == null || properties.isEmpty()) {
            return this.txProxy;
        }
        return new EntityManagerProxy(this, properties);
    }

    public synchronized Object createPersistenceContext(Map properties) {
        EntityManager em = this.emf.createEntityManager(properties);
        PersistenceMessages.finerPPMCreatedPC(this.getName(), em);
        this.pcRefCount.put(em, 1);
        return em;
    }

    public synchronized void sharePersistenceContext(Object pc) {
        Integer count = (Integer)this.pcRefCount.get(pc);
        this.pcRefCount.put(pc, count + 1);
    }

    public void joinPersistenceContext(Object pc) {
        ((EntityManager)pc).joinTransaction();
    }

    public synchronized void closePersistenceContext(Object pc) {
        Integer count = (Integer)this.pcRefCount.get(pc);
        if (count == 1) {
            PersistenceMessages.finerPPMClosePC(this.getName(), pc);
            ((EntityManager)pc).close();
            this.pcRefCount.remove(pc);
        } else {
            this.pcRefCount.put(pc, count - 1);
        }
    }

    public Object createTempPersistenceContext(Map properties) {
        EntityManager em = this.emf.createEntityManager(properties);
        PersistenceMessages.finerPPMCreatedPC(this.getName(), em);
        return em;
    }

    public void closeTempPersistenceContext(Object pc) {
        PersistenceMessages.finerPPMClosePC(this.getName(), pc);
        ((EntityManager)pc).close();
    }

    public boolean isTempPersistenceContext(Object pc) {
        return !this.pcRefCount.containsKey(pc);
    }

    public Object getExtendedEntityManagerProxy(XPCManager xm, Map properties) {
        return new XPCEntityManagerProxy(this, xm, properties);
    }
}

