/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.persistence.PersistenceUnitInfoImpl;
import com.evermind.xml.XMLConfig;
import com.evermind.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PersistenceUnitInfoXMLFactory
extends XMLConfig {
    private static PersistenceUnitInfoXMLFactory m_instance;

    private PersistenceUnitInfoXMLFactory() {
    }

    public static PersistenceUnitInfoXMLFactory getInstance() {
        if (m_instance == null) {
            m_instance = new PersistenceUnitInfoXMLFactory();
        }
        return m_instance;
    }

    public List parsePersistenceXML(String scope, byte[] data) {
        Element rootNode = null;
        ArrayList<PersistenceUnitInfo> persistenceUnitInfos = new ArrayList<PersistenceUnitInfo>(1);
        if (data != null && data.length == 0) {
            persistenceUnitInfos.add(new PersistenceUnitInfoImpl());
            return persistenceUnitInfos;
        }
        try {
            rootNode = XMLUtils.getDocument(new InputSource(new ByteArrayInputStream(data)), PersistenceUnitInfoXMLFactory.getInstance(), PersistenceUnitInfoXMLFactory.getInstance(), true).getDocumentElement();
        }
        catch (Exception e) {
            throw DeploymentException.exceptionParsingXml(scope, "persistence.xml", e);
        }
        if (rootNode.getChildNodes().getLength() == 0) {
            persistenceUnitInfos.add(new PersistenceUnitInfoImpl());
            return persistenceUnitInfos;
        }
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (XMLUtils.isCommentOrID(node.getNodeName())) continue;
            String name = node.getNodeName();
            if (name.equals("persistence-unit")) {
                persistenceUnitInfos.add(this.parsePersistenceUnit(scope, node));
                continue;
            }
            throw DeploymentException.unknownXmlSubtag(scope, rootNode.getNodeName(), name, "persistence-unit");
        }
        if (persistenceUnitInfos.isEmpty()) {
            persistenceUnitInfos.add(new PersistenceUnitInfoImpl());
        }
        return persistenceUnitInfos;
    }

    private PersistenceUnitInfo parsePersistenceUnit(String scope, Node rootNode) {
        PersistenceUnitInfoImpl info = new PersistenceUnitInfoImpl();
        NamedNodeMap attributes = rootNode.getAttributes();
        for (int i = 0; attributes != null && i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName();
            if (name.equals("name")) {
                info.setPersistenceUnitName(attribute.getNodeValue());
                continue;
            }
            if (name.equals("transaction-type")) {
                info.setTransactionType(this.parseTransactionType(scope, attribute.getNodeValue()));
                continue;
            }
            throw DeploymentException.unknownXmlAttribute(scope, rootNode.getNodeName(), name);
        }
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (XMLUtils.isCommentOrID(node.getNodeName())) continue;
            String name = node.getNodeName();
            String value = XMLUtils.getStringValue(node);
            if (name.equals("description")) {
                info.setDescription(value);
                continue;
            }
            if (name.equals("provider")) {
                info.setPersistenceProviderClassName(value);
                continue;
            }
            if (name.equals("jar-file")) {
                info.addJarFileUrlName(value);
                continue;
            }
            if (name.equals("mapping-file")) {
                info.addMappingFileName(value);
                continue;
            }
            if (name.equals("class")) {
                info.addManagedClassName(value);
                continue;
            }
            if (name.equals("exclude-unlisted-classes")) {
                info.setExcludeUnlistedClasses(Boolean.parseBoolean(value));
                continue;
            }
            if (name.equals("properties")) {
                this.parseProperties(scope, info, node);
                continue;
            }
            if (name.equals("jta-data-source")) {
                info.setJtaDataSourceName(value);
                continue;
            }
            if (name.equals("non-jta-data-source")) {
                info.setNonJtaDataSourceName(value);
                continue;
            }
            throw DeploymentException.unknownXmlSubtag(scope, rootNode.getNodeName(), name);
        }
        return info;
    }

    private void parseProperties(String scope, PersistenceUnitInfoImpl info, Node rootNode) {
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (XMLUtils.isCommentOrID(node.getNodeName())) continue;
            String name = node.getNodeName();
            if (name.equals("property")) {
                info.addProperty(XMLUtils.getNodeAttribute(node, "name"), XMLUtils.getNodeAttribute(node, "value"));
                continue;
            }
            throw DeploymentException.unknownXmlSubtag(scope, rootNode.getNodeName(), name, "property");
        }
    }

    private PersistenceUnitTransactionType parseTransactionType(String scope, String type) {
        if ("JTA".equalsIgnoreCase(type)) {
            return PersistenceUnitTransactionType.JTA;
        }
        if ("RESOURCE_LOCAL".equalsIgnoreCase(type)) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        throw DeploymentException.unknownXmlValue(scope, "transaction-type", type, "JTA/RESOURCE_LOCAL");
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return this.resolveEntityWithValidation(publicId, systemId);
    }

    public void warning(SAXParseException e) {
        this.warningWithValidation(e);
    }

    public void error(SAXParseException e) throws SAXException {
        this.errorWithValidation(e);
    }

    protected void writeConfig(PrintWriter writer) throws IOException {
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
    }
}

