/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.proxy;

import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptor;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.proxy.CombinedInterfaceGenerator;
import com.evermind.server.ejb.proxy.EntityHomeProxyGenerator;
import com.evermind.server.ejb.proxy.EntityProxyGenerator;
import com.evermind.server.ejb.proxy.MessageDrivenProxyGenerator;
import com.evermind.server.ejb.proxy.ProxyClassLoader;
import com.evermind.server.ejb.proxy.StatefulHomeProxyGenerator;
import com.evermind.server.ejb.proxy.StatefulProxyGenerator;
import com.evermind.server.ejb.proxy.StatelessHomeProxyGenerator;
import com.evermind.server.ejb.proxy.StatelessProxyGenerator;

public class ProxyFactory {
    private ProxyClassLoader cl;

    public ProxyFactory(ProxyClassLoader cl) {
        this.cl = cl;
    }

    public void buildProxies(BeanDescriptor bd) {
        if (bd.isSession()) {
            this.generateCombinedInterface(bd);
        }
        if (bd.isMessageDriven()) {
            this.generateEndpointProxy(bd);
        } else {
            this.generateComponentInterfaceProxy(bd, true, false);
            this.generateComponentInterfaceProxy(bd, false, false);
            this.generateComponentInterfaceProxy(bd, true, true);
            this.generateComponentInterfaceProxy(bd, false, true);
        }
    }

    private void generateComponentInterfaceProxy(BeanDescriptor bd, boolean isLocal, boolean isHome) {
        if (bd.isStateless()) {
            SessionBeanDescriptor sd = (SessionBeanDescriptor)bd;
            if (isHome) {
                Class proxy;
                StatelessHomeProxyGenerator gen;
                if (isLocal && sd.getLocalHome() != null && sd.getLocalHomeWrapper() == null) {
                    gen = new StatelessHomeProxyGenerator(sd, true);
                    proxy = gen.generateProxy(this.cl);
                    sd.setLocalHomeWrapperName(proxy.getName());
                    sd.setLocalHomeWrapper(proxy);
                }
                if (!isLocal && sd.getRemoteHome() != null && sd.getRemoteHomeWrapper() == null) {
                    gen = new StatelessHomeProxyGenerator(sd, false);
                    gen.setCorba(sd.getGenerateIIOP());
                    proxy = gen.generateProxy(this.cl);
                    sd.setRemoteHomeWrapperName(proxy.getName());
                    sd.setRemoteHomeWrapper(proxy);
                }
            } else {
                Class proxy;
                StatelessProxyGenerator gen;
                if (isLocal && sd.getLocalInterface() != null && sd.getLocalWrapper() == null) {
                    gen = new StatelessProxyGenerator(sd, true);
                    proxy = gen.generateProxy(this.cl);
                    sd.setLocalWrapperName(proxy.getName());
                    sd.setLocalWrapper(proxy);
                }
                if (!isLocal && sd.getRemoteInterface() != null && sd.getRemoteWrapper() == null) {
                    gen = new StatelessProxyGenerator(sd, false);
                    proxy = gen.generateProxy(this.cl);
                    gen.setCorba(sd.getGenerateIIOP());
                    sd.setRemoteWrapperName(proxy.getName());
                    sd.setRemoteWrapper(proxy);
                }
            }
        } else if (bd.isStateful()) {
            SessionBeanDescriptor sd = (SessionBeanDescriptor)bd;
            if (isHome) {
                Class proxy;
                StatefulHomeProxyGenerator gen;
                if (isLocal && sd.getLocalHome() != null && sd.getLocalHomeWrapper() == null) {
                    gen = new StatefulHomeProxyGenerator(sd, true);
                    proxy = gen.generateProxy(this.cl);
                    sd.setLocalHomeWrapperName(proxy.getName());
                    sd.setLocalHomeWrapper(proxy);
                }
                if (!isLocal && sd.getRemoteHome() != null && sd.getRemoteHomeWrapper() == null) {
                    gen = new StatefulHomeProxyGenerator(sd, false);
                    proxy = gen.generateProxy(this.cl);
                    sd.setRemoteHomeWrapperName(proxy.getName());
                    sd.setRemoteHomeWrapper(proxy);
                }
            } else {
                Class proxy;
                StatefulProxyGenerator gen;
                if (isLocal && sd.getLocalInterface() != null && sd.getLocalWrapper() == null) {
                    gen = new StatefulProxyGenerator(sd, true);
                    proxy = gen.generateProxy(this.cl);
                    sd.setLocalWrapperName(proxy.getName());
                    sd.setLocalWrapper(proxy);
                }
                if (!isLocal && sd.getRemoteInterface() != null && sd.getRemoteWrapper() == null) {
                    gen = new StatefulProxyGenerator(sd, false);
                    proxy = gen.generateProxy(this.cl);
                    sd.setRemoteWrapperName(proxy.getName());
                    sd.setRemoteWrapper(proxy);
                }
            }
        } else if (bd.isTopLinkCMP()) {
            EntityBeanDescriptor ed = (EntityBeanDescriptor)bd;
            if (isHome) {
                Class proxy;
                EntityHomeProxyGenerator gen;
                if (isLocal && ed.getLocalHome() != null && ed.getLocalHomeWrapper() == null) {
                    gen = new EntityHomeProxyGenerator(ed, true);
                    proxy = gen.generateProxy(this.cl);
                    ed.setLocalHomeWrapperName(proxy.getName());
                    ed.setLocalHomeWrapper(proxy);
                }
                if (!isLocal && ed.getRemoteHome() != null && ed.getRemoteHomeWrapper() == null) {
                    gen = new EntityHomeProxyGenerator(ed, false);
                    proxy = gen.generateProxy(this.cl);
                    ed.setRemoteHomeWrapperName(proxy.getName());
                    ed.setRemoteHomeWrapper(proxy);
                }
            } else {
                Class proxy;
                EntityProxyGenerator gen;
                if (isLocal && ed.getLocalInterface() != null && ed.getLocalWrapper() == null) {
                    gen = new EntityProxyGenerator(ed, true);
                    proxy = gen.generateProxy(this.cl);
                    ed.setLocalWrapperName(proxy.getName());
                    ed.setLocalWrapper(proxy);
                }
                if (!isLocal && ed.getRemoteInterface() != null && ed.getRemoteWrapper() == null) {
                    gen = new EntityProxyGenerator(ed, false);
                    proxy = gen.generateProxy(this.cl);
                    ed.setRemoteWrapperName(proxy.getName());
                    ed.setRemoteWrapper(proxy);
                }
            }
        }
    }

    private void generateEndpointProxy(BeanDescriptor bd) {
        MessageDrivenBeanDescriptor md = (MessageDrivenBeanDescriptor)bd;
        if (md.getResourceAdapter() != null && md.getEndpointWrapper() == null) {
            MessageDrivenProxyGenerator gen = new MessageDrivenProxyGenerator(md);
            Class proxy = gen.generateProxy(this.cl);
            md.setEndpointWrapperName(proxy.getName());
            md.setEndpointWrapper(proxy);
        }
    }

    private void generateCombinedInterface(BeanDescriptor bd) {
        Class intf;
        CombinedInterfaceGenerator gen;
        SessionBeanDescriptor sd = (SessionBeanDescriptor)bd;
        if (sd.getLocalInterfaceNames().size() > 1 && sd.getLocalInterface() == null) {
            gen = new CombinedInterfaceGenerator(sd);
            intf = gen.generateCombinedInterface(true, this.cl);
            sd.setLocalInterfaceName(intf.getName());
            sd.setLocalInterface(intf);
        }
        if (sd.getRemoteInterfaceNames().size() > 1 && sd.getRemoteInterface() == null) {
            gen = new CombinedInterfaceGenerator(sd);
            intf = gen.generateCombinedInterface(false, this.cl);
            sd.setRemoteInterfaceName(intf.getName());
            sd.setRemoteInterface(intf);
        }
    }
}

