/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HtmlTag {
    private String name;
    private Map mappings;
    private List attributes;
    private boolean standAlone;
    private String charSet;

    public HtmlTag(String name, Map mappings, List attributes, boolean standAlone) {
        this.name = name;
        this.mappings = mappings;
        this.attributes = attributes;
        this.standAlone = standAlone;
        this.charSet = this.charSet;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public String getName() {
        return this.name;
    }

    public Iterator getPropertyIterator() {
        if (this.mappings != null) {
            return this.mappings.entrySet().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getAttributeIterator() {
        if (this.attributes != null) {
            return this.attributes.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public String getProperty(String name) {
        if (this.mappings == null) {
            return null;
        }
        return (String)this.mappings.get(name);
    }

    public String getIgnoreCaseProperty(String name) {
        if (this.mappings == null) {
            return null;
        }
        Iterator iterator = this.mappings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public boolean isDefined(String name) {
        if (this.attributes.contains(name)) {
            return true;
        }
        return this.mappings.keySet().contains(name);
    }

    public String toString() {
        Iterator iterator;
        StringBuffer buffer = new StringBuffer();
        buffer.append('<');
        buffer.append(this.name);
        if (this.mappings != null) {
            iterator = this.mappings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                buffer.append(' ');
                buffer.append((String)entry.getKey());
                buffer.append("=\"");
                buffer.append((String)entry.getValue());
                buffer.append('\"');
            }
        }
        if (this.attributes != null) {
            iterator = this.attributes.iterator();
            while (iterator.hasNext()) {
                buffer.append(' ');
                buffer.append((String)((Object)iterator.next()));
            }
        }
        if (this.isStandAlone()) {
            buffer.append('/');
        }
        buffer.append('>');
        return buffer.toString();
    }

    public static HtmlTag getTag(String string) {
        String name = null;
        int pos = 0;
        int end = string.length();
        if (end == 0) {
            return new HtmlTag("", new HashMap(), new ArrayList(), false);
        }
        boolean standAlone = false;
        HashMap<String, String> mappings = null;
        ArrayList<String> attributes = null;
        if (string.charAt(pos) == '<') {
            ++pos;
        }
        if (string.charAt(end - 1) == '>') {
            --end;
        }
        if (end >= 1 && string.charAt(end - 1) == '/') {
            standAlone = true;
            --end;
        }
        while (pos < end) {
            while (pos < end && (string.charAt(pos) == ' ' || string.charAt(pos) == '\n' || string.charAt(pos) == '\r' || string.charAt(pos) == '\t')) {
                ++pos;
            }
            int valueStartPos = pos;
            while (pos < end && string.charAt(pos) != ' ' && string.charAt(pos) != '\n' && string.charAt(pos) != '\r' && string.charAt(pos) != '\t' && string.charAt(pos) != '=') {
                ++pos;
            }
            int valueEndPos = pos;
            while (pos < end && (string.charAt(pos) == ' ' || string.charAt(pos) == '\n' || string.charAt(pos) == '\r' || string.charAt(pos) == '\t')) {
                ++pos;
            }
            if (pos < end && string.charAt(pos) == '=') {
                String finalValue;
                String key = string.substring(valueStartPos, valueEndPos);
                Object value = null;
                if (pos < end) {
                    ++pos;
                }
                while (pos < end && (string.charAt(pos) == ' ' || string.charAt(pos) == '\n' || string.charAt(pos) == '\r' || string.charAt(pos) == '\t')) {
                    ++pos;
                }
                boolean inQuoutes = false;
                if (pos < end && string.charAt(pos) == '\"') {
                    valueStartPos = ++pos;
                    while (pos < end && (string.charAt(pos - 1) == '\\' || string.charAt(pos) != '\"')) {
                        if (string.charAt(pos) == '<' && pos < end - 2 && string.charAt(pos + 1) == '%' && string.charAt(pos + 2) == '=') {
                            while (pos < end && (string.charAt(pos) != '>' || string.charAt(pos - 1) != '%')) {
                                ++pos;
                            }
                            if (pos >= end) continue;
                            ++pos;
                            continue;
                        }
                        ++pos;
                    }
                    valueEndPos = pos++;
                } else if (pos < end && string.charAt(pos) == '\'') {
                    valueStartPos = ++pos;
                    while (pos < end && (string.charAt(pos - 1) == '\\' || string.charAt(pos) != '\'')) {
                        if (string.charAt(pos) == '<' && pos < end - 2 && string.charAt(pos + 1) == '%' && string.charAt(pos + 2) == '=') {
                            while (pos < end && (string.charAt(pos) != '>' || string.charAt(pos - 1) != '%')) {
                                ++pos;
                            }
                            if (pos >= end) continue;
                            ++pos;
                            continue;
                        }
                        ++pos;
                    }
                    valueEndPos = pos++;
                } else {
                    valueStartPos = pos;
                    while (pos < end && string.charAt(pos) != ' ' && string.charAt(pos) != '\n' && string.charAt(pos) != '\r' && string.charAt(pos) != '\t') {
                        if (string.charAt(pos) == '<' && pos < end - 2 && string.charAt(pos + 1) == '%' && string.charAt(pos + 2) == '=') {
                            while (pos < end && (string.charAt(pos) != '>' || string.charAt(pos - 1) != '%')) {
                                ++pos;
                            }
                            if (pos > end) continue;
                            ++pos;
                            continue;
                        }
                        ++pos;
                    }
                    valueEndPos = pos;
                }
                String string2 = finalValue = valueStartPos < end ? string.substring(valueStartPos, valueEndPos) : "";
                if (mappings == null) {
                    mappings = new HashMap<String, String>();
                }
                mappings.put(key, finalValue);
                continue;
            }
            if (name == null) {
                name = string.substring(valueStartPos, valueEndPos);
                continue;
            }
            if (attributes == null) {
                attributes = new ArrayList<String>();
            }
            attributes.add(string.substring(valueStartPos, valueEndPos));
        }
        if (name == null) {
            name = "";
        }
        return new HtmlTag(name, mappings, attributes, standAlone);
    }
}

