/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.HttpMessageBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.LoggingUtils;

public class HttpMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.http", HttpMessageBundle.class.getName());

    public static void internalErrorWhileCommitting(Throwable reason) {
        m_logger.log(Level.FINE, "J2EE HTTP-00002");
        HttpMessages.logException(reason);
    }

    public static void internalErrorWhileTryingToInstantiate(Exception e) {
        m_logger.log(Level.SEVERE, "J2EE HTTP-00003", e.getMessage());
        HttpMessages.logException(e);
    }

    public static void internalErrorWhileTryingToInstantiate(String siteName, String appName, Throwable reason) {
        m_logger.log(Level.SEVERE, "J2EE HTTP-00004", new Object[]{appName, siteName, reason.getMessage()});
        HttpMessages.logException(reason);
    }

    public static void internalErrorWhileTryingToInstantiateDefault(String siteName, Throwable reason) {
        m_logger.log(Level.SEVERE, "J2EE HTTP-00007", siteName);
        HttpMessages.logException(reason);
    }

    public static void errorUpdatingConfig(String siteName, Throwable reason) {
        m_logger.log(Level.SEVERE, "J2EE HTTP-00008", siteName);
        HttpMessages.logException(reason);
    }

    public static void internalErrorWithHeaderInfo(String headerInfo, Throwable reason) {
        m_logger.log(Level.FINE, "J2EE HTTP-00005", headerInfo);
        HttpMessages.logException(reason);
    }

    public static void internalError(Throwable reason) {
        m_logger.log(Level.FINE, "J2EE HTTP-00006");
        HttpMessages.logException(reason);
    }

    public static void logException(Throwable reason) {
        m_logger.log(Level.FINER, "J2EE HTTP-00001", reason);
    }

    public static void warningApplicationTldCacheBuildFailure(String siteName, Throwable reason) {
        m_logger.log(Level.WARNING, "J2EE HTTP-00009", siteName);
        HttpMessages.logException(reason);
    }

    public static void warningHeaderModificationIsRejected(String applicationName) {
        m_logger.log(Level.WARNING, "J2EE HTTP-00020", applicationName);
    }

    public static String internalErrorWhileTryingToInstantiateSite(String siteName, String fileName, Throwable reason) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE HTTP-00010", new Object[]{siteName, fileName, reason.getMessage()});
    }

    static Logger getLogger() {
        return m_logger;
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void infoListenerInitialized(int port) {
        if (HttpMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.INFO, "J2EE HTTP-00011", Integer.toString(port));
        }
    }

    public static void infoHttpSiteStarting(String name) {
        if (HttpMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.INFO, "J2EE HTTP-00012", name);
        }
    }

    public static void infoHttpSiteStarted(String name) {
        if (HttpMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.INFO, "J2EE HTTP-00013", name);
        }
    }

    public static void infoWebAppStarting(String httpApplicationName) {
        if (HttpMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.INFO, "J2EE HTTP-00014", httpApplicationName);
        }
    }

    public static void infoWebAppStarted(String httpApplicationName) {
        if (HttpMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.INFO, "J2EE HTTP-00015", httpApplicationName);
        }
    }

    public static void severeCouldNotCreateSecureHttpListener(Throwable t) {
        if (HttpMessages.isLoggable(Level.SEVERE)) {
            m_logger.log(Level.SEVERE, "J2EE HTTP-10001", t);
        }
    }

    public static void infoSqlExceptionCleanupExpiredObjects(String application, String dataSource, Throwable reason) {
        m_logger.log(Level.FINE, "J2EE HTTP-00016", new Object[]{application, dataSource});
        HttpMessages.logException(reason);
    }

    public static void infoSqlExceptionInClosingStatementCleanupExpiredObjects(String application, String dataSource, Throwable reason) {
        m_logger.log(Level.FINE, "J2EE HTTP-00017", new Object[]{application, dataSource});
        HttpMessages.logException(reason);
    }

    public static void infoSqlExceptionInClosingConnectionCleanupExpiredObjects(String application, String dataSource, Throwable reason) {
        m_logger.log(Level.FINE, "J2EE HTTP-00018", new Object[]{application, dataSource});
        HttpMessages.logException(reason);
    }

    public static void infoNameNotFoundExceptionInLookingUpDatasourceCleanupExpiredObjects(String application, String dataSource, Throwable reason) {
        m_logger.log(Level.FINE, "J2EE HTTP-00019", new Object[]{application, dataSource});
        HttpMessages.logException(reason);
    }

    public static void warnIncompleteContentTypeHeader(String contentTypeHeader, String requestPath) {
        m_logger.log(Level.FINEST, "J2EE HTTP-00022 ", new Object[]{contentTypeHeader, requestPath});
    }

    public static void warnNoContentTypeHeader(String requestPath) {
        m_logger.log(Level.FINEST, "J2EE HTTP-00021", requestPath);
    }
}

