/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.ejb.EJBInputStream;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.http.JGroupHttpSession;
import com.evermind.server.http.ServletMessages;
import com.evermind.server.http.SessionReplicationService;
import com.evermind.util.ByteString;
import com.oracle.bricks.SessionManagerFactory;
import com.oracle.bricks.j2ee.JGroupConfig;
import com.oracle.bricks.j2ee.ReplicationPolicy;
import com.oracle.bricks.j2ee.Session;
import com.oracle.bricks.j2ee.SessionManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.ChannelException;

public class JGroupHttpService
implements SessionReplicationService {
    static Logger m_logger = ClusteringTraceLogger.getHttpTraceLogger(JGroupHttpService.class);
    private HttpApplication application;
    private SessionManager manager;
    private int promiseTimeout;
    private ReplicationPolicy replicationPolicy = null;

    protected JGroupHttpService(HttpApplication application, HttpApplicationConfig config) throws ChannelException {
        JGroupConfig jconfig = config.getClusterConfig();
        this.application = application;
        this.promiseTimeout = jconfig.getPromiseTimeout();
        this.replicationPolicy = jconfig.getReplicationPolicy();
        this.manager = SessionManagerFactory.create(config);
        this.manager.start();
        if (application.getConfig().isDistributable()) {
            String appName = application.getApplication().getName();
            String channelName = config.getClusterConfig().getGroupName();
            String protocol = config.getClusterConfig().getProtocol();
            String address = this.manager.getLocalAddress().getAddress().getHostAddress();
            String port = Integer.toString(this.manager.getLocalAddress().getPort());
            ClusteringMessages.infoSessionManagerStarted("HTTP", appName, channelName, protocol, address, port);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "HTTP Clustering Service started for Application " + appName + " - state replication enabled over channel " + channelName + " using " + protocol + " protocol on " + address + ":" + port);
            }
        }
    }

    protected HttpApplication getHttpApplication() {
        return this.application;
    }

    public boolean isReplicateServletContext() {
        return false;
    }

    public void setReplicateServletContext(boolean replicateServletContext) {
        if (!replicateServletContext) {
            throw new IllegalStateException("NYI");
        }
    }

    public void updateContextRMIValue(String name) {
        throw new IllegalStateException("NYI");
    }

    public void sendContextValueUpdate(String name, Serializable value) {
        throw new IllegalStateException("NYI");
    }

    public EvermindHttpSession createSession(HttpApplication app, ByteString id, int timeout, byte[] addr) {
        try {
            Session s = this.manager.create(id, null, HttpApplication.getSessionIp(addr), System.currentTimeMillis(), timeout);
            return this.createSession(app, id, timeout, s);
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalStateException("failed in createSession").initCause(e);
        }
    }

    public EvermindHttpSession createSession(HttpApplication app, ByteString id, int timeout, Session internalSession) {
        ClusteringMessages.fineHttpSessionCreatedWithId(id.toString());
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "HTTP Clustering Session created with id = '" + id.toString() + "'");
        }
        return new JGroupHttpSession(this, internalSession, app, id, timeout);
    }

    public void checkSessionTimeouts() {
        this.getHttpApplication()._checkSessionTimeouts();
        try {
            this.manager.reapReplicas();
        }
        catch (InterruptedException e) {
            ServletMessages.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvermindHttpSession getExistingSession(ByteString id) {
        Map sessionMap;
        EvermindHttpSession session = null;
        Map map = sessionMap = this.getHttpApplication().sessions;
        synchronized (map) {
            ByteString sessionId;
            Session internalSession;
            block7: {
                session = (EvermindHttpSession)sessionMap.get(id);
                if (session != null) {
                    return session;
                }
                internalSession = null;
                sessionId = (ByteString)id.clone();
                try {
                    internalSession = (Session)this.manager.get(sessionId, this.promiseTimeout);
                }
                catch (Exception e) {
                    if (!m_logger.isLoggable(Level.FINEST)) break block7;
                    m_logger.log(Level.FINEST, "failed get from manager", e);
                }
            }
            if (internalSession == null) {
                return null;
            }
            session = this.createSession(this.getHttpApplication(), sessionId, internalSession.getMaxInactiveTime(), internalSession);
            sessionMap.put(sessionId, session);
            ((JGroupHttpSession)session).doActivate();
        }
        return session;
    }

    public EvermindHttpSession read(EJBInputStream in) throws IOException, ClassNotFoundException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "This service should never perform this operation");
        }
        throw new IllegalStateException("This service should never perform this operation");
    }

    public void invalidateSession(ByteString id) {
        block2: {
            try {
                this.manager.remove(id);
            }
            catch (InterruptedException e) {
                if (!m_logger.isLoggable(Level.FINEST)) break block2;
                m_logger.log(Level.FINEST, "invalidation interupted", e);
            }
        }
    }

    public void destroy() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "JGroupHttpService.destroy");
        }
        this.getHttpApplication().flushJGroupSessions();
    }

    public ReplicationPolicy getReplicationPolicy() {
        return this.replicationPolicy;
    }
}

