/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.util.ByteString;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ListHttpAccessController
extends HttpServlet {
    private Map users;
    private Resource[] resources;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.users = this.getUsers(config);
        Map accessProperties = this.getAccessProperties(config);
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        Iterator iterator = accessProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)accessProperties.get(key);
            Resource resource = new Resource();
            if (value.equalsIgnoreCase("<NONE>")) {
                resource.users = new ArrayList();
            } else if (!value.equalsIgnoreCase("<ALL>")) {
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                ArrayList<String> usersForThisResource = new ArrayList<String>();
                while (tokenizer.hasMoreElements()) {
                    usersForThisResource.add(tokenizer.nextToken().trim());
                }
                resource.users = usersForThisResource;
            }
            resource.path = new ByteString(key);
            resource.pathLength = resource.path.length;
            resourceList.add(resource);
        }
        Collections.sort(resourceList);
        this.resources = resourceList.toArray(new Resource[resourceList.size()]);
    }

    public boolean validate(String username, String password) {
        return password.equals(this.users.get(username));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.resources.length > 0) {
            ByteString requestURI = null;
            try {
                requestURI = ((EvermindHttpServletRequest)request).requestURI;
            }
            catch (ClassCastException e) {
                requestURI = new ByteString(request.getRequestURI());
                requestURI = requestURI.substring(request.getContextPath().length());
            }
            int uriLength = requestURI.length();
            for (int i = 0; i < this.resources.length; ++i) {
                if (uriLength < this.resources[i].pathLength || !requestURI.startsWith(this.resources[i].path) || this.resources[i].users.contains(request.getRemoteUser())) continue;
                throw new SecurityException("Access to HttpResource denied");
            }
        }
    }

    public Map getUsers(ServletConfig config) {
        try {
            String usersURLString = config.getInitParameter("users.properties");
            if (usersURLString == null) {
                return new Properties();
            }
            URL usersURL = new URL(usersURLString);
            Properties users = new Properties();
            users.load(usersURL.openStream());
            return users;
        }
        catch (Exception e) {
            return new HashMap();
        }
    }

    public Map getAccessProperties(ServletConfig config) {
        try {
            String accessURLString = config.getInitParameter("access.properties");
            if (accessURLString == null) {
                return new Properties();
            }
            URL accessURL = new URL(accessURLString);
            Properties accessProperties = new Properties();
            accessProperties.load(accessURL.openStream());
            return accessProperties;
        }
        catch (Exception e) {
            return new HashMap();
        }
    }

    private class Resource
    implements Comparable {
        int pathLength;
        ByteString path;
        List users;

        private Resource() {
        }

        public int compareTo(Object object) {
            Resource other = (Resource)object;
            if (other.pathLength != this.pathLength) {
                return other.pathLength - this.pathLength;
            }
            return other.path.compareTo(this.path);
        }
    }
}

