/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.StandardRequestLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.BusStopLogWriter;
import oracle.core.ojdl.BusStopLogWriterException;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogManagerInitException;
import oracle.core.ojdl.LogMessage;
import oracle.dms.instrument.CorrelationContext;
import oracle.j2ee.util.TraceLogger;

public class ODLRequestLogger
extends StandardRequestLogger {
    protected LogManager mLogManager;
    protected BusStopLogWriter mLogWriter;
    protected String mPath = null;
    protected String mCanonicalPath = null;
    protected Properties messageProperties;
    protected Properties mInitProperties;
    protected int mMaxSegmentSize;
    protected int mMaxSize;
    private boolean mInitialized;
    private Logger m_traceLogger = TraceLogger.getLogger(ODLRequestLogger.class);

    public ODLRequestLogger(String path, String canonicalPath, int maxFileSize, int maxDirectorySize, Properties properties) throws InstantiationException {
        if (maxFileSize > maxDirectorySize) {
            throw new InstantiationException("max-file-size must be less then the total size allowed in the log folder");
        }
        this.mPath = path;
        this.mCanonicalPath = canonicalPath;
        this.mInitProperties = properties;
        this.mInitialized = false;
        this.setMaxFileSize(maxFileSize);
        this.setMaxDirectorySize(maxDirectorySize);
    }

    protected void init() throws IOException {
        if (!this.mInitialized) {
            this.mLogManager = LogManager.getLogManager();
            try {
                this.mLogManager.init(this.mInitProperties);
            }
            catch (LogManagerInitException e) {
                this.m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
                throw new IOException(e.getMessage());
            }
            if (this.mCanonicalPath == null) {
                this.mCanonicalPath = this.mInitProperties.getProperty("oc4j.ODLLogger.logType");
            }
            if (this.mCanonicalPath == null) {
                System.out.println("ODLLogger: logType not supplied");
                System.exit(0);
            }
            try {
                this.mLogWriter = BusStopLogWriter.create((String)this.mCanonicalPath, (long)this.mMaxSegmentSize, (long)this.mMaxSize, null);
            }
            catch (BusStopLogWriterException e) {
                this.m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
                throw new IOException(e.getMessage());
            }
            this.messageProperties = new Properties();
            this.messageProperties.setProperty("COMPONENT_ID", "OC4J");
            this.messageProperties.setProperty("MSG_TYPE", "NOTIFICATION");
            this.messageProperties.setProperty("MSG_LEVEL", "1");
            this.mInitialized = true;
        }
    }

    public synchronized void writeLog(byte[] buffer, int pos) throws IOException {
        LogMessage.InstanceId instanceId;
        if (!this.mInitialized) {
            this.init();
        }
        if ((instanceId = CorrelationContext.getExecContextId()) != null) {
            this.messageProperties.setProperty("EXEC_CONTEXT_UNIQUE_ID", instanceId.getUniqueId());
        }
        this.messageProperties.setProperty("MSG_TEXT", new String(buffer, 0, pos));
        LogMessage logMessage = new LogMessage(this.messageProperties);
        this.mLogWriter.write(logMessage, true);
    }

    public boolean equals(Object o) {
        if (o instanceof ODLRequestLogger) {
            ODLRequestLogger odlRequestLogger = (ODLRequestLogger)o;
            if (odlRequestLogger.mPath.equals(this.mPath)) {
                return true;
            }
        }
        return false;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.mMaxSegmentSize = maxFileSize * 1000;
    }

    public void setMaxDirectorySize(int maxDirectorySize) {
        this.mMaxSize = maxDirectorySize * 1000;
    }

    public int getMaxFileSize() {
        return this.mMaxSegmentSize / 1000;
    }

    public int getMaxDirectorySize() {
        return this.mMaxSize / 1000;
    }

    public String getPath() {
        return this.mPath;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.write(indention + "\t<odl-access-log path=\"" + this.mPath + "\"");
        out.write(" max-file-size=\"" + this.getMaxFileSize() + "\"");
        out.write(" max-directory-size=\"" + this.getMaxDirectorySize() + "\"");
        out.println(" />");
    }

    public String toString() {
        return "ODLLogger path: " + this.mPath + " maxFileSize: " + this.getMaxFileSize() + " maxDirectorySize: " + this.getMaxDirectorySize();
    }
}

