/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.naming.ContextUtils;
import com.evermind.naming.file.FileContext;
import com.evermind.security.UserManager;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.http.HttpApplicationConfigContext;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.server.http.deployment.SyntheticWebModuleDescriptor;
import com.evermind.util.ConfigUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.naming.Context;
import javax.naming.NamingException;

public class XMLHttpApplicationConfigContext
implements HttpApplicationConfigContext {
    protected EnterpriseArchive archive;
    protected String shortName;
    protected String path;
    protected HttpApplicationConfigContext parent;
    protected String root;
    protected UserManager parentUserManager;
    protected long maxInactivityTime;
    protected HttpApplicationConfig config;
    protected boolean preload;
    protected boolean shared;
    protected boolean synthetic = false;
    protected SyntheticWebModuleDescriptor syntheticDescriptor;

    public XMLHttpApplicationConfigContext(EnterpriseArchive archive, String shortName, URL url, String path, HttpApplicationConfigContext parent, String root, UserManager parentUserManager, long maxInactivityTime, boolean preload, boolean shared, boolean synthetic, SyntheticWebModuleDescriptor syntheticDescriptor) {
        this.archive = archive;
        this.shortName = shortName;
        this.path = path;
        this.parent = parent;
        this.setRoot(root);
        this.parentUserManager = parentUserManager;
        this.maxInactivityTime = maxInactivityTime;
        this.preload = preload;
        this.shared = shared;
        this.synthetic = synthetic;
        this.syntheticDescriptor = syntheticDescriptor;
    }

    public void setRoot(String root) {
        if (root == null) {
            this.root = null;
            return;
        }
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        this.root = root;
    }

    public long getMaxInactivityTime() {
        return this.maxInactivityTime;
    }

    public String getRoot() {
        return this.root;
    }

    public boolean preload() {
        return this.preload;
    }

    public HttpApplicationConfig getConfiguration(boolean load) throws InstantiationException {
        if (this.config == null && !load) {
            return null;
        }
        return this.getConfiguration();
    }

    public HttpApplicationConfig getConfiguration() throws InstantiationException {
        if (this.config != null) {
            return this.config;
        }
        if (this.path == null) {
            this.config = this.getDescriptor();
        }
        HttpApplicationDescriptor descriptor = this.getDescriptor();
        try {
            if (this.path.endsWith(".xml")) {
                URL url = ConfigUtils.getURL(this.archive.getURL(), this.path);
                try {
                    descriptor.init(url);
                }
                catch (InstantiationException e) {
                    throw new InstantiationException("Error parsing " + url + ": " + e.getMessage());
                }
            }
            if (!this.synthetic) {
                try {
                    descriptor.init();
                    String data = (String)this.archive.getExtraParam(this.path + ".war");
                    if (data != null) {
                        descriptor.setDeploymentData(data);
                    }
                    descriptor.setParsingOrionXML(true);
                    descriptor.initDeployment();
                    descriptor.setParsingOrionXML(false);
                    data = (String)this.archive.getExtraParam(this.path + ".war:webservices");
                    if (data != null) {
                        descriptor.initWebServices(data.getBytes());
                    } else {
                        descriptor.initWebServices();
                    }
                    this.syntheticDescriptor = descriptor.getWebServicesDescriptor();
                }
                catch (InstantiationException e) {
                    throw new InstantiationException("Error loading web-app '" + this.shortName + "' at " + descriptor.getContext() + ": " + e.getMessage());
                }
            }
            if (this.syntheticDescriptor != null) {
                try {
                    descriptor.init(this.syntheticDescriptor);
                }
                catch (InstantiationException e) {
                    throw new InstantiationException("Error loading web-app '" + this.shortName + "' at " + descriptor.getContext() + ": " + e.getMessage());
                }
            }
            this.config = descriptor;
            return this.config;
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Invalid URL: " + this.path + " (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            throw new InstantiationException("Could not read web-app config file at " + this.path + ": " + e.getMessage());
        }
    }

    public HttpApplicationDescriptor getDescriptor() throws InstantiationException {
        HttpApplicationDescriptor descriptor;
        block21: {
            descriptor = new HttpApplicationDescriptor(this.archive, this.shortName, this.parent == null ? null : (HttpApplicationDescriptor)this.parent.getConfiguration(), this.getParentUserManager(), false, this.synthetic);
            if (this.path == null) {
                return descriptor;
            }
            if (this.path.endsWith(".xml")) {
                return descriptor;
            }
            Context parentContext = this.archive == null ? null : this.archive.getContext();
            try {
                Context subContext = parentContext == null ? ContextUtils.getContext(ConfigUtils.getURL(this.archive.getURL(), this.path), false) : (parentContext instanceof FileContext ? ContextUtils.getContext(ConfigUtils.getURL(((FileContext)parentContext).getFile().toURL(), this.path), false) : ContextUtils.getContext(parentContext, this.path, false));
                descriptor.setPackaged(true);
                descriptor.setContext(subContext);
                File file = ContextUtils.getFile(descriptor.getContext(), false);
                if (!this.synthetic && file != null && !file.exists()) {
                    try {
                        throw new InstantiationException("Error finding web-app '" + this.shortName + "' at " + file.getCanonicalPath() + ": No such file or directory");
                    }
                    catch (IOException e) {
                        throw new InstantiationException("Error finding web-app '" + this.shortName + "' at " + file.getPath() + ": No such file or directory");
                    }
                }
                if (file != null && file.isDirectory()) {
                    descriptor.setURL(file.toURL());
                }
                if (this.archive == null || !this.archive.isSeparateDeploymentContext()) break block21;
                if (file != null && file.isDirectory() && this.archive.isExplodedDeployment()) {
                    Context ctx = ContextUtils.getContext(file.toURL(), false);
                    try {
                        Context deploymentContext = ctx.lookup("WEB-INF") != null ? (Context)ctx.lookup("WEB-INF") : ctx.createSubcontext("WEB-INF");
                        descriptor.setDeploymentContext(deploymentContext);
                        break block21;
                    }
                    catch (NamingException ne) {
                        throw new InstantiationException("Error creating deployment directory: " + ne.getMessage());
                    }
                }
                Context deploymentContext = this.archive.getDeploymentContext();
                if (this.shortName != null) {
                    if (deploymentContext != null) {
                        try {
                            deploymentContext = (Context)deploymentContext.lookup(this.shortName);
                        }
                        catch (NamingException e) {
                            try {
                                deploymentContext = deploymentContext.createSubcontext(this.shortName);
                            }
                            catch (NamingException ne) {
                                throw new InstantiationException("Error creating deployment directory: " + e.getMessage());
                            }
                        }
                    }
                } else {
                    deploymentContext = null;
                }
                if (deploymentContext != null) {
                    descriptor.setDeploymentContext(deploymentContext);
                }
            }
            catch (MalformedURLException e) {
                throw new InstantiationException("Invalid URL: " + this.path + " (" + e.getMessage() + ")");
            }
            catch (IOException e) {
                throw new InstantiationException("Could not read web-app config file at " + this.path + ": " + e.getMessage());
            }
            catch (NamingException e) {
                throw new InstantiationException("Could not read web-app config file at " + this.path + ": " + e.getMessage());
            }
        }
        return descriptor;
    }

    public void flushConfig() {
        this.config = null;
    }

    public void setConfiguration(HttpApplicationConfig config) {
        this.config = config;
    }

    protected UserManager getParentUserManager() throws InstantiationException {
        if (this.parentUserManager != null) {
            return this.parentUserManager;
        }
        return null;
    }

    public HttpApplicationConfig getConfigurationIfActive() {
        return this.config;
    }

    public static final void debugPrint(String text) {
    }
}

