/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.deployment.RoleNameContainer;
import com.evermind.server.http.deployment.SecurityConstraint;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthorizationConstraint
extends AbstractDescribable
implements XMLizable,
RoleNameContainer {
    protected SecurityConstraint securityConstraint;
    protected List roleNames = new ArrayList();

    public AuthorizationConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraint = securityConstraint;
    }

    public AuthorizationConstraint(SecurityConstraint securityConstraint, Node node) {
        this.securityConstraint = securityConstraint;
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String name = nodes.item(i).getNodeName();
            if (name.equals("#text")) continue;
            if (name.equals("description")) {
                this.setDescription(XMLUtils.getStringValue(nodes.item(i)));
                continue;
            }
            if (!name.equals("role-name")) continue;
            this.roleNames.add(XMLUtils.getStringValue(nodes.item(i)));
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<auth-constraint>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.roleNames != null) {
            XMLUtils.writeStrings(this.roleNames, "role-name", out, indention + "\t");
        }
        out.println(indention + "</auth-constraint>");
    }

    public List getRoleNames() {
        return this.roleNames;
    }

    public void addRoleName(String name) {
        this.roleNames.add(name);
        this.firePropertyChangeEvent("roleNames", null, name);
    }

    public void removeRoleName(int pos) {
        this.firePropertyChangeEvent("roleNames", this.roleNames.remove(pos), null);
    }

    public void removeRoleName(String name) {
        this.roleNames.remove(name);
        this.firePropertyChangeEvent("roleNames", name, null);
    }

    public SecurityConstraint getSecurityConstraint() {
        return this.securityConstraint;
    }
}

