/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.deployment.IconDescriptor;
import com.evermind.server.http.deployment.WebApp24Descriptor;
import com.evermind.server.http.deployment.WebComponentDescriptor;
import com.evermind.util.ServerProperties;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilterDescriptor
extends WebComponentDescriptor
implements XMLizable,
WebApp24Descriptor {
    private boolean isPartOfOrionWeb = false;

    public FilterDescriptor() {
    }

    public FilterDescriptor(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("icon")) {
                    this.setIcon(new IconDescriptor(node));
                    continue;
                }
                if (name.equals("filter-name")) {
                    this.setName(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("display-name")) {
                    this.setDisplayName(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("filter-class")) {
                    this.setClassName(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("init-param")) {
                    if (ServerProperties.getOracleCtsUseCtsFlags() && (this.getName() == null || this.getClassName() == null)) {
                        throw new InstantiationException("filter subelement is not defined in correct order: init-param");
                    }
                    this.parseInitParameter(node, null, false);
                    continue;
                }
                throw new InstantiationException("Unknown filter subtag: " + name);
            }
        }
        if (this.getName() == null) {
            throw new InstantiationException("filter tag with missing filter-name subtag");
        }
        if (this.getClassName() == null || this.getClassName().equals("")) {
            throw new InstantiationException("filter tag (" + this.getName() + ") with missing filter-class subtag");
        }
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<filter>");
        if (this.getIcon() != null) {
            this.getIcon().writeXML(out, indention + "\t");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<filter-name>" + XMLUtils.encode(this.getName()) + "</filter-name>");
        }
        if (this.getDisplayName() != null) {
            out.println(indention + "\t<display-name>" + XMLUtils.encode(this.getDisplayName()) + "</display-name>");
        }
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getClassName() != null) {
            out.println(indention + "\t<filter-class>" + XMLUtils.encode(this.getClassName()) + "</filter-class>");
        }
        this.writeInitParams(out, indention + "\t");
        out.println(indention + "</filter>");
    }

    public void writeWebApp24XML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<filter>");
        this.writeXMLElement(out, indention, "description", this.getDescription());
        this.writeXMLElement(out, indention, "display-name", this.getDisplayName());
        if (this.getIcon() != null) {
            this.getIcon().writeXML(out, indention + "\t");
        }
        this.writeXMLElement(out, indention, "filter-name", this.getName());
        this.writeXMLElement(out, indention, "filter-class", this.getClassName());
        this.writeWebAppInitParams(out, indention + "\t");
        out.println(indention + "</filter>");
    }

    public String toString() {
        return this.getName();
    }

    public boolean isPartOfOrionWeb() {
        return this.isPartOfOrionWeb;
    }

    public void setPartOfOrionWeb(boolean partOfOrionWeb) {
        this.isPartOfOrionWeb = partOfOrionWeb;
    }
}

