/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.deployment.SecurityRoleReference;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.server.http.deployment.SecurityConstraint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContextException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.acc.JaccWrapper;

public class JACCPropertyChangeListener
implements PropertyChangeListener {
    String configId;
    JaccWrapper jaccDeployerDelegatee;
    Logger m_logger = TraceLogger.getLogger(JACCPropertyChangeListener.class);

    JACCPropertyChangeListener(String newConfigId) {
        this.configId = newConfigId;
        this.jaccDeployerDelegatee = new JaccWrapper(this.configId);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        SecurityRole role;
        this.m_logger.log(Level.FINEST, "JACCPropertyChangeListener.propertyChange {0}", evt);
        if (evt.getPropertyName() == "securityConstraints") {
            SecurityConstraint constraint = (SecurityConstraint)evt.getNewValue();
            if (constraint != null) {
                try {
                    new JaccWrapper(this.configId).addWebSecurityConstraint(constraint);
                }
                catch (PolicyContextException pce) {
                    this.m_logger.log(Level.WARNING, "PolicyContextException: " + pce.getMessage(), pce);
                }
            }
        } else if (evt.getPropertyName() == "securityRoles" && (role = (SecurityRole)evt.getNewValue()) != null) {
            try {
                new JaccWrapper(this.configId).addRoleMapping(role);
            }
            catch (PolicyContextException pce) {
                this.m_logger.log(Level.WARNING, "PoliyContextException:", pce);
            }
        }
    }

    protected String getConfigId() {
        return this.configId;
    }

    protected void postInit(HttpApplicationDescriptor desc) {
    }

    protected void persist() {
    }

    protected void reset() {
    }

    public PropertyChangeListener createServletChangeListener() {
        return new JACCServletListener();
    }

    class JACCServletListener
    implements PropertyChangeListener {
        String name;

        JACCServletListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JACCPropertyChangeListener.this.m_logger.log(Level.FINEST, "JACCPropertyChangeListener.propertyChange {0}", evt);
            if (evt.getPropertyName() == "securityRoleReferences") {
                SecurityRoleReference roleRef = (SecurityRoleReference)evt.getNewValue();
                if (roleRef != null) {
                    try {
                        new JaccWrapper(JACCPropertyChangeListener.this.configId).addWebSecurityRoleRef(roleRef, this.name);
                    }
                    catch (RuntimeException ex) {
                        JACCPropertyChangeListener.this.m_logger.log(Level.WARNING, "Exception: adding " + this.name, ex);
                    }
                    catch (PolicyContextException e) {
                        JACCPropertyChangeListener.this.m_logger.log(Level.WARNING, "Exception: for application context " + JACCPropertyChangeListener.this.configId, e);
                    }
                }
            } else if (evt.getPropertyName().equalsIgnoreCase("name")) {
                String servletName;
                this.name = servletName = (String)evt.getNewValue();
            }
        }
    }
}

