/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.xml.KeyValueMapping;
import com.evermind.xml.XMLUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import org.w3c.dom.Node;

public class MimeMapping
extends KeyValueMapping
implements Serializable {
    String requestHandler;

    public MimeMapping() {
    }

    public MimeMapping(String key, String value) {
        this.setKey(key);
        this.setValue(value);
    }

    public MimeMapping(Node parent) throws InstantiationException {
        super(parent, "mime-mapping", "extension", "mime-type");
    }

    public void parseXML(Node parent) throws InstantiationException {
        this.parseXML(parent, "mime-mapping", "extension", "mime-type");
    }

    protected void parseAdditionalField(String tagName, Node node) throws InstantiationException {
        if (node.getNodeName().equals("request-handler")) {
            this.requestHandler = XMLUtils.getStringValue(node);
        } else {
            super.parseAdditionalField(tagName, node);
        }
    }

    public void parseDeploymentXML(Node parent) throws InstantiationException {
        String requestHandler = XMLUtils.getNodeAttribute(parent, "request-handler");
        if (requestHandler != null) {
            this.requestHandler = requestHandler;
        }
    }

    public void writeDeploymentXML(PrintWriter out, String indention) {
        out.print(indention + "<mime-mapping-deployment type=\"" + this.getKey() + "\"");
        if (this.requestHandler != null) {
            out.print(" request-handler=\"" + this.getRequestHandler() + "\"");
        }
        out.println(" />");
    }

    public String getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(String requestHandler) {
        this.requestHandler = requestHandler;
    }

    public void writeXML(PrintWriter out, String indention) {
        this.writeXML(out, indention, "txt", "text/plain", "mime-mapping", "extension", "mime-type", false);
    }
}

