/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.http.ServletInstanceInfo;
import com.evermind.server.http.deployment.JspConfigDescriptor;
import com.evermind.util.ByteString;
import com.evermind.util.ByteStringCache;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServletMapping
implements Serializable,
XMLizable,
Comparable,
Cloneable {
    public static final int EXACT = 0;
    public static final int PATH = 1;
    public static final int EXTENSION = 2;
    public static final int WILDCARD = 3;
    public static final int DEFAULT = 4;
    public static final int UNDEFINED = 5;
    public static final int NO_MATCH = Integer.MIN_VALUE;
    private static final int LESS_THAN = -1;
    private static final int EQUAL = 0;
    private static final int GREATER_THAN = 1;
    private static final ByteString EMPTY_BYTESTRING = new ByteString("");
    protected String servletName;
    protected String urlPattern;
    private int type;
    private ByteString prefix;
    private ByteString suffix;
    private boolean isDirectory;
    private ByteString servletNameAsByteString;
    private ServletInstanceInfo info;
    private boolean isPartOfOrionWeb = false;

    public ServletMapping() {
    }

    public ServletMapping(Node parent) throws InstantiationException {
        this(parent, false);
    }

    protected ServletMapping(Node parent, boolean isParsingOrionXML) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                String name = nodes.item(i).getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("servlet-name")) {
                    this.setServletName(XMLUtils.getStringValue(nodes.item(i)));
                    continue;
                }
                if (name.equals("url-pattern")) {
                    this.setURLPattern(XMLUtils.getUrlPatternValue(nodes.item(i)));
                    continue;
                }
                throw new InstantiationException("servlet-mapping with unknown subtag: " + name);
            }
        }
        if (this.servletName == null) {
            throw new InstantiationException("Missing 'servlet-name' subtag in servlet-mapping tag");
        }
        if (this.urlPattern == null) {
            throw new InstantiationException("Missing 'url-pattern' subtag in servlet-mapping tag");
        }
        if (isParsingOrionXML) {
            this.isPartOfOrionWeb = true;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    public boolean init(String contextPath, ByteStringCache cache) {
        this.servletNameAsByteString = cache.getByteString(this.servletName);
        if (this.urlPattern.equals("/")) {
            return false;
        }
        if (this.urlPattern.equals("/*")) {
            this.type = 1;
            this.prefix = EMPTY_BYTESTRING;
            return true;
        }
        String pattern = this.urlPattern;
        int starIndex = pattern.indexOf(42);
        if (starIndex < 0) {
            this.type = 0;
            if (pattern.endsWith("/")) {
                this.isDirectory = true;
                if (contextPath != null && contextPath.length() > 0 || pattern.length() > 1) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
            }
            this.prefix = cache.getByteString(pattern);
            this.suffix = EMPTY_BYTESTRING;
            return true;
        }
        if (starIndex == 0) {
            this.type = 2;
            this.suffix = cache.getByteString(pattern.substring(starIndex + 1, pattern.length()));
            return true;
        }
        if (starIndex < pattern.length() - 1) {
            this.type = 3;
            this.prefix = cache.getByteString(pattern.substring(0, starIndex));
            this.suffix = cache.getByteString(pattern.substring(starIndex + 1, pattern.length()));
            return true;
        }
        this.type = 1;
        if (pattern.endsWith("/*")) {
            this.isDirectory = true;
            pattern = pattern.substring(0, pattern.length() - 2);
        } else if (contextPath != null && contextPath.length() > 0 || pattern.length() > 1) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        this.prefix = cache.getByteString(pattern);
        this.suffix = null;
        return true;
    }

    public int compareTo(Object o) {
        ServletMapping other = (ServletMapping)o;
        if (this.type == other.type) {
            if (this.type == 1) {
                int otherLength;
                int length = this.urlPattern.length();
                if (length == (otherLength = other.urlPattern.length())) {
                    if (this instanceof JspConfigDescriptor.JspConfigImplicitServletMapping) {
                        return -1;
                    }
                    if (other instanceof JspConfigDescriptor.JspConfigImplicitServletMapping) {
                        return 1;
                    }
                    return 0;
                }
                if (length > otherLength) {
                    return -1;
                }
                return 1;
            }
            if (this instanceof JspConfigDescriptor.JspConfigImplicitServletMapping) {
                return -1;
            }
            if (other instanceof JspConfigDescriptor.JspConfigImplicitServletMapping) {
                return 1;
            }
            return 0;
        }
        return this.type > other.type ? 1 : -1;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String name) {
        this.servletName = name;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public int getType() {
        return this.type;
    }

    public ByteString getPrefix() {
        return this.prefix;
    }

    public ByteString getSuffix() {
        return this.suffix;
    }

    public ByteString getServletNameAsByteString() {
        return this.servletNameAsByteString;
    }

    public ServletInstanceInfo getServletInfo() {
        return this.info;
    }

    public void setServletInfo(ServletInstanceInfo servletInfo) {
        this.info = servletInfo;
    }

    protected void setURLPattern(String urlPattern) {
        this.urlPattern = urlPattern.startsWith("/*.") ? urlPattern.substring(1) : (!urlPattern.startsWith("/") && !urlPattern.startsWith("*.") ? "/".concat(urlPattern) : urlPattern);
    }

    public void writeXML(PrintWriter out, String indention) {
        if (this.urlPattern == null) {
            this.urlPattern = "/*";
        }
        if (this.servletName == null) {
            this.servletName = "javax.servlet.http.HttpServlet";
        }
        out.println(indention + "<servlet-mapping>");
        out.println(indention + "\t<servlet-name>" + XMLUtils.encode(this.servletName) + "</servlet-name>");
        out.println(indention + "\t<url-pattern>" + XMLUtils.encode(this.urlPattern) + "</url-pattern>");
        out.println(indention + "</servlet-mapping>");
    }

    public static int findMatch(ByteString originalPath, ByteString path, boolean endsWithSlash, boolean servlet13CompliantPathInfo, ServletMapping[] mappings) {
        int count = mappings.length;
        for (int i = 0; i < count; ++i) {
            ServletMapping mapping = mappings[i];
            if (mapping.prefix != null && !path.startsWith(mapping.prefix)) continue;
            if (mapping.type == 0) {
                if (path.length != mapping.prefix.length && originalPath.length != mapping.prefix.length) continue;
                if (mapping.isDirectory) {
                    if (!endsWithSlash) {
                        return -i;
                    }
                } else if (endsWithSlash) {
                    continue;
                }
            } else {
                if (mapping.type == 2 && endsWithSlash || mapping.suffix != null && !path.endsWith(mapping.suffix)) continue;
                if (mapping.type == 1 && mapping.isDirectory) {
                    if (mapping.prefix.length == originalPath.length) {
                        if (!servlet13CompliantPathInfo) {
                            return -i;
                        }
                    } else if (path.data[path.offset + mapping.prefix.length] != 47) continue;
                }
            }
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public String debugInfo() {
        if (this.type != 5) {
            String typeStr = null;
            switch (this.type) {
                case 0: {
                    typeStr = "Exact: ";
                    break;
                }
                case 1: {
                    typeStr = "Path: ";
                    break;
                }
                case 2: {
                    typeStr = "Extension: ";
                    break;
                }
                case 3: {
                    typeStr = "Wildcard: ";
                    break;
                }
                case 4: {
                    typeStr = "Default: ";
                }
            }
            return typeStr + this.urlPattern + " --> " + this.servletName;
        }
        return this.urlPattern + " --> " + this.servletName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("servlet-mapping: ");
        buf.append("  servlet-name: ");
        buf.append(this.getServletName());
        buf.append("  url-pattern: ");
        buf.append(this.getURLPattern());
        buf.append("\n");
        return buf.toString();
    }

    public boolean isPartOfOrionWeb() {
        return this.isPartOfOrionWeb;
    }

    public void setPartOfOrionWeb(boolean partOfOrionWeb) {
        this.isPartOfOrionWeb = partOfOrionWeb;
    }
}

