/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConfigPropertyEvent;
import com.evermind.server.jms.ConfigPropertyListener;
import com.evermind.server.jms.DummyStats;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.KnobsController;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.State;
import oracle.dms.spy.Spy;

public final class DMSSupport
extends DummyStats {
    private static boolean s_noDms = (Boolean)KnobsController.getKnobsController().listenToConfigProperty("oc4j.jms.noDms", new ConfigPropertyListener(){

        public void onConfigPropertyChange(ConfigPropertyEvent event) {
            DMSSupport.setNoDms((Boolean)event.getPropertyValue());
        }
    });
    private static boolean s_globalNoDms = "none".equals(System.getProperty("oracle.dms.sensors"));
    private static final String NO_STATS = "DMS support disabled.";
    private final Noun m_noun;
    private final Map m_state = new HashMap();
    private final Map m_event = new HashMap();
    private final Map m_phase = new HashMap();
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(DMSSupport.class);
    private static long s_total = 0L;
    private static long s_active = 0L;

    static DummyStats create(String parent, String self, String type) {
        return DMSSupport.getNoDms() ? DummyStats.getInstance() : new DMSSupport(parent, self, type);
    }

    private DMSSupport(String parent, String self, String type) {
        super(DMSSupport.mungeParent(parent), DMSSupport.munge(self));
        Noun n = null;
        try {
            n = Noun.create((String)this.getName(), (String)(type + "Stats"));
        }
        catch (Throwable ex) {
            s_traceLogger.fine("DMSSupport({0}, {1}, {2})", new Object[]{parent, self, type}, ex);
        }
        this.m_noun = n;
        DMSSupport.incr();
    }

    protected void finalize() throws Throwable {
        this.close();
        DMSSupport.decr();
        super.finalize();
    }

    public synchronized void close() {
        try {
            if (this.m_noun != null) {
                this.m_noun.destroy();
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("close({0})", new Object[]{this.getName()}, ex);
        }
    }

    public synchronized void state(String state, Object val) {
        this.state(state, val, false);
    }

    public synchronized void state(String state, Object val, boolean ctor) {
        try {
            State s = this.getState(state);
            if (s != null) {
                s.update(val);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("state({0}, {1}, {2})", new Object[]{this.getName(), state, val}, ex);
        }
    }

    public Object getStateValue(String state) {
        Object ret = null;
        try {
            State s = this.getState(state);
            if (s != null) {
                ret = s.getValue();
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("getStateValue({0}, {1})", new Object[]{this.getName(), state}, ex);
        }
        return ret;
    }

    public synchronized void initEvent(String event) {
        this.getEvent(event);
    }

    public synchronized void event(String event) {
        try {
            Event e = this.getEvent(event);
            if (e != null) {
                e.occurred();
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("event({0}, {1})", new Object[]{this.getName(), event}, ex);
        }
    }

    public int getEventCount(String event) {
        int ret = 0;
        try {
            Event e = this.getEvent(event);
            if (e != null) {
                ret = (Integer)e.getValue();
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("getEventCount({0}, {1})", new Object[]{this.getName(), event}, ex);
        }
        return ret;
    }

    public synchronized void initPhase(String phase) {
        this.getPhase(phase);
    }

    public synchronized void addPhase(String phase, long time) {
        try {
            PhaseEvent p = this.getPhase(phase);
            if (p != null) {
                p.stop(p.start() - time);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("addPhase({0}, {1}, {2})", new Object[]{this.getName(), phase, String.valueOf(time)}, ex);
        }
    }

    public synchronized long phase(String phase) {
        long tok = 0L;
        try {
            PhaseEvent p = this.getPhase(phase);
            if (p != null) {
                tok = p.start();
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("phaseStart({0}, {1})", new Object[]{this.getName(), phase}, ex);
        }
        return tok;
    }

    public synchronized void phase(String phase, long tok) {
        try {
            PhaseEvent p = this.getPhase(phase);
            if (p != null) {
                p.stop(tok);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("phaseStop({0}, {1})", new Object[]{this.getName(), phase}, ex);
        }
    }

    public static void dump() {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(System.out, true);
            if (DMSSupport.getNoDms()) {
                pw.println(NO_STATS);
            } else {
                Spy.dump((PrintWriter)pw, (boolean)false);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("dump", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stats() {
        if (DMSSupport.getNoDms()) {
            return NO_STATS;
        }
        StringWriter sw = null;
        PrintWriter pw = null;
        String ret = "";
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            Spy.dump((PrintWriter)pw, (boolean)false);
            pw.flush();
            sw.flush();
            ret = sw.toString();
        }
        catch (Throwable ex) {
            try {
                s_traceLogger.fine("stats", ex);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                JMSUtils.closeIt(pw);
                JMSUtils.closeIt(sw);
            }
        }
        JMSUtils.closeIt(pw);
        JMSUtils.closeIt(sw);
        return ret;
    }

    private static boolean getNoDms() {
        return s_globalNoDms || s_noDms;
    }

    private static void setNoDms(boolean noDms) {
        s_noDms = noDms;
    }

    private static String munge(String name) {
        return name.replace('/', '_');
    }

    private static String mungeParent(String parent) {
        return parent.replaceAll("jms/", "jms_");
    }

    private State getState(String state) {
        State s = (State)this.m_state.get(state);
        if (s == null) {
            s = State.create((Noun)this.m_noun, (String)state, (String)"", (String)"", null);
            this.m_state.put(state, s);
        }
        return s;
    }

    private Event getEvent(String event) {
        Event e = (Event)this.m_event.get(event);
        if (e == null) {
            e = Event.create((Noun)this.m_noun, (String)event, (String)"");
            e.deriveMetric(511);
            this.m_event.put(event, e);
        }
        return e;
    }

    private PhaseEvent getPhase(String phase) {
        PhaseEvent p = (PhaseEvent)this.m_phase.get(phase);
        if (p == null) {
            p = PhaseEvent.create((Noun)this.m_noun, (String)phase, (String)"");
            p.deriveMetric(511);
            this.m_phase.put(phase, p);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incr() {
        String string = NO_STATS;
        synchronized (NO_STATS) {
            ++s_total;
            ++s_active;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void decr() {
        String string = NO_STATS;
        synchronized (NO_STATS) {
            --s_active;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String pp() {
        String ret = "";
        String string = NO_STATS;
        synchronized (NO_STATS) {
            ret = "DMSSupport[total=" + s_total + ",active=" + s_active + "]";
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }
}

