/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;

public final class EvermindStreamMessage
extends EvermindMessage
implements StreamMessage {
    private byte[] m_data = new byte[0];
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(EvermindStreamMessage.class);
    private transient ByteArrayInputStream m_tbuf = null;
    private transient ByteArrayInputStream m_binp = null;
    private transient DataInputStream m_dinp = null;
    private transient ByteArrayOutputStream m_bout = null;
    private transient DataOutputStream m_dout = null;
    private transient Object m_curr = null;
    private transient boolean m_ok = true;
    static final long serialVersionUID = 659780676640167990L;

    EvermindStreamMessage() throws JMSException {
    }

    protected final void xmlBody(PrintWriter out) {
        try {
            this.reset();
        }
        catch (Throwable ex) {
            s_traceLogger.fine("xmlBody", ex);
        }
        String pfx = "    ";
        out.println(pfx + "<streambody>");
        try {
            while (true) {
                EvermindStreamMessage.pp(out, this.readObject());
            }
        }
        catch (MessageEOFException ex) {
            s_traceLogger.throwing("xmlBody", ex);
        }
        catch (Throwable ex) {
            s_traceLogger.fine("xmlBody", ex);
        }
        out.println(pfx + "</streambody>");
    }

    protected final void writeBodyTo(DataOutput dout) throws IOException {
        dout.writeInt(this.m_data.length);
        dout.write(this.m_data);
    }

    protected final void readBodyFrom(DataInput dinp) throws IOException {
        int size = dinp.readInt();
        if (size < 0) {
            this.m_data = new byte[0];
        } else {
            this.m_data = new byte[size];
            dinp.readFully(this.m_data);
        }
    }

    public synchronized boolean readBoolean() throws JMSException {
        this.prepareForRead();
        boolean ret = false;
        Object v = this.nextObject();
        if (v instanceof Boolean) {
            ret = (Boolean)v;
        } else if (v == null || v instanceof String) {
            ret = Boolean.valueOf((String)v);
        } else {
            JMSUtils.badFormat("readBoolean", v);
        }
        this.doOk();
        return ret;
    }

    public synchronized byte readByte() throws JMSException {
        this.prepareForRead();
        byte ret = 0;
        Object v = this.nextObject();
        if (v instanceof Byte) {
            ret = (Byte)v;
        } else if (v == null || v instanceof String) {
            ret = Byte.valueOf((String)v);
        } else {
            JMSUtils.badFormat("readByte", v);
        }
        this.doOk();
        return ret;
    }

    public synchronized int readBytes(byte[] buf) throws JMSException {
        this.prepareForRead(true);
        int ret = 0;
        if (this.m_tbuf != null) {
            ret = this.m_tbuf.read(buf, 0, buf.length);
            if (ret == -1) {
                JMSUtils.closeIt(this.m_tbuf);
                this.m_tbuf = null;
            }
        } else {
            Object v = this.nextObject();
            if (v == null) {
                ret = -1;
            } else if (!(v instanceof byte[])) {
                JMSUtils.badFormat("readBytes", v);
            }
            byte[] data = (byte[])v;
            if (data.length == 0) {
                ret = 0;
            } else {
                this.m_tbuf = new ByteArrayInputStream(data);
                ret = this.m_tbuf.read(buf, 0, buf.length);
            }
            this.doOk();
        }
        return ret;
    }

    public synchronized char readChar() throws JMSException {
        this.prepareForRead();
        char ret = '\u0000';
        Object v = this.nextObject();
        JMSUtils.checkNull("readChar", "java.lang.Object", v);
        if (v instanceof Character) {
            ret = ((Character)v).charValue();
        } else {
            JMSUtils.badFormat("readChar", v);
        }
        this.doOk();
        return ret;
    }

    public synchronized double readDouble() throws JMSException {
        this.prepareForRead();
        double ret = 0.0;
        Object v = this.nextObject();
        if (v instanceof Float) {
            ret = ((Float)v).floatValue();
        } else if (v instanceof Double) {
            ret = (Double)v;
        } else if (v == null || v instanceof String) {
            ret = Double.valueOf((String)v);
        } else {
            JMSUtils.badFormat("readDouble", v);
        }
        this.doOk();
        return ret;
    }

    public synchronized float readFloat() throws JMSException {
        this.prepareForRead();
        float ret = 0.0f;
        Object v = this.nextObject();
        if (v instanceof Float) {
            ret = ((Float)v).floatValue();
        } else if (v == null || v instanceof String) {
            ret = Float.valueOf((String)v).floatValue();
        } else {
            JMSUtils.badFormat("readFloat", v);
        }
        this.doOk();
        return ret;
    }

    public synchronized int readInt() throws JMSException {
        this.prepareForRead();
        int ret = 0;
        Object v = this.nextObject();
        if (v instanceof Byte) {
            ret = ((Byte)v).byteValue();
        } else if (v instanceof Short) {
            ret = ((Short)v).shortValue();
        } else if (v instanceof Integer) {
            ret = (Integer)v;
        } else if (v == null || v instanceof String) {
            ret = Integer.valueOf((String)v);
        } else {
            JMSUtils.badFormat("readInteger", v);
        }
        this.doOk();
        return ret;
    }

    public synchronized long readLong() throws JMSException {
        this.prepareForRead();
        long ret = 0L;
        Object v = this.nextObject();
        if (v instanceof Byte) {
            ret = ((Byte)v).byteValue();
        } else if (v instanceof Short) {
            ret = ((Short)v).shortValue();
        } else if (v instanceof Integer) {
            ret = ((Integer)v).intValue();
        } else if (v instanceof Long) {
            ret = (Long)v;
        } else if (v == null || v instanceof String) {
            ret = Long.valueOf((String)v);
        } else {
            JMSUtils.badFormat("readLong", v);
        }
        this.doOk();
        return ret;
    }

    public synchronized Object readObject() throws JMSException {
        this.prepareForRead();
        Object v = this.nextObject();
        this.doOk();
        if (!(v == null || v instanceof Boolean || v instanceof Byte || v instanceof Character || v instanceof Double || v instanceof Float || v instanceof Integer || v instanceof Long || v instanceof Short || v instanceof String || v instanceof byte[])) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02000", this, v, JMSUtils.getType(v)));
        }
        return v;
    }

    public synchronized short readShort() throws JMSException {
        this.prepareForRead();
        short ret = 0;
        Object v = this.nextObject();
        if (v instanceof Byte) {
            ret = ((Byte)v).byteValue();
        } else if (v instanceof Short) {
            ret = (Short)v;
        } else if (v == null || v instanceof String) {
            ret = Short.valueOf((String)v);
        } else {
            JMSUtils.badFormat("readShort", v);
        }
        this.doOk();
        return ret;
    }

    public synchronized String readString() throws JMSException {
        this.prepareForRead();
        String ret = null;
        Object v = this.nextObject();
        if (v instanceof Boolean) {
            ret = ((Boolean)v).toString();
        } else if (v instanceof Byte) {
            ret = ((Byte)v).toString();
        } else if (v instanceof Character) {
            ret = ((Character)v).toString();
        } else if (v instanceof Double) {
            ret = ((Double)v).toString();
        } else if (v instanceof Float) {
            ret = ((Float)v).toString();
        } else if (v instanceof Integer) {
            ret = ((Integer)v).toString();
        } else if (v instanceof Long) {
            ret = ((Long)v).toString();
        } else if (v instanceof Short) {
            ret = ((Short)v).toString();
        } else if (v == null || v instanceof String) {
            ret = (String)v;
        } else {
            JMSUtils.badFormat("readString", v);
        }
        this.doOk();
        return ret;
    }

    public synchronized void reset() throws JMSException {
        try {
            this.getData();
            this.resetStreams();
            this.setReadOnly(true);
        }
        catch (Exception ex) {
            JMSUtils.toJMSException("reset", ex);
        }
    }

    public synchronized void writeBoolean(boolean v) throws JMSException {
        this.prepareForWrite();
        this.packWrite(new Boolean(v));
    }

    public synchronized void writeByte(byte v) throws JMSException {
        this.prepareForWrite();
        this.packWrite(new Byte(v));
    }

    public synchronized void writeBytes(byte[] v) throws JMSException {
        this.prepareForWrite();
        this.packWrite(JMSUtils.clone(v));
    }

    public synchronized void writeBytes(byte[] v, int off, int len) throws JMSException {
        this.prepareForWrite();
        this.packWrite(JMSUtils.clone(v, off, len));
    }

    public synchronized void writeChar(char v) throws JMSException {
        this.prepareForWrite();
        this.packWrite(new Character(v));
    }

    public synchronized void writeDouble(double v) throws JMSException {
        this.prepareForWrite();
        this.packWrite(new Double(v));
    }

    public synchronized void writeFloat(float v) throws JMSException {
        this.prepareForWrite();
        this.packWrite(new Float(v));
    }

    public synchronized void writeInt(int v) throws JMSException {
        this.prepareForWrite();
        this.packWrite(new Integer(v));
    }

    public synchronized void writeLong(long v) throws JMSException {
        this.prepareForWrite();
        this.packWrite(new Long(v));
    }

    public synchronized void writeObject(Object v) throws JMSException {
        this.prepareForWrite();
        if (v == null || v instanceof Boolean || v instanceof Byte || v instanceof Character || v instanceof Double || v instanceof Float || v instanceof Integer || v instanceof Long || v instanceof Short || v instanceof String || v instanceof byte[]) {
            this.packWrite(v);
        } else {
            JMSUtils.badFormat("writeObject", v);
        }
    }

    public synchronized void writeShort(short v) throws JMSException {
        this.prepareForWrite();
        this.packWrite(new Short(v));
    }

    public synchronized void writeString(String v) throws JMSException {
        this.prepareForWrite();
        this.packWrite(v);
    }

    public synchronized void clearBody() throws JMSException {
        super.clearBody();
        this.m_data = new byte[0];
        this.resetStreams();
    }

    public int getTypeID() {
        return 5;
    }

    protected synchronized void fixate() throws IOException {
        super.fixate();
        this.getData();
    }

    protected EvermindMessage makeSelf() throws JMSException {
        return new EvermindStreamMessage();
    }

    protected synchronized void cloneBody(EvermindMessage ret) throws JMSException {
        ((EvermindStreamMessage)ret).m_data = this.m_data;
    }

    private void getData() throws IOException {
        if (this.m_dout != null) {
            this.m_dout.flush();
            this.m_bout.flush();
            this.m_data = this.m_bout.toByteArray();
        }
    }

    private void resetStreams() {
        JMSUtils.closeIt(this.m_tbuf);
        this.m_tbuf = null;
        JMSUtils.closeIt(this.m_binp);
        this.m_binp = null;
        JMSUtils.closeIt(this.m_dinp);
        this.m_dinp = null;
        JMSUtils.closeIt(this.m_bout);
        this.m_bout = null;
        JMSUtils.closeIt(this.m_dout);
        this.m_dout = null;
        this.m_curr = null;
        this.m_ok = true;
    }

    private void prepareForRead() throws JMSException {
        this.prepareForRead(false);
    }

    private void prepareForRead(boolean inReadBytes) throws JMSException {
        this.assertReadable();
        if (this.m_tbuf != null && !inReadBytes) {
            throw new MessageFormatException(JMSMessages.getMessage("J2EE JMS-02001", this));
        }
        if (this.m_dinp == null) {
            try {
                this.m_binp = new ByteArrayInputStream(this.m_data);
                this.m_dinp = new DataInputStream(this.m_binp);
                this.m_curr = null;
                this.m_ok = true;
            }
            catch (Exception ex) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01100", this), ex);
            }
        }
    }

    private Object nextObject() throws JMSException {
        try {
            if (this.m_ok) {
                this.m_curr = JMSUtils.packRead(this.m_dinp);
                this.m_ok = false;
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("nextObject", ex);
        }
        return this.m_curr;
    }

    private void doOk() {
        this.m_curr = null;
        this.m_ok = true;
    }

    private void prepareForWrite() throws JMSException {
        this.assertWriteable();
        if (this.m_dout == null) {
            try {
                this.m_bout = new ByteArrayOutputStream();
                this.m_dout = new DataOutputStream(this.m_bout);
            }
            catch (Exception ex) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01102", this), ex);
            }
        }
    }

    private void packWrite(Object v) throws JMSException {
        try {
            JMSUtils.packWrite(v, this.m_dout);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("packWrite", ex);
        }
    }
}

