/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.JMSMessageBundle;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.config.XMLConfigException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.naming.Context;
import oracle.j2ee.util.CustomerLogger;

public class JMSMessages {
    private static final Logger s_logger = CustomerLogger.getLogger("oracle.j2ee.jms", JMSMessageBundle.class.getName());
    private static Level STDERR_THRESHOLD = Level.SEVERE;

    public static String getMessage(String msgId) {
        return JMSMessages.getMessage(msgId, new Object[0]);
    }

    public static String getMessage(String msgId, Object arg1) {
        return JMSMessages.getMessage(msgId, new Object[]{arg1});
    }

    public static String getMessage(String msgId, Object arg1, Object arg2) {
        return JMSMessages.getMessage(msgId, new Object[]{arg1, arg2});
    }

    public static String getMessage(String msgId, Object arg1, Object arg2, Object arg3) {
        return JMSMessages.getMessage(msgId, new Object[]{arg1, arg2, arg3});
    }

    public static String getMessage(String msgId, Object arg1, Object arg2, Object arg3, Object arg4) {
        return JMSMessages.getMessage(msgId, new Object[]{arg1, arg2, arg3, arg4});
    }

    public static String getMessage(String msgId, Object[] args) {
        String pattern = s_logger.getResourceBundle().getString(msgId);
        return MessageFormat.format(pattern, args);
    }

    protected static void log(Level level, String msgId) {
        JMSMessages.log(level, msgId, new Object[0]);
    }

    protected static void log(Level level, String msgId, Object[] args) {
        if (s_logger.isLoggable(level)) {
            String message = JMSMessages.getMessage(msgId, args);
            s_logger.log(level, message);
            JMSMessages.printStdErr(level, message);
        }
    }

    protected static void log(Level level, String msgId, Throwable thrown) {
        JMSMessages.log(level, msgId, new Object[0], thrown);
    }

    protected static void log(Level level, String msgId, Object[] args, Throwable thrown) {
        if (s_logger.isLoggable(level)) {
            String message = JMSMessages.getMessage(msgId, args);
            s_logger.log(level, message, thrown);
            JMSMessages.printStdErr(level, message);
        }
    }

    protected static Exception log(Level level, String msgId, Class exClass) {
        return JMSMessages.log(level, msgId, new Object[0], exClass);
    }

    protected static Exception log(Level level, String msgId, Object[] args, Class exClass) {
        return JMSMessages.log(level, msgId, args, null, exClass);
    }

    protected static Exception log(Level level, String msgId, Throwable thrown, Class exClass) {
        return JMSMessages.log(level, msgId, new Object[0], thrown, exClass);
    }

    protected static Exception log(Level level, String msgId, Object[] args, Throwable thrown, Class exClass) {
        String message = JMSMessages.getMessage(msgId, args);
        if (thrown != null) {
            s_logger.log(level, message, thrown);
        } else {
            s_logger.log(level, message);
        }
        JMSMessages.printStdErr(level, message);
        return (Exception)JMSUtils.make(exClass, message);
    }

    private static void printStdErr(Level level, String message) {
        if (level.intValue() >= STDERR_THRESHOLD.intValue()) {
            System.err.println("*** (" + level.toString() + ")" + " " + message);
        }
    }

    public static void severeAlienSessionType(ConnectionConsumer cons, Object sess) {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-01300", new Object[]{cons, sess.getClass()});
    }

    public static void severeConnectionMismatch(ConnectionConsumer cons, Connection c1, Session sess, Connection c2) {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-01301", new Object[]{cons, c1, sess, c2});
    }

    public static void severeUnableToBind(Context ctx, Map map, Throwable thrown) throws InstantiationException {
        throw (InstantiationException)JMSMessages.log(Level.SEVERE, "J2EE JMS-02520", new Object[]{map, ctx}, thrown, InstantiationException.class);
    }

    public static void severePortInUse(int port) throws InstantiationException {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-02512", new Object[]{new Integer(port)});
    }

    public static void severeListenerError(Session sess, MessageListener listener, Message msg, int count) {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-01914", new Object[]{sess, listener, msg, new Integer(count)});
    }

    public static void severeSessionRunError(Session sess, Throwable thrown) {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-01919", new Object[]{sess}, thrown);
    }

    public static void severeConnectionConsumerRunError(ConnectionConsumer cons, Throwable thrown) {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-01306", new Object[]{cons}, thrown);
    }

    public static void severeCannotCreateConsumer(Destination dest, String selector, Throwable thrown) {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-01305", new Object[]{dest, selector}, thrown);
    }

    public static void severeCannotGetSession(ServerSession svrSess, Throwable thrown) {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-01304", new Object[]{svrSess}, thrown);
    }

    public static void severeCannotLoadMessage(MessageConsumer cons, Session sess, Throwable thrown) {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-01303", new Object[]{cons, sess}, thrown);
    }

    public static void severeCannotSetState(String clientID, String connID, Throwable thrown) {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-02612", new Object[]{clientID, connID}, thrown);
    }

    public static void severeCannotGetState(String key, Throwable thrown) {
        JMSMessages.log(Level.SEVERE, "J2EE JMS-02611", new Object[]{key}, thrown);
    }

    public static void warningBadForeign(String msgType, Message msg, Throwable thrown) {
        JMSMessages.log(Level.WARNING, "J2EE JMS-02601", new Object[]{msgType, msg}, thrown);
    }

    public static void warningKnobUpdateError(String knob, Object newValue, Throwable thrown) {
        JMSMessages.log(Level.WARNING, "J2EE JMS-02631", new Object[]{knob, newValue}, thrown);
    }

    public static XMLConfigException warningDuplicateListener(String listener, String rootTag) {
        return (XMLConfigException)JMSMessages.log(Level.WARNING, "J2EE JMS-03181", new Object[]{listener, rootTag}, XMLConfigException.class);
    }

    public static XMLConfigException warningListenerNotRegistered(String listener, String rootTag) {
        return (XMLConfigException)JMSMessages.log(Level.WARNING, "J2EE JMS-03182", new Object[]{listener, rootTag}, XMLConfigException.class);
    }

    public static void infoUpdatingSchemaVersion() {
        JMSMessages.log(Level.INFO, "J2EE JMS-03206");
    }

    public static void infoDirectEnlistment() {
        JMSMessages.log(Level.INFO, "J2EE JMS-03280");
    }

    public static void infoHttpTunnelErrorCode(String errorCode, Throwable t) {
        JMSMessages.log(Level.INFO, "J2EE JMS-03315", new Object[]{errorCode}, t);
    }
}

