/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConfigPropertyEvent;
import com.evermind.server.jms.ConfigPropertyListener;
import com.evermind.server.jms.EvermindBytesMessage;
import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindMapMessage;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.EvermindObjectMessage;
import com.evermind.server.jms.EvermindQueue;
import com.evermind.server.jms.EvermindStreamMessage;
import com.evermind.server.jms.EvermindTemporaryDestination;
import com.evermind.server.jms.EvermindTemporaryQueue;
import com.evermind.server.jms.EvermindTemporaryTopic;
import com.evermind.server.jms.EvermindTextMessage;
import com.evermind.server.jms.EvermindTopic;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSObject;
import com.evermind.server.jms.JMSServerProxy;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.util.ConfigUtils;
import com.evermind.xml.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAException;
import oracle.j2ee.util.UUID;
import org.w3c.dom.Node;

public final class JMSUtils {
    public static final int DEFAULT_JMS_PORT = 9127;
    static final byte DATA_NULL = 0;
    static final byte DATA_BOOLEAN = 1;
    static final byte DATA_BYTE = 2;
    static final byte DATA_BYTES = 3;
    static final byte DATA_CHAR = 4;
    static final byte DATA_DOUBLE = 5;
    static final byte DATA_FLOAT = 6;
    static final byte DATA_INT = 7;
    static final byte DATA_LONG = 8;
    static final byte DATA_SHORT = 9;
    static final byte DATA_STRING = 10;
    static final byte DATA_DEST = 11;
    static final byte DATA_NEW_STRING = 12;
    static final int UTF_MAX_LENGTH = 16383;
    static long s_messagePoll = (Long)JMSUtils.getProxy().getPropertiesController().listenToConfigProperty("oc4j.jms.messagePoll", new ConfigPropertyListener(){

        public void onConfigPropertyChange(ConfigPropertyEvent event) {
            JMSUtils.setMessagePoll((Long)event.getPropertyValue());
        }
    });
    static final String CLIENT_ID = "Oc4jJMS.clientID";
    static final String CONNECTION_ID = "Oc4jJMS.connectionID";
    static final String DO_CLONE = "Oc4jJMS.doClone";
    private static final ToStringCmp s_cmp = new ToStringCmp();
    private static final boolean DO_GC = (Boolean)JMSUtils.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.doGc");
    private static final String s_pfx = JMSUtils.getHostTimePrefix();
    private static long s_cnt = 0L;
    private static final boolean s_fastID = (Boolean)JMSUtils.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.useUUID") == false;
    public static final String ALL_HOST = "[ALL]";
    public static final String LOOPBACK_HOST = "127.0.0.1";
    public static final String ZERO_HOST = "0.0.0.0";
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(JMSUtils.class);

    private JMSUtils() {
    }

    public static String pp(Message msg) throws JMSException {
        return JMSUtils.toXML(msg);
    }

    public static String toXML(Message msg) throws JMSException {
        EvermindMessage nmsg = msg instanceof EvermindMessage ? ((EvermindMessage)msg).cloneMessage() : (EvermindMessage)JMSUtils.convert(null, msg);
        return nmsg.toXML();
    }

    static String getName(Destination dest) throws JMSException {
        return dest == null ? "" : (dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName());
    }

    static boolean isMy(Destination d) {
        return d == null || d instanceof EvermindDestination || d instanceof EvermindTemporaryDestination;
    }

    static boolean isQ(Destination d) {
        return d instanceof Queue;
    }

    static boolean isT(Destination d) {
        return d instanceof Topic;
    }

    static boolean isTemp(Destination d) {
        return d instanceof TemporaryQueue || d instanceof TemporaryTopic;
    }

    static String pp(Destination d) {
        return (JMSUtils.isTemp(d) ? "Temporary" : "") + (JMSUtils.isQ(d) ? "Queue" : "Topic");
    }

    static String domain(Destination d) {
        return JMSUtils.isQ(d) ? "queue" : "topic";
    }

    static void cuteWrite(Destination d, DataOutput dout) throws IOException {
        if (d == null || !JMSUtils.isMy(d)) {
            dout.writeByte(0);
        } else {
            dout.writeByte(11);
            if (d instanceof EvermindDestination) {
                EvermindDestination dd = (EvermindDestination)d;
                dout.writeUTF(dd.getName());
                dout.writeBoolean(JMSUtils.isQ(d));
                dout.writeBoolean(false);
            } else {
                EvermindTemporaryDestination td = (EvermindTemporaryDestination)d;
                dout.writeUTF(td.getName());
                dout.writeBoolean(JMSUtils.isQ(d));
                dout.writeBoolean(true);
                dout.writeUTF(td.getConnectionID());
                dout.writeByte((byte)td.getDomain());
            }
        }
    }

    static Destination cuteRead(DataInput dinp) throws IOException {
        String name;
        byte code = dinp.readByte();
        if (code == 0) {
            return null;
        }
        if (code != 11) {
            JMSUtils.toIOException(JMSMessages.getMessage("J2EE JMS-02602", "cuteRead", "" + code, ""));
        }
        if ((name = dinp.readUTF()) == null) {
            return null;
        }
        boolean isQ = dinp.readBoolean();
        boolean isTmp = dinp.readBoolean();
        Destination d = null;
        if (!isTmp) {
            d = isQ ? new EvermindQueue(name) : new EvermindTopic(name);
        } else {
            String connID = dinp.readUTF();
            byte domain = dinp.readByte();
            d = isQ ? new EvermindTemporaryQueue(name, connID, (int)domain) : new EvermindTemporaryTopic(name, connID, (int)domain);
        }
        return d;
    }

    static void packWrite(Object val, DataOutput out) throws IOException {
        if (val == null) {
            out.writeByte(0);
        } else if (val instanceof Boolean) {
            out.writeByte(1);
            out.writeBoolean((Boolean)val);
        } else if (val instanceof Byte) {
            out.writeByte(2);
            out.writeByte(((Byte)val).byteValue());
        } else if (val instanceof byte[]) {
            out.writeByte(3);
            out.writeInt(((byte[])val).length);
            out.write((byte[])val);
        } else if (val instanceof Character) {
            out.writeByte(4);
            out.writeChar(((Character)val).charValue());
        } else if (val instanceof Double) {
            out.writeByte(5);
            out.writeDouble((Double)val);
        } else if (val instanceof Float) {
            out.writeByte(6);
            out.writeFloat(((Float)val).floatValue());
        } else if (val instanceof Integer) {
            out.writeByte(7);
            out.writeInt((Integer)val);
        } else if (val instanceof Long) {
            out.writeByte(8);
            out.writeLong((Long)val);
        } else if (val instanceof Short) {
            out.writeByte(9);
            out.writeShort(((Short)val).shortValue());
        } else if (val instanceof String) {
            String sVal = (String)val;
            int sLength = sVal.length();
            if (sLength > 16383) {
                int div = sLength / 16383;
                int rem = sLength % 16383;
                int pointer = 0;
                out.writeByte(12);
                out.writeInt(sLength);
                for (int i = 0; i < div; ++i) {
                    out.writeUTF(sVal.substring(pointer, pointer + 16383));
                    pointer += 16383;
                }
                if (rem > 0) {
                    out.writeUTF(sVal.substring(pointer, pointer + rem));
                }
            } else {
                out.writeByte(10);
                out.writeUTF(sVal);
            }
        } else {
            JMSUtils.toIOException(JMSMessages.getMessage("J2EE JMS-02602", "packWrite", val, JMSUtils.getType(val)));
        }
    }

    static Object packRead(DataInput inp) throws IOException {
        Object ret = null;
        byte code = inp.readByte();
        switch (code) {
            case 0: {
                break;
            }
            case 1: {
                ret = new Boolean(inp.readBoolean());
                break;
            }
            case 2: {
                ret = new Byte(inp.readByte());
                break;
            }
            case 3: {
                int size = inp.readInt();
                byte[] buf = new byte[size];
                inp.readFully(buf);
                ret = buf;
                break;
            }
            case 4: {
                ret = new Character(inp.readChar());
                break;
            }
            case 5: {
                ret = new Double(inp.readDouble());
                break;
            }
            case 6: {
                ret = new Float(inp.readFloat());
                break;
            }
            case 7: {
                ret = new Integer(inp.readInt());
                break;
            }
            case 8: {
                ret = new Long(inp.readLong());
                break;
            }
            case 9: {
                ret = new Short(inp.readShort());
                break;
            }
            case 10: {
                ret = inp.readUTF();
                break;
            }
            case 12: {
                int sLength = inp.readInt();
                StringBuffer sVal = new StringBuffer(sLength);
                while (sVal.length() < sLength) {
                    sVal.append(inp.readUTF());
                }
                ret = sVal.toString();
                break;
            }
            default: {
                JMSUtils.toIOException(JMSMessages.getMessage("J2EE JMS-02602", "packRead", "" + code, ""));
            }
        }
        return ret;
    }

    static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            s_traceLogger.fine("sleep", ex);
        }
    }

    static void wait(Object o, long ms) {
        try {
            o.wait(ms);
        }
        catch (InterruptedException ex) {
            s_traceLogger.fine("wait", ex);
        }
    }

    private static void setMessagePoll(long pollInterval) {
        s_messagePoll = pollInterval;
    }

    static long getMessagePoll() {
        return s_messagePoll;
    }

    static long delaySome(long delay, boolean ok) {
        if (ok) {
            Thread.yield();
            delay = 1L;
        } else {
            JMSUtils.sleep(delay);
            delay = Math.min(delay * 2L, JMSUtils.getMessagePoll());
        }
        return delay;
    }

    static String getType(Object obj) {
        return obj == null ? null : obj.getClass().toString();
    }

    public static String fold(String v) {
        return v == null ? "" : v;
    }

    public static String unfold(String v) {
        return JMSUtils.isNull(v) || JMSUtils.isNull(v.trim()) ? null : v;
    }

    public static boolean isNull(String v) {
        return v == null || v.equals("");
    }

    public static boolean isNull(Object v) {
        return v instanceof String ? JMSUtils.isNull((String)v) : v == null;
    }

    static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2) || o2 != null && o2.equals(o1);
    }

    public static void noNull(Object func, String name, String v) throws InstantiationException {
        if (JMSUtils.isNull(v)) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-02600", func, name));
        }
    }

    public static void checkNull(Object func, String name, Object v) {
        if (v == null) {
            throw new NullPointerException(JMSMessages.getMessage("J2EE JMS-02600", func, name));
        }
    }

    public static void checkTunnelAttributes(Object func, String cfName, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider) throws InstantiationException {
        String msg = null;
        if (tunnel.startsWith("https://") && (JMSUtils.isNull(keystore) || JMSUtils.isNull(keystorePassword) || JMSUtils.isNull(truststore) && !JMSUtils.isNull(truststorePassword) || !JMSUtils.isNull(truststore) && JMSUtils.isNull(truststorePassword))) {
            msg = "J2EE JMS-03314";
        }
        if (!(!tunnel.startsWith("http://") || JMSUtils.isNull(keystore) && JMSUtils.isNull(keystorePassword) && JMSUtils.isNull(truststore) && JMSUtils.isNull(truststorePassword) && JMSUtils.isNull(provider))) {
            msg = "J2EE JMS-03313";
        }
        if (!tunnel.startsWith("https://") && !tunnel.startsWith("http://") || !tunnel.endsWith("/jms")) {
            msg = "J2EE JMS-03312";
        }
        if (!JMSUtils.isNull(msg)) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage(msg, func, cfName));
        }
    }

    static Serializable read(DataInputStream dataInp) throws IOException {
        Serializable ret = null;
        int len = dataInp.readInt();
        if (len > 0) {
            byte[] data = new byte[len];
            dataInp.readFully(data);
            ret = JMSUtils.toSerializable(data);
        }
        return ret;
    }

    static void write(Serializable val, DataOutputStream dataOut) throws IOException {
        if (val == null) {
            dataOut.writeInt(0);
        } else {
            byte[] data = JMSUtils.toBytes(val);
            dataOut.writeInt(data.length);
            dataOut.write(data);
        }
    }

    static Message convert(Session s, Message msg) throws JMSException {
        String body;
        if (msg == null || msg instanceof EvermindMessage) {
            return msg;
        }
        EvermindMessage ret = null;
        ret = msg instanceof BytesMessage ? (s == null ? new EvermindBytesMessage() : s.createBytesMessage()) : (msg instanceof MapMessage ? (s == null ? new EvermindMapMessage() : s.createMapMessage()) : (msg instanceof ObjectMessage ? (s == null ? new EvermindObjectMessage() : s.createObjectMessage()) : (msg instanceof StreamMessage ? (s == null ? new EvermindStreamMessage() : s.createStreamMessage()) : (msg instanceof TextMessage ? (s == null ? new EvermindTextMessage() : s.createTextMessage()) : (s == null ? new EvermindMessage() : s.createMessage())))));
        JMSUtils.convertHeaders(ret, msg, true);
        if (msg instanceof BytesMessage) {
            JMSUtils.convertBody(ret, (BytesMessage)msg);
        } else if (msg instanceof MapMessage) {
            Enumeration e = ((MapMessage)msg).getMapNames();
            while (e != null && e.hasMoreElements()) {
                String k = (String)e.nextElement();
                ((MapMessage)ret).setObject(k, ((MapMessage)msg).getObject(k));
            }
        } else if (msg instanceof ObjectMessage) {
            Serializable body2 = ((ObjectMessage)msg).getObject();
            if (body2 != null) {
                ((ObjectMessage)ret).setObject(body2);
            }
        } else if (msg instanceof StreamMessage) {
            JMSUtils.convertBody((StreamMessage)ret, (StreamMessage)msg);
        } else if (msg instanceof TextMessage && (body = ((TextMessage)msg).getText()) != null) {
            ((TextMessage)ret).setText(body);
        }
        return ret;
    }

    private static void convertBody(BytesMessage ret, BytesMessage msg) throws JMSException {
        int len = 0;
        byte[] buf = new byte[4096];
        boolean inRead = true;
        int fromEof = 0;
        try {
            while ((len = msg.readBytes(buf)) > 0) {
                fromEof += len;
            }
        }
        catch (MessageNotReadableException ex) {
            inRead = false;
            fromEof = 0;
        }
        catch (Throwable ex) {
            JMSMessages.warningBadForeign("Stream", (Message)msg, ex);
            inRead = false;
            fromEof = 0;
        }
        ret.clearBody();
        msg.reset();
        int totLen = 0;
        while ((len = msg.readBytes(buf)) > 0) {
            ret.writeBytes(buf, 0, len);
            totLen += len;
        }
        if (inRead) {
            msg.reset();
            for (int toSkip = totLen - fromEof; toSkip > 0 && (len = msg.readBytes(buf, toSkip < buf.length ? toSkip : buf.length)) > 0; toSkip -= len) {
            }
        } else {
            ret.reset();
            msg.clearBody();
            while ((len = ret.readBytes(buf)) > 0) {
                msg.writeBytes(buf, 0, len);
            }
        }
        ret.reset();
    }

    private static void convertBody(StreamMessage ret, StreamMessage msg) throws JMSException {
        boolean inRead = true;
        int fromEof = 0;
        try {
            while (true) {
                Object item = msg.readObject();
                ++fromEof;
            }
        }
        catch (MessageNotReadableException ex) {
            inRead = false;
            fromEof = 0;
        }
        catch (MessageEOFException ex) {
            s_traceLogger.throwing("convertBody", ex);
        }
        catch (Throwable ex) {
            JMSMessages.warningBadForeign("Stream", (Message)msg, ex);
            inRead = false;
            fromEof = 0;
        }
        ret.clearBody();
        msg.reset();
        int totLen = 0;
        try {
            while (true) {
                ret.writeObject(msg.readObject());
                ++totLen;
            }
        }
        catch (MessageEOFException ex) {
            s_traceLogger.throwing("convertBody", ex);
            if (inRead) {
                msg.reset();
                for (int toSkip = totLen - fromEof; toSkip > 0; --toSkip) {
                    msg.readObject();
                }
            } else {
                ret.reset();
                msg.clearBody();
                try {
                    while (true) {
                        msg.writeObject(ret.readObject());
                    }
                }
                catch (MessageEOFException ex2) {
                    s_traceLogger.throwing("convertBody", ex2);
                }
            }
            ret.reset();
            return;
        }
    }

    static void convertHeaders(Message ret, Message msg, boolean convertProps) throws JMSException {
        ret.setJMSCorrelationID(msg.getJMSCorrelationID());
        ret.setJMSDeliveryMode(msg.getJMSDeliveryMode());
        ret.setJMSExpiration(msg.getJMSExpiration());
        ret.setJMSMessageID(msg.getJMSMessageID());
        ret.setJMSPriority(msg.getJMSPriority());
        ret.setJMSRedelivered(msg.getJMSRedelivered());
        ret.setJMSTimestamp(msg.getJMSTimestamp());
        ret.setJMSType(msg.getJMSType());
        try {
            ret.setJMSDestination(msg.getJMSDestination());
        }
        catch (Throwable ex) {
            s_traceLogger.fine("JMSDestination", ex);
        }
        try {
            ret.setJMSReplyTo(msg.getJMSReplyTo());
        }
        catch (Throwable ex) {
            s_traceLogger.fine("JMSReplyTo", ex);
        }
        if (convertProps) {
            JMSUtils.convertProperties(ret, msg);
        }
    }

    private static void convertProperties(Message ret, Message msg) throws JMSException {
        Enumeration pe = msg.getPropertyNames();
        while (pe != null && pe.hasMoreElements()) {
            String k = (String)pe.nextElement();
            if (EvermindMessage.isJMSHeader(k)) continue;
            ret.setObjectProperty(k, msg.getObjectProperty(k));
        }
    }

    public static String toString(JMSException ex) {
        return JMSUtils.pp(ex, true);
    }

    static String pp(Throwable ex) {
        return JMSUtils.pp(ex, false);
    }

    static String pp(Throwable ex, boolean doLinked) {
        String ret = "";
        try {
            JMSException jex;
            Exception lex;
            StringWriter swr = new StringWriter();
            PrintWriter pwr = new PrintWriter((Writer)swr, true);
            ex.printStackTrace(pwr);
            if (doLinked && ex instanceof JMSException && (lex = (jex = (JMSException)ex).getLinkedException()) != null) {
                lex.printStackTrace(pwr);
            }
            ret = swr.toString();
            JMSUtils.closeIt(pwr);
            JMSUtils.closeIt(swr);
        }
        catch (Throwable nex) {
            ret = ex.toString();
        }
        return ret;
    }

    static Throwable make(Class c, String msg) {
        Exception ret = null;
        try {
            Constructor ctor = c.getConstructor(String.class);
            ret = (Exception)ctor.newInstance(msg);
        }
        catch (Throwable nex) {
            s_traceLogger.fine("make({0}, {1})", new Object[]{c, msg}, nex);
        }
        return ret;
    }

    static void initCause(Throwable ex, Throwable lex) {
        try {
            Method m = Throwable.class.getMethod("initCause", Throwable.class);
            m.invoke((Object)ex, lex);
        }
        catch (Throwable nex) {
            s_traceLogger.throwing("initCause", ex);
        }
    }

    private static Throwable make(Class c, String msg, Throwable ex) {
        Throwable nex = JMSUtils.make(c, msg);
        nex.fillInStackTrace();
        if (nex instanceof JMSException && ex instanceof Exception) {
            ((JMSException)nex).setLinkedException((Exception)ex);
        }
        if (nex != null && ex != null) {
            JMSUtils.initCause(nex, ex);
        }
        return nex;
    }

    private static Throwable chain(Throwable ex, List exList) {
        if (exList == null || exList.size() == 0) {
            return ex;
        }
        Throwable pex = ex;
        Iterator iter = exList.iterator();
        while (iter.hasNext()) {
            Throwable nex = (Throwable)iter.next();
            JMSUtils.initCause(pex, nex);
            pex = nex;
        }
        return ex;
    }

    static JMSException makeJMSException(String msg, Throwable ex) {
        return ex instanceof JMSException ? (JMSException)ex : (JMSException)JMSUtils.make(JMSException.class, msg, ex);
    }

    static JMSException makeJMSException(String msg, List exList) {
        return (JMSException)JMSUtils.chain(JMSUtils.make(JMSException.class, msg, null), exList);
    }

    static void toJMSException(String msg) throws JMSException {
        JMSUtils.toJMSException(msg, (Throwable)null);
    }

    static void toJMSSecurityException(String msg) throws JMSSecurityException {
        throw (JMSSecurityException)JMSUtils.make(JMSSecurityException.class, msg, null);
    }

    static void toInvalidDestinationException(String msg) throws InvalidDestinationException {
        throw (InvalidDestinationException)JMSUtils.make(InvalidDestinationException.class, msg, null);
    }

    static void toIllegalStateException(String msg) throws javax.jms.IllegalStateException {
        throw (javax.jms.IllegalStateException)JMSUtils.make(javax.jms.IllegalStateException.class, msg, null);
    }

    static void toTransactionInProgressException(String msg) throws TransactionInProgressException {
        throw (TransactionInProgressException)JMSUtils.make(TransactionInProgressException.class, msg, null);
    }

    static void toJMSException(String msg, Throwable ex) throws JMSException {
        Throwable throwable;
        if (ex instanceof JMSException) {
            throwable = ex;
        } else {
            Class clazz = ex instanceof EOFException ? MessageEOFException.class : JMSException.class;
            throwable = JMSUtils.make(clazz, msg, ex);
        }
        throw (JMSException)throwable;
    }

    static void toJMSException(String msg, List exList) throws JMSException {
        throw (JMSException)JMSUtils.chain(JMSUtils.make(JMSException.class, msg, null), exList);
    }

    static RuntimeException makeRuntimeException(String msg, List exList) {
        return (RuntimeException)JMSUtils.chain(JMSUtils.make(RuntimeException.class, msg, null), exList);
    }

    static void toRuntimeException(String msg) {
        JMSUtils.toRuntimeException(msg, (Throwable)null);
    }

    static void toRuntimeException(String msg, Throwable ex) {
        throw (RuntimeException)JMSUtils.make(RuntimeException.class, msg, ex);
    }

    static void toRuntimeException(String msg, List exList) {
        throw (RuntimeException)JMSUtils.chain(JMSUtils.make(RuntimeException.class, msg, null), exList);
    }

    static void toIOException(String msg) throws IOException {
        JMSUtils.toIOException(msg, (Throwable)null);
    }

    static void toIOException(String msg, Throwable ex) throws IOException {
        throw (IOException)JMSUtils.make(IOException.class, msg, ex);
    }

    static void toIOException(String msg, List exList) throws IOException {
        throw (IOException)JMSUtils.chain(JMSUtils.make(IOException.class, msg, null), exList);
    }

    static InstantiationException makeInstantiationException(String msg) {
        return (InstantiationException)JMSUtils.make(InstantiationException.class, msg, null);
    }

    static void toInstantiationException(String msg) throws InstantiationException {
        JMSUtils.toInstantiationException(msg, (Throwable)null);
    }

    static void toInstantiationException(String msg, Throwable ex) throws InstantiationException {
        throw (InstantiationException)JMSUtils.make(InstantiationException.class, msg, ex);
    }

    static void toInstantiationException(List exList) throws InstantiationException {
        String msg = "";
        if (exList != null && !exList.isEmpty()) {
            msg = ((Throwable)exList.get(0)).getMessage();
        }
        JMSUtils.toInstantiationException(msg, exList);
    }

    static void toInstantiationException(String msg, List exList) throws InstantiationException {
        throw (InstantiationException)JMSUtils.chain(JMSUtils.make(InstantiationException.class, msg, null), exList);
    }

    static void toXAException(String msg, int code) throws XAException {
        JMSUtils.toXAException(msg, code, null);
    }

    static void toXAException(String msg, int code, Throwable ex) throws XAException {
        XAException nex = (XAException)JMSUtils.make(XAException.class, msg, ex);
        nex.errorCode = code;
        throw nex;
    }

    public static void toRemoteException(String msg, Throwable ex) throws RemoteException {
        throw (RemoteException)JMSUtils.make(RemoteException.class, msg, ex);
    }

    static boolean check(boolean doCheck, String which, Object obj) {
        if (obj == null || obj instanceof Serializable) {
            return true;
        }
        if (!doCheck) {
            return false;
        }
        JMSUtils.toRuntimeException(JMSMessages.getMessage("J2EE JMS-02606", which, obj));
        return false;
    }

    public static byte[] toBytes(byte magic, Serializable data) throws IOException {
        byte[] buf = JMSUtils.toBytes(data);
        byte[] ret = new byte[1 + buf.length];
        ret[0] = magic;
        System.arraycopy(buf, 0, ret, 1, buf.length);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Serializable data) throws IOException {
        byte[] ret = null;
        ByteArrayOutputStream bout = null;
        ObjectOutputStream oout = null;
        try {
            bout = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(bout);
            oout.writeObject(data);
            oout.flush();
            ret = bout.toByteArray();
            if (ret != null && data != null && data instanceof EvermindMessage) {
                ((EvermindMessage)data).setSize(ret.length);
            }
        }
        catch (Throwable throwable) {
            JMSUtils.closeIt(oout);
            JMSUtils.closeIt(bout);
            throw throwable;
        }
        JMSUtils.closeIt(oout);
        JMSUtils.closeIt(bout);
        return ret;
    }

    /*
     * Exception decompiling
     */
    public static Serializable toSerializable(byte[] data, int off, int len) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Serializable toSerializable(byte[] data) throws IOException {
        return JMSUtils.toSerializable(data, 0, data.length);
    }

    public static Serializable clone(Serializable obj) throws IOException {
        return JMSUtils.toSerializable(JMSUtils.toBytes(obj));
    }

    static String getClientID() {
        return JMSUtils.fold((String)JMSUtils.getProxy().getState(CLIENT_ID));
    }

    static String getConnectionID() {
        return JMSUtils.fold((String)JMSUtils.getProxy().getState(CONNECTION_ID));
    }

    static boolean doClone() {
        Boolean b = (Boolean)JMSUtils.getProxy().getState(DO_CLONE);
        return b == null ? true : b;
    }

    static EvermindMessage checkClone(EvermindMessage msg) throws JMSException {
        return msg == null ? null : (JMSUtils.doClone() ? msg.cloneMessage() : msg);
    }

    static void closeIt(Object obj) {
        if (obj != null) {
            try {
                if (obj instanceof InputStream) {
                    ((InputStream)obj).close();
                } else if (obj instanceof OutputStream) {
                    ((OutputStream)obj).close();
                } else if (obj instanceof Writer) {
                    ((Writer)obj).close();
                } else if (obj instanceof Connection) {
                    ((Connection)obj).close();
                } else if (obj instanceof Session) {
                    ((Session)obj).close();
                } else if (obj instanceof MessageProducer) {
                    ((MessageProducer)obj).close();
                } else if (obj instanceof MessageConsumer) {
                    ((MessageConsumer)obj).close();
                } else if (obj instanceof QueueBrowser) {
                    ((QueueBrowser)obj).close();
                }
            }
            catch (Throwable ex) {
                s_traceLogger.fine("closeIt({0}", new Object[]{obj}, ex);
            }
        }
    }

    static byte[] clone(byte[] buf, int off, int len) throws JMSException {
        byte[] ret = null;
        try {
            ret = new byte[len];
            System.arraycopy(buf, off, ret, 0, len);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("clone(" + buf + "," + off + "," + len + ")", ex);
        }
        return ret;
    }

    static byte[] clone(byte[] data) throws JMSException {
        byte[] ret = null;
        try {
            if (data != null) {
                ret = new byte[data.length];
                System.arraycopy(data, 0, ret, 0, data.length);
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("clone(" + data + ")", ex);
        }
        return ret;
    }

    static void badFormat(String func, Object v) throws MessageFormatException {
        throw new MessageFormatException(JMSMessages.getMessage("J2EE JMS-02602", func, v, JMSUtils.getType(v)));
    }

    static void assertDomain(Object o, int want, int have) throws javax.jms.IllegalStateException {
        if (have == 2 || want == have) {
            return;
        }
        JMSUtils.toIllegalStateException(JMSMessages.getMessage("J2EE JMS-02604", o, JMSUtils.pp(want), JMSUtils.pp(have)));
    }

    static String pp(int domain) {
        return domain == 0 ? "queue" : (domain == 1 ? "topic" : "unified");
    }

    static String pp(boolean isXA, int domain) {
        return (isXA ? "XA" : "") + (domain == 0 ? "Queue" : (domain == 1 ? "Topic" : ""));
    }

    static boolean isValid(String domain) {
        return JMSUtils.isValid(domain, true);
    }

    static boolean isValid(String domain, boolean unified) {
        return "queue".equalsIgnoreCase(domain) || "topic".equalsIgnoreCase(domain) || unified && "unified".equalsIgnoreCase(domain);
    }

    static int toDomain(String domain) {
        return "queue".equalsIgnoreCase(domain) ? 0 : ("topic".equalsIgnoreCase(domain) ? 1 : ("unified".equalsIgnoreCase(domain) ? 2 : -1));
    }

    static String ppAckMode(boolean isXact, int ackMode) {
        return isXact ? "SESSION_TRANSACTED" : (ackMode == 1 ? "AUTO_ACKNOWLEDGE" : (ackMode == 3 ? "DUPS_OK_ACKNOWLEDGE" : (ackMode == 2 ? "CLIENT_ACKNOWLEDGE" : "<acknowledgeMode=" + ackMode + ">")));
    }

    static String ppDelMode(int delMode) {
        return delMode == 2 ? "PERSISTENT" : "NON_PERSISTENT";
    }

    static JMSObject get(Iterator iter) {
        return (JMSObject)((WeakReference)iter.next()).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sync(Set s) {
        if (s == null) {
            return;
        }
        Set set = s;
        synchronized (set) {
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                JMSObject c = JMSUtils.get(iter);
                if (c != null && !c.isClosed()) continue;
                iter.remove();
            }
        }
    }

    public static String get(Node n, String attr, String def) {
        String ret = def;
        try {
            ret = XMLUtils.getNodeAttribute(n, attr);
            if (JMSUtils.isNull(ret)) {
                ret = def;
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("get", ex);
        }
        return ret;
    }

    public static void encode(PrintWriter out, String indent, String attr, String v) {
        if (v != null) {
            out.println(indent + "    " + attr + "=\"" + XMLUtils.encode(v) + "\"");
        }
    }

    static Iterator sortXMLs(Iterator iter) {
        ArrayList l = new ArrayList();
        while (iter.hasNext()) {
            l.add(iter.next());
        }
        Collections.sort(l, s_cmp);
        return l.iterator();
    }

    private static JMSServerProxy getProxy() {
        return JMSServerProxy.getProxy();
    }

    static void gc() {
        JMSUtils.gc(false);
    }

    static void gc(boolean runF) {
        if (DO_GC) {
            System.gc();
            if (runF) {
                System.runFinalization();
            }
        }
    }

    private static String getHostTimePrefix() {
        String host = "localhost";
        String uid = new UID().toString();
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable ex) {
            s_traceLogger.fine("getHostTimePrefix", ex);
        }
        return host + "." + uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fastID() {
        String ret = null;
        String string = s_pfx;
        synchronized (string) {
            ret = s_pfx + "." + ++s_cnt;
        }
        return ret;
    }

    static String newID() {
        return s_fastID ? JMSUtils.fastID() : new UUID().toString();
    }

    static String newID(String pfx) {
        return "Oc4jJMS." + pfx + "." + JMSUtils.newID();
    }

    static String getAbsolutePath(String rFile, URL url) throws InstantiationException {
        if (JMSUtils.isNull(rFile) || url == null) {
            return rFile;
        }
        File file = new File(rFile);
        if (file.isAbsolute()) {
            return rFile;
        }
        String absfile = rFile;
        try {
            absfile = ConfigUtils.getURL(url, rFile).getFile();
        }
        catch (IOException ex) {
            JMSUtils.toInstantiationException("getURL(" + url + "," + rFile + ")", ex);
        }
        return absfile;
    }

    static String getPrimitiveWrapper(String primitive) {
        String object = primitive;
        if (primitive.equals("boolean")) {
            object = "java.lang.Boolean";
        } else if (primitive.equals("byte")) {
            object = "java.lang.Byte";
        } else if (primitive.equals("char")) {
            object = "java.lang.Character";
        } else if (primitive.equals("double")) {
            object = "java.lang.Double";
        } else if (primitive.equals("float")) {
            object = "java.lang.Float";
        } else if (primitive.equals("int")) {
            object = "java.lang.Integer";
        } else if (primitive.equals("long")) {
            object = "java.lang.Long";
        } else if (primitive.equals("short")) {
            object = "java.lang.Short";
        }
        return object;
    }

    static Object makeWrappedPrimitive(String type, String str) {
        Comparable<Boolean> wrappedValue = null;
        boolean cantCast = false;
        try {
            if (type.equals("boolean") && str.equals("true")) {
                wrappedValue = new Boolean(true);
            } else if (type.equals("boolean") && str.equals("false")) {
                wrappedValue = new Boolean(false);
            } else if (type.equals("byte")) {
                wrappedValue = new Byte(str);
            } else if (type.equals("char") && str.length() == 1) {
                wrappedValue = new Character(str.charAt(0));
            } else if (type.equals("double")) {
                wrappedValue = new Double(str);
            } else if (type.equals("float")) {
                wrappedValue = new Float(str);
            } else if (type.equals("int")) {
                wrappedValue = new Integer(str);
            } else if (type.equals("long")) {
                wrappedValue = new Long(str);
            } else if (type.equals("short")) {
                wrappedValue = new Short(str);
            } else {
                cantCast = true;
            }
        }
        catch (Throwable ex) {
            cantCast = true;
        }
        if (cantCast) {
            throw new ClassCastException(JMSMessages.getMessage("J2EE JMS-02608", str, type));
        }
        return wrappedValue;
    }

    static boolean isAssignableFrom(String type, Object obj) {
        boolean ret = false;
        try {
            ret = Class.forName(JMSUtils.getPrimitiveWrapper(type)).isAssignableFrom(obj.getClass());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    static InetAddress toAddress(String host) throws InstantiationException {
        InetAddress addr = null;
        try {
            if (JMSUtils.isNull(host) || host.equals(ALL_HOST)) {
                host = ZERO_HOST;
            }
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            JMSUtils.toInstantiationException("toAddress(" + host + ")", ex);
        }
        return addr;
    }

    public static InetAddress normalize(InetAddress addr) {
        try {
            if (addr == null || addr.getHostAddress().equalsIgnoreCase(LOOPBACK_HOST) || addr.getHostAddress().equalsIgnoreCase(ZERO_HOST)) {
                addr = InetAddress.getLocalHost();
            }
        }
        catch (UnknownHostException ex) {
            s_traceLogger.fine("normalize({0})", new Object[]{addr}, ex);
        }
        return addr;
    }

    static String toHost(InetAddress addr) {
        return addr == null || addr.getHostAddress().equals(ZERO_HOST) ? ALL_HOST : addr.getHostName();
    }

    static String normalize(String host) {
        String ret = ALL_HOST;
        try {
            ret = JMSUtils.toHost(JMSUtils.toAddress(host));
        }
        catch (Throwable ex) {
            s_traceLogger.fine("normalize({0})", new Object[]{host}, ex);
        }
        return ret;
    }

    static void notSupported(Object t, Object map, String func, Object arg) {
        throw new UnsupportedOperationException(JMSMessages.getMessage("J2EE JMS-02607", t, map, func, arg));
    }

    static Map makeMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    static String path(String n, String s) {
        return n + "/" + s;
    }

    public static final class CollectionIterator
    implements Iterator {
        private final Collection m_col;
        private final Iterator m_iter;
        private Object m_next = null;
        private boolean m_isOk = false;

        CollectionIterator(Collection col, Iterator iter) {
            this.m_col = col;
            this.m_iter = iter;
        }

        public String toString() {
            return "CollectionIterator[" + this.m_col + "]";
        }

        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        public Object next() {
            this.m_next = this.m_iter.next();
            this.m_isOk = true;
            return this.m_next;
        }

        public void remove() {
            if (!this.m_isOk) {
                throw new IllegalStateException("remove");
            }
            this.m_iter.remove();
            this.m_col.remove(this.m_next);
            this.m_isOk = false;
        }
    }

    private static final class ToStringCmp
    implements Comparator {
        ToStringCmp() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

