/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.filter.EventRules;
import com.evermind.server.jms.filter.Filter;
import com.evermind.server.jms.filter.MercuryMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.InvalidSelectorException;

public final class MessageSelector
implements Serializable {
    private String m_selector = null;
    private transient EventRules m_expr = null;
    private transient Filter m_filter = null;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(MessageSelector.class);
    static final long serialVersionUID = 7556956619533397335L;

    private MessageSelector(String selector) throws InvalidSelectorException {
        this.m_selector = MessageSelector.munge(selector);
        this.parse();
    }

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        inp.defaultReadObject();
        try {
            this.m_selector = MessageSelector.munge(this.m_selector);
            this.parse();
        }
        catch (Throwable ex) {
            JMSUtils.toIOException(JMSMessages.getMessage("J2EE JMS-02700", this.m_selector, ex), ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return this.m_selector == null;
        }
        MessageSelector that = null;
        if (obj instanceof String) {
            try {
                that = new MessageSelector((String)obj);
            }
            catch (Throwable ex) {
                return false;
            }
        } else if (obj instanceof MessageSelector) {
            that = (MessageSelector)obj;
        } else {
            return false;
        }
        if (this.m_selector == that.m_selector || this.m_selector != null && this.m_selector.equals(that.m_selector)) {
            return true;
        }
        try {
            return this.m_filter.equals(that.m_filter);
        }
        catch (Throwable ex) {
            s_traceLogger.fine("equals", ex);
            return false;
        }
    }

    public String toString() {
        return this.getSelectorString();
    }

    synchronized String getSelectorString() {
        return JMSUtils.fold(this.m_selector);
    }

    public synchronized String getCanonicalString() {
        return JMSUtils.fold(this.m_filter == null ? "( TRUE )" : this.m_filter.toString());
    }

    public synchronized boolean selects(EvermindMessage msg) {
        return this.isSelected(msg);
    }

    public synchronized boolean isSelected(EvermindMessage msg) {
        if (this.m_selector == null) {
            return true;
        }
        Vector results = new Vector();
        try {
            this.m_expr.evalEvent(msg, results);
        }
        catch (Throwable ex) {
            return false;
        }
        return !results.isEmpty();
    }

    public boolean isIdempotent() {
        return this.m_expr == null ? true : this.m_expr.isIdempotent();
    }

    public static synchronized MessageSelector getSelector(String selector) throws InvalidSelectorException {
        return new MessageSelector(MessageSelector.munge(selector));
    }

    private static String munge(String selector) {
        return selector == null ? null : (selector.trim().equals("") ? null : selector.trim());
    }

    private void parse() throws InvalidSelectorException {
        if (this.m_selector == null) {
            return;
        }
        this.m_expr = null;
        try {
            MercuryMessage fmt = new MercuryMessage("jms");
            this.m_expr = new EventRules("rule", fmt);
            this.m_filter = this.m_expr.addQuery(this.m_selector, fmt);
        }
        catch (Exception ex) {
            InvalidSelectorException nex = new InvalidSelectorException("\"" + this.m_selector + "\": " + ex);
            nex.setLinkedException(ex);
            throw nex;
        }
    }
}

