/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConsumerInfo;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSServerMessages;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.MessageSelector;
import com.evermind.server.jms.ServerDestination;
import com.evermind.server.jms.ServerFile;
import com.evermind.server.jms.ServerStore;
import com.evermind.server.jms.TxMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Topic;

public final class ServerTopic
extends ServerDestination {
    private final Map m_ndStore = new HashMap();
    private final Map m_dStore = new HashMap();
    private final Map m_objs = new HashMap();

    ServerTopic(TxMap txMap, Topic topic) throws Exception {
        super(txMap, (Destination)topic);
        this.loadMessages();
        Iterator iter = this.m_dStore.values().iterator();
        while (iter.hasNext()) {
            ServerStore store = (ServerStore)iter.next();
            store.updateStats();
        }
    }

    protected final void closeDestination() throws Exception {
        ArrayList exList = new ArrayList();
        this.close(this.m_ndStore.entrySet().iterator(), exList);
        this.close(this.m_dStore.entrySet().iterator(), exList);
        this.m_ndStore.clear();
        this.m_dStore.clear();
        this.m_objs.clear();
        if (exList.size() > 0) {
            JMSUtils.toJMSException("close", exList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enq(String connID, Object sessionID, boolean keepState, EvermindMessage msg) throws JMSException {
        long tok = this.startPhase("enq");
        try {
            this.enq(this.m_ndStore.entrySet().iterator(), connID, sessionID, keepState, msg);
            this.enq(this.m_dStore.entrySet().iterator(), connID, sessionID, keepState, msg);
        }
        finally {
            this.stopPhase("enq", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EvermindMessage deq(ConsumerInfo cons, Object sessionID, String txid, boolean keepState) throws JMSException {
        long tok = this.startPhase("deq");
        try {
            EvermindMessage evermindMessage = ((ServerStore)this.findConsumer(cons).get(cons)).deq(cons, sessionID, txid, keepState);
            return evermindMessage;
        }
        finally {
            this.stopPhase("deq", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void expireMessages() {
        long tok = this.startPhase("expireMessages");
        try {
            this.expireMessages(this.m_ndStore.entrySet().iterator());
            this.expireMessages(this.m_dStore.entrySet().iterator());
        }
        finally {
            this.stopPhase("expireMessages", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List listMessages(String name, Object sessionID, MessageSelector selector) throws JMSException {
        long tok = this.startPhase("listMessages");
        try {
            List list = this.findDurable(name).listMessages(sessionID, selector);
            return list;
        }
        finally {
            this.stopPhase("listMessages", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EvermindMessage peekMessage(String name, String msgID) throws JMSException {
        long tok = this.startPhase("peekMessage");
        try {
            EvermindMessage evermindMessage = this.findDurable(name).peekMessage(msgID);
            return evermindMessage;
        }
        finally {
            this.stopPhase("peekMessage", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(Object sessionID) throws JMSException {
        long tok = this.startPhase("commit");
        try {
            this.commit(this.m_ndStore.entrySet().iterator(), sessionID);
            this.commit(this.m_dStore.entrySet().iterator(), sessionID);
            this.commitFile(sessionID);
        }
        finally {
            this.stopPhase("commit", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(Object sessionID) throws JMSException {
        long tok = this.startPhase("rollback");
        try {
            this.rollback(this.m_ndStore.entrySet().iterator(), sessionID);
            this.rollback(this.m_dStore.entrySet().iterator(), sessionID);
            this.rollbackFile(sessionID);
        }
        finally {
            this.stopPhase("rollback", tok);
        }
    }

    public synchronized void addConsumer(ConsumerInfo cons) throws JMSException {
        this.addConsumer(cons, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeConsumer(ConsumerInfo cons) throws JMSException {
        long tok = this.startPhase("removeConsumer");
        try {
            Map m = this.findConsumer(cons);
            ServerStore store = (ServerStore)m.get(cons);
            if (cons.isDurable()) {
                int txn = store.getTransactionCount();
                if (txn > 0) {
                    JMSUtils.toJMSException(JMSServerMessages.getMessage("J2EE JMS-03100", this, cons));
                }
                store.rasa();
            }
            store.close();
            if (this.m_objs.containsKey(cons)) {
                this.getFile().removeObject((Integer)this.m_objs.get(cons), null);
                this.m_objs.remove(cons);
            }
            m.remove(cons);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("removeConsumer", ex);
        }
        finally {
            this.stopPhase("removeConsumer", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List listDurableConsumers() {
        long tok = this.startPhase("listDurableConsumers");
        try {
            ArrayList ret = new ArrayList();
            this.listConsumers(ret, this.m_dStore.keySet().iterator());
            ArrayList arrayList = ret;
            return arrayList;
        }
        finally {
            this.stopPhase("listDurableConsumers", tok);
        }
    }

    public synchronized boolean isActive() {
        return this.m_dStore.size() > 0 || this.m_ndStore.size() > 0;
    }

    private void loadMessages() throws Exception {
        Object obj;
        int i;
        HashMap<String, ConsumerInfo> consMap = new HashMap<String, ConsumerInfo>();
        Integer[] objs = this.getFile().scanObjects();
        if (objs == null) {
            return;
        }
        for (i = 0; i < objs.length; ++i) {
            obj = ServerFile.reconstruct(this.getFile().readObject(objs[i]));
            if (!(obj instanceof ConsumerInfo)) continue;
            ConsumerInfo cons = (ConsumerInfo)obj;
            if (!this.m_objs.containsKey(cons)) {
                this.addConsumer(cons, false);
                this.m_objs.put(cons, objs[i]);
                consMap.put(cons.getID(), cons);
                continue;
            }
            this.getFile().removeObject(objs[i], null);
        }
        for (i = 0; i < objs.length; ++i) {
            obj = ServerFile.reconstruct(this.getFile().readObject(objs[i]));
            if (obj instanceof ConsumerInfo) continue;
            EvermindMessage msg = (EvermindMessage)obj;
            String consID = msg.getConsumer();
            ConsumerInfo cons = (ConsumerInfo)consMap.get(consID);
            if (cons == null || !cons.isDurable() || !this.m_objs.containsKey(cons)) {
                JMSServerMessages.warningInvalidConsumer(this, consID, msg);
                this.getFile().removeObject(objs[i], null);
                continue;
            }
            ServerStore store = (ServerStore)this.m_dStore.get(cons);
            store.loadMessage(msg, objs[i]);
        }
        this.cleanMessages();
    }

    private ServerStore findDurable(String name) throws JMSException {
        ServerStore ret = null;
        String clientID = JMSUtils.fold(JMSUtils.getClientID());
        Iterator iter = this.m_dStore.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ConsumerInfo cons = (ConsumerInfo)entry.getKey();
            ServerStore store = (ServerStore)entry.getValue();
            if (!cons.getName().equals(name) || !clientID.equals(cons.getClientID())) continue;
            ret = store;
            break;
        }
        if (ret == null) {
            JMSUtils.toJMSException(JMSServerMessages.getMessage("J2EE JMS-02305", this, name, clientID));
        }
        return ret;
    }

    private Map findConsumer(ConsumerInfo cons) throws JMSException {
        Map m;
        Map map = this.m_ndStore.containsKey(cons) ? this.m_ndStore : (m = this.m_dStore.containsKey(cons) ? this.m_dStore : null);
        if (m == null) {
            JMSUtils.toJMSException(JMSServerMessages.getMessage("J2EE JMS-03102", this, cons));
        }
        return m;
    }

    private void cleanMessages() throws JMSException {
        this.cleanMessages(this.m_ndStore.entrySet().iterator());
        this.cleanMessages(this.m_dStore.entrySet().iterator());
    }

    private void cleanMessages(Iterator iter) throws JMSException {
        while (iter.hasNext()) {
            ServerStore store = (ServerStore)((Map.Entry)iter.next()).getValue();
            store.cleanMessages();
        }
    }

    private void enq(Iterator iter, String connID, Object sessionID, boolean keepState, EvermindMessage msg) throws JMSException {
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            ConsumerInfo cons = (ConsumerInfo)entry.getKey();
            if (cons.getConnID().equals(connID) && cons.isNoLocal() || cons.getSelector().isIdempotent() && !cons.getSelector().selects(msg)) continue;
            ServerStore store = (ServerStore)entry.getValue();
            EvermindMessage msgCopy = msg.cloneMessage();
            msgCopy.setConsumer(cons.getID());
            store.enq(connID, sessionID, keepState, msgCopy);
        }
    }

    private void expireMessages(Iterator iter) {
        while (iter.hasNext()) {
            ServerStore store = (ServerStore)((Map.Entry)iter.next()).getValue();
            store.expireMessages();
        }
    }

    private void commit(Iterator iter, Object sessionID) throws JMSException {
        while (iter.hasNext()) {
            ServerStore store = (ServerStore)((Map.Entry)iter.next()).getValue();
            store.commit(sessionID);
        }
    }

    private void rollback(Iterator iter, Object sessionID) throws JMSException {
        while (iter.hasNext()) {
            ServerStore store = (ServerStore)((Map.Entry)iter.next()).getValue();
            store.rollback(sessionID);
        }
    }

    private void close(Iterator iter, List exList) {
        while (iter.hasNext()) {
            ServerStore store = (ServerStore)((Map.Entry)iter.next()).getValue();
            try {
                store.close();
            }
            catch (Throwable ex) {
                exList.add(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConsumer(ConsumerInfo cons, boolean saveInfo) throws JMSException {
        long tok = this.startPhase("addConsumer");
        try {
            if (this.m_ndStore.containsKey(cons) || this.m_dStore.containsKey(cons) || this.m_objs.containsKey(cons)) {
                JMSUtils.toJMSException(JMSServerMessages.getMessage("J2EE JMS-01001", this, cons));
            }
            ServerStore store = this.makeStore(cons);
            if (!cons.isDurable()) {
                this.m_ndStore.put(cons, store);
            } else {
                this.m_dStore.put(cons, store);
            }
            store.addConsumer(cons);
            if (cons.isDurable() && saveInfo) {
                this.m_objs.put(cons, this.getFile().writeObject(cons.toBytes(), null));
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("addConsumer", ex);
        }
        finally {
            this.stopPhase("addConsumer", tok);
        }
    }

    private void listConsumers(List ret, Iterator iter) {
        while (iter.hasNext()) {
            ret.add(iter.next());
        }
    }
}

