/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.config;

import com.evermind.server.jms.config.JMSRouterConfig;
import com.evermind.server.jms.config.XMLConfigElement;
import com.evermind.server.jms.config.XMLJMSRouterJobConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLJMSRouterConfig
extends JMSRouterConfig
implements XMLConfigElement {
    protected static final String DEF_INDENT = "    ";
    private static final String JMSROUTER_ROOT_TAG = "jms-router";
    private static String s_CLASSNAME;
    private Logger m_tracer;
    private static final ToStringCmp s_cmp;

    public XMLJMSRouterConfig(Node baseNode) {
        String baseName;
        this.init();
        String string = baseName = baseNode != null ? baseNode.getNodeName() : null;
        if (JMSROUTER_ROOT_TAG.equals(baseName)) {
            List attrList = this.getAttrList();
            Iterator iter = attrList.iterator();
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                String attrVal = XMLJMSRouterConfig.getNodeAttribute(baseNode, attrName);
                if (attrVal == null) continue;
                this.setProperty(attrName, attrVal);
            }
            NodeList nodes = baseNode.getChildNodes();
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String name = node.getNodeName();
                    if (!name.equals("router-job")) continue;
                    this.parseJobNode(node);
                }
            }
        } else if (this.m_tracer.isLoggable(Level.FINE)) {
            this.m_tracer.log(Level.FINE, "Root tag does not match: " + baseName);
        }
    }

    public XMLJMSRouterConfig(Properties props) {
        this.init();
        this.setProperties(props);
    }

    public void writeXML(PrintWriter out, String indent) throws IOException {
        out.println(indent + "<" + JMSROUTER_ROOT_TAG + " " + this.getRootAttrsString() + ">");
        Collection jobsColl = this.getJobs().values();
        if (jobsColl != null) {
            Object[] jobs = this.getJobs().values().toArray();
            Arrays.sort(jobs, s_cmp);
            for (int i = 0; i < jobs.length; ++i) {
                ((XMLJMSRouterJobConfig)jobs[i]).writeXML(out, indent + DEF_INDENT);
            }
        }
        out.println(indent + "</" + JMSROUTER_ROOT_TAG + ">");
    }

    public static String getRootElementTag() {
        return JMSROUTER_ROOT_TAG;
    }

    protected void parseJobNode(Node node) {
        this.init();
        XMLJMSRouterJobConfig jc = new XMLJMSRouterJobConfig(node);
        this.addJob(jc);
    }

    protected static String getNodeAttribute(Node node, String name) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return null;
        }
        Node namedNode = map.getNamedItem(name);
        if (namedNode == null) {
            return null;
        }
        return namedNode.getNodeValue();
    }

    protected void init() {
        this.m_tracer = Logger.getLogger(XMLJMSRouterConfig.class.getName());
    }

    static {
        s_cmp = new ToStringCmp();
    }

    private static final class ToStringCmp
    implements Comparator {
        ToStringCmp() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

