/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.BooleanExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IStringExpression;
import com.evermind.server.jms.filter.QuerySemanticException;
import com.evermind.server.jms.filter.QueryTypeException;
import java.util.Vector;
import javax.jms.Message;

class LikeExpression
extends BooleanExpression {
    private boolean m_invert;
    private char m_escapeChar;
    private boolean m_useEscape;
    private String m_pattern;
    private IStringExpression m_strExpr;
    private MatchToken[] m_matchArr;

    LikeExpression(IStringExpression expr, boolean invert, String pattern, char escapeChar) throws QuerySemanticException {
        super(expr.toString() + (invert ? " not like " : " like ") + '\'' + pattern + "' escape '" + escapeChar + '\'');
        this.m_invert = invert;
        this.m_pattern = pattern;
        this.m_useEscape = true;
        this.m_escapeChar = escapeChar;
        this.m_strExpr = expr;
        this.filterPattern();
    }

    LikeExpression(IStringExpression expr, boolean invert, String pattern) throws QuerySemanticException {
        super(expr.toString() + (invert ? "  not like '" : " like '") + pattern + '\'', expr);
        this.m_invert = invert;
        this.m_pattern = pattern;
        this.m_useEscape = false;
        this.m_strExpr = expr;
        this.filterPattern();
    }

    public void eval(Message m) throws QueryTypeException {
        this.m_val = false;
        if (this.m_strExpr.isNull()) {
            this.m_null = true;
            return;
        }
        this.m_null = false;
        String exprVal = this.m_strExpr.getStringVal();
        if (exprVal == null) {
            this.m_null = true;
            return;
        }
        for (int i = 1; i < this.m_matchArr.length; ++i) {
            this.m_matchArr[i].m_inState = false;
        }
        this.m_matchArr[0].m_inState = true;
        int exprLen = exprVal.length();
        for (int exprIndex = 0; exprIndex < exprLen && this.setStates(); ++exprIndex) {
            char exprChar = exprVal.charAt(exprIndex);
            for (int ci = this.m_matchArr.length - 1; ci >= 0; --ci) {
                MatchToken curState = this.m_matchArr[ci];
                if (!curState.m_inState || !this.processState(curState, exprChar, exprLen, ci, exprIndex)) continue;
                this.m_val = !this.m_invert;
                return;
            }
        }
        int last = this.m_matchArr.length - 1;
        this.m_val = this.m_matchArr[last].m_inState && this.m_matchArr[last].m_isAll ? !this.m_invert : this.m_invert;
    }

    private boolean processState(MatchToken curState, char exprChar, int exprLen, int stateIndex, int exprIndex) {
        if (!curState.m_isStuck) {
            curState.m_inState = false;
        }
        int lastState = this.m_matchArr.length - 1;
        int lastInput = exprLen - 1;
        if (curState.m_isAll) {
            if (stateIndex == lastState) {
                return true;
            }
            MatchToken nextState = this.m_matchArr[stateIndex + 1];
            nextState.m_inState = true;
            nextState.m_isStuck = true;
            if (nextState.m_isAny || nextState.m_matchChar == exprChar) {
                if (stateIndex + 1 == lastState) {
                    if (exprIndex == lastInput) {
                        return true;
                    }
                } else {
                    MatchToken nextNextState = this.m_matchArr[stateIndex + 2];
                    nextNextState.m_inState = true;
                }
            }
            return false;
        }
        if (curState.m_isAny || curState.m_matchChar == exprChar) {
            if (stateIndex == lastState) {
                return exprIndex == lastInput;
            }
            MatchToken nextState = this.m_matchArr[stateIndex + 1];
            nextState.m_inState = true;
            return false;
        }
        return false;
    }

    public boolean equals(Object expr) {
        if (expr instanceof LikeExpression) {
            LikeExpression lexpr = (LikeExpression)expr;
            return this.m_strExpr.equals(lexpr.m_strExpr) && this.m_invert == lexpr.m_invert && this.m_escapeChar == lexpr.m_escapeChar && this.m_pattern.equals(lexpr.m_pattern) && this.m_useEscape == lexpr.m_useEscape;
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.m_strExpr = (IStringExpression)app.apply(this.m_strExpr);
        return app.apply(this);
    }

    private boolean setStates() {
        for (int i = 0; i < this.m_matchArr.length; ++i) {
            if (!this.m_matchArr[i].m_inState) continue;
            return true;
        }
        return false;
    }

    private void filterPattern() throws QuerySemanticException {
        Vector<MatchToken> tmp = new Vector<MatchToken>();
        int patLen = this.m_pattern.length();
        if (patLen == 0) {
            throw new QuerySemanticException("the match pattern must have at least one character");
        }
        for (int patIndex = 0; patIndex < patLen; ++patIndex) {
            char patChar = this.m_pattern.charAt(patIndex);
            if (this.m_useEscape && patChar == this.m_escapeChar) {
                if (patIndex < patLen) {
                    if ((patChar = this.m_pattern.charAt(++patIndex)) == '_' || patChar == '%') {
                        tmp.addElement(new MatchToken(patChar));
                        continue;
                    }
                    throw new QuerySemanticException("'_' or '%' must follow escape character in pattern for like expression");
                }
                throw new QuerySemanticException("an escape character cannot end the match pattern");
            }
            if (patChar == '_') {
                tmp.addElement(new MatchToken(true));
                continue;
            }
            if (patChar == '%') {
                int sz = tmp.size();
                boolean doit = true;
                if (sz > 0) {
                    MatchToken last = (MatchToken)tmp.elementAt(sz - 1);
                    if (last.m_isAll) {
                        doit = false;
                    }
                }
                if (!doit) continue;
                tmp.addElement(new MatchToken(false));
                continue;
            }
            tmp.addElement(new MatchToken(patChar));
        }
        int sz = tmp.size();
        this.m_matchArr = new MatchToken[sz];
        for (int i = 0; i < sz; ++i) {
            this.m_matchArr[i] = (MatchToken)tmp.elementAt(i);
        }
    }

    class MatchToken {
        char m_matchChar;
        boolean m_isAny;
        boolean m_isAll;
        boolean m_inState;
        boolean m_isStuck;

        MatchToken(char matchChar) {
            this.m_matchChar = matchChar;
        }

        MatchToken(boolean isAny) {
            this.m_isAny = isAny;
            this.m_isAll = !isAny;
        }
    }
}

