/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.BooleanExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IBooleanExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import javax.jms.Message;

class OrExpression
extends BooleanExpression {
    OrExpression(IBooleanExpression leftExpr, IBooleanExpression rightExpr) {
        super("(" + leftExpr.toString() + " or " + rightExpr.toString() + ")", leftExpr, rightExpr);
    }

    public void eval(Message m) throws QueryTypeException {
        this.m_null = false;
        this.m_val = false;
        if (this.m_leftExpr.isNull() && this.m_rightExpr.isNull()) {
            this.m_null = true;
        } else if (this.m_leftExpr.isNull()) {
            if (((IBooleanExpression)this.m_rightExpr).getBooleanVal()) {
                this.m_val = true;
            } else {
                this.m_null = true;
            }
        } else if (this.m_rightExpr.isNull()) {
            if (((IBooleanExpression)this.m_leftExpr).getBooleanVal()) {
                this.m_val = true;
            } else {
                this.m_null = true;
            }
        } else {
            this.m_val = ((IBooleanExpression)this.m_leftExpr).getBooleanVal() || ((IBooleanExpression)this.m_rightExpr).getBooleanVal();
        }
    }

    public boolean equals(Object expr) {
        if (expr instanceof OrExpression) {
            return this.m_leftExpr.equals(((OrExpression)expr).m_leftExpr) && this.m_rightExpr.equals(((OrExpression)expr).m_rightExpr);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.m_leftExpr = (IBooleanExpression)this.m_leftExpr.depthFirstApply(app);
        this.m_rightExpr = (IBooleanExpression)this.m_rightExpr.depthFirstApply(app);
        return app.apply(this);
    }
}

