/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindQueue;
import com.evermind.server.multicastjms.EvermindQueueSession;
import com.evermind.server.multicastjms.MessageSelector;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class EvermindQueueBrowser
implements QueueBrowser {
    protected EvermindQueueSession session;
    protected Queue queue;
    protected MessageSelector selector;

    public EvermindQueueBrowser(EvermindQueueSession session, EvermindQueue queue, MessageSelector selector) {
        this.session = session;
        this.queue = queue;
        this.selector = selector;
    }

    public String getMessageSelector() {
        if (this.selector == null) {
            return null;
        }
        return this.selector.getCondition();
    }

    public Enumeration getEnumeration() throws JMSException {
        if (!this.session.connection.isStarted()) {
            throw new JMSException("QueueConnection not started");
        }
        if (this.session == null) {
            throw new JMSException("Browser has been closed");
        }
        return this.session.connection.getQueueBrowserEnumeration(this);
    }

    public void close() {
        this.session = null;
    }

    public Queue getQueue() {
        return this.queue;
    }
}

