/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.io.IOUtils;
import com.evermind.server.multicastjms.EvermindMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;

public class EvermindStreamMessage
extends EvermindMessage
implements StreamMessage {
    protected byte[] data;
    protected int pos;
    protected int length;
    boolean inReadMode;

    public EvermindStreamMessage(boolean writeMode) {
        if (writeMode) {
            this.data = new byte[40];
        } else {
            this.inReadMode = true;
        }
    }

    public int getTypeID() {
        return 3;
    }

    public void clearBody() {
        this.pos = 0;
        this.length = 0;
        this.inReadMode = false;
    }

    public void read(InputStream in, DataInputStream dataIn) throws IOException {
        this.inReadMode = true;
        this.length = dataIn.readInt();
        this.data = new byte[this.length];
        in.read(this.data);
    }

    public void write(OutputStream out, DataOutputStream dataOut) throws IOException {
        dataOut.writeInt(this.length);
        out.write(this.data, 0, this.length);
    }

    public void writeByte(byte value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length + 1 >= this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = 33;
        this.data[this.length++] = value;
    }

    public byte readByte() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        if (this.data[this.pos] == 33) {
            ++this.pos;
            if (this.pos >= this.length) {
                throw new MessageEOFException("End of message reached");
            }
            return this.data[this.pos++];
        }
        if (this.data[this.pos] == 37) {
            return Byte.parseByte(this.readString());
        }
        throw new JMSException("Invalid type");
    }

    public void writeBoolean(boolean value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length + 1 >= this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = 38;
        this.data[this.length++] = value ? (byte)1 : 0;
    }

    public boolean readBoolean() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        if (this.data[this.pos] == 38) {
            ++this.pos;
            if (this.pos >= this.length) {
                throw new MessageEOFException("End of message reached");
            }
            return this.data[this.pos++] == 1;
        }
        if (this.data[this.pos] == 37) {
            return Boolean.getBoolean(this.readString());
        }
        throw new JMSException("Invalid type");
    }

    public short readShort() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        switch (this.data[this.pos]) {
            case 39: {
                ++this.pos;
                if (this.pos + 1 >= this.length) {
                    throw new MessageEOFException("End of message reached");
                }
                return (short)((((char)this.data[this.pos++] & 0xFF) << 8) + ((char)this.data[this.pos++] & 0xFF));
            }
            case 33: {
                return this.readByte();
            }
            case 37: {
                return Short.parseShort(this.readString());
            }
        }
        throw new JMSException("Invalid type");
    }

    public void writeShort(short value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length + 2 >= this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = 39;
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public int readInt() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        switch (this.data[this.pos]) {
            case 32: {
                ++this.pos;
                if (this.pos + 3 >= this.length) {
                    throw new MessageEOFException("End of message reached");
                }
                return (((char)this.data[this.pos++] & 0xFF) << 24) + (((char)this.data[this.pos++] & 0xFF) << 16) + (((char)this.data[this.pos++] & 0xFF) << 8) + ((char)this.data[this.pos++] & 0xFF);
            }
            case 33: {
                return this.readByte();
            }
            case 39: {
                return this.readShort();
            }
            case 34: {
                return this.readChar();
            }
            case 37: {
                return Integer.parseInt(this.readString());
            }
        }
        throw new JMSException("Invalid type");
    }

    public void writeInt(int value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length + 4 >= this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = 32;
        this.data[this.length++] = (byte)(value >>> 24);
        this.data[this.length++] = (byte)(value >>> 16);
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public long readLong() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        switch (this.data[this.pos]) {
            case 40: {
                ++this.pos;
                if (this.pos + 7 >= this.length) {
                    throw new MessageEOFException("End of message reached");
                }
                return (((long)((char)this.data[this.pos++]) & 0xFFL) << 56) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 48) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 40) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 32) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 24) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 16) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 8) + ((long)((char)this.data[this.pos++]) & 0xFFL);
            }
            case 32: {
                return this.readInt();
            }
            case 33: {
                return this.readByte();
            }
            case 39: {
                return this.readShort();
            }
            case 34: {
                return this.readChar();
            }
            case 37: {
                return Long.parseLong(this.readString());
            }
        }
        throw new JMSException("Invalid type");
    }

    public void writeLong(long value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length + 8 >= this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = 40;
        this.data[this.length++] = (byte)(value >>> 56);
        this.data[this.length++] = (byte)(value >>> 48);
        this.data[this.length++] = (byte)(value >>> 40);
        this.data[this.length++] = (byte)(value >>> 32);
        this.data[this.length++] = (byte)(value >>> 24);
        this.data[this.length++] = (byte)(value >>> 16);
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public double readDouble() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        switch (this.data[this.pos]) {
            case 36: {
                ++this.pos;
                if (this.pos + 7 >= this.length) {
                    throw new MessageEOFException("End of message reached");
                }
                return (((long)((char)this.data[this.pos++]) & 0xFFL) << 56) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 48) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 40) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 32) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 24) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 16) + (((long)((char)this.data[this.pos++]) & 0xFFL) << 8) + ((long)((char)this.data[this.pos++]) & 0xFFL);
            }
            case 35: {
                return this.readFloat();
            }
            case 37: {
                return Double.parseDouble(this.readString());
            }
        }
        throw new JMSException("Invalid type");
    }

    public void writeDouble(double doubleValue) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length + 8 >= this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        long value = Double.doubleToLongBits(doubleValue);
        this.data[this.length++] = 36;
        this.data[this.length++] = (byte)(value >>> 56);
        this.data[this.length++] = (byte)(value >>> 48);
        this.data[this.length++] = (byte)(value >>> 40);
        this.data[this.length++] = (byte)(value >>> 32);
        this.data[this.length++] = (byte)(value >>> 24);
        this.data[this.length++] = (byte)(value >>> 16);
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeBytes(byte[] value) {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) {
        if (this.length >= this.data.length - length - 5) {
            int newLength = this.data.length * 2;
            while (this.length >= newLength - length) {
                newLength *= 2;
            }
            byte[] newData = new byte[newLength];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[length++] = 41;
        this.data[length++] = (byte)(length >>> 24);
        this.data[length++] = (byte)(length >>> 16);
        this.data[length++] = (byte)(length >>> 8);
        this.data[length++] = (byte)length;
        System.arraycopy(value, offset, this.data, this.length, length);
        this.length += length;
    }

    public String readString() throws JMSException, MessageNotReadableException, MessageEOFException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        if (this.data[this.pos] == 37) {
            long encoded;
            try {
                encoded = IOUtils.readCompressedInt(this.data, this.pos);
            }
            catch (IOException e) {
                throw new JMSException("Message format error, premature end of content");
            }
            int utfLength = (int)encoded;
            this.pos = (int)(encoded >>> 32);
            char[] string = new char[utfLength];
            int count = 0;
            int stringLength = 0;
            block7: while (count < utfLength) {
                int c = (char)this.data[this.pos++] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        string[stringLength++] = (char)c;
                        continue block7;
                    }
                    case 12: 
                    case 13: {
                        int char2;
                        if ((count += 2) > utfLength) {
                            throw new JMSException("UTFDataFormatException");
                        }
                        if (((char2 = (char)this.data[this.pos++] & 0xFF) & 0xC0) != 128) {
                            throw new JMSException("UTFDataFormatException");
                        }
                        string[stringLength++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block7;
                    }
                    case 14: {
                        if ((count += 3) > utfLength) {
                            throw new JMSException("UTFDataFormatException");
                        }
                        int char2 = (char)this.data[this.pos++] & 0xFF;
                        int char3 = (char)this.data[this.pos++] & 0xFF;
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new JMSException("UTFDataFormatException");
                        }
                        string[stringLength++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block7;
                    }
                }
                throw new JMSException("UTFDataFormatException");
            }
            return new String(string, 0, stringLength);
        }
        if (this.data[this.pos] == 41) {
            throw new JMSException("Invalid type");
        }
        return this.readObject().toString();
    }

    public Object readObject() throws JMSException, MessageNotReadableException, MessageEOFException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        switch (this.data[this.length]) {
            case 38: {
                return new Boolean(this.readBoolean());
            }
            case 33: {
                return new Byte(this.readByte());
            }
            case 39: {
                return new Short(this.readShort());
            }
            case 34: {
                return new Character(this.readChar());
            }
            case 32: {
                return new Integer(this.readInt());
            }
            case 40: {
                return new Long(this.readLong());
            }
            case 35: {
                return new Float(this.readFloat());
            }
            case 36: {
                return new Double(this.readDouble());
            }
            case 37: {
                return this.readString();
            }
            case 41: {
                if (this.pos + 4 >= this.length) {
                    throw new MessageEOFException("End of message reached");
                }
                int arrayLength = (((char)this.data[this.pos + 1] & 0xFF) << 24) + (((char)this.data[this.pos + 2] & 0xFF) << 16) + (((char)this.data[this.pos + 3] & 0xFF) << 8) + ((char)this.data[this.pos + 4] & 0xFF);
                byte[] data = new byte[arrayLength];
                this.readBytes(data);
                return data;
            }
        }
        throw new JMSException("Corrupted message");
    }

    public int readBytes(byte[] value) throws MessageNotReadableException, JMSException {
        return this.readBytes(value, 0, value.length);
    }

    public int readBytes(byte[] value, int start, int length) throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length - length - 5) {
            throw new MessageEOFException("End of message reached");
        }
        if (this.data[this.pos] != 41) {
            throw new JMSException("Invalid type");
        }
        if ((((char)this.data[this.pos + 1] & 0xFF) << 24) + (((char)this.data[this.pos + 2] & 0xFF) << 16) + (((char)this.data[this.pos + 3] & 0xFF) << 8) + ((char)this.data[this.pos + 4] & 0xFF) != length) {
            throw new IllegalArgumentException("ArrayLength mismatch");
        }
        this.pos += 5;
        System.arraycopy(this.data, this.pos, value, start, length);
        this.pos += length;
        return length;
    }

    public int readBytes(byte[] value, int length) throws MessageNotReadableException, JMSException {
        return this.readBytes(value, 0, length);
    }

    public float readFloat() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        switch (this.data[this.pos]) {
            case 35: {
                ++this.pos;
                if (this.pos + 3 >= this.length) {
                    throw new MessageEOFException("End of message reached");
                }
                return Float.intBitsToFloat((((char)this.data[this.pos++] & 0xFF) << 24) + (((char)this.data[this.pos++] & 0xFF) << 16) + (((char)this.data[this.pos++] & 0xFF) << 8) + ((char)this.data[this.pos++] & 0xFF));
            }
            case 37: {
                return Float.parseFloat(this.readString());
            }
        }
        throw new JMSException("Invalid type");
    }

    public void writeFloat(float floatValue) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length + 4 >= this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        int value = Float.floatToIntBits(floatValue);
        this.data[this.length++] = 35;
        this.data[this.length++] = (byte)(value >>> 24);
        this.data[this.length++] = (byte)(value >>> 16);
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public char readChar() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        if (this.data[this.pos] == 34) {
            ++this.pos;
            return (char)((((char)this.data[this.pos++] & 0xFF) << 8) + ((char)this.data[this.pos++] & 0xFF));
        }
        if (this.data[this.pos] == 37) {
            return (char)Integer.parseInt(this.readString());
        }
        throw new JMSException("Invalid type");
    }

    public void writeChar(char value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length + 2 >= this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = 34;
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeString(String string) throws MessageNotWriteableException, JMSException {
        char c;
        int i;
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        int stringLength = string.length();
        int utfLength = 0;
        for (i = 0; i < stringLength; ++i) {
            c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfLength;
                continue;
            }
            if (c > '\u07ff') {
                utfLength += 3;
                continue;
            }
            utfLength += 2;
        }
        if (utfLength < 0) {
            throw new JMSException("Too long String");
        }
        while (this.length + 6 + stringLength > this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = 37;
        this.length = IOUtils.writeCompressedInt(this.data, this.length, utfLength);
        for (i = 0; i < stringLength; ++i) {
            c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.data[this.length++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.data[this.length++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.data[this.length++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.data[this.length++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.data[this.length++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.data[this.length++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public void writeObject(Object object) throws MessageNotWriteableException, JMSException {
        if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else {
            throw new MessageFormatException("Invalid type");
        }
    }

    public void reset() {
        this.inReadMode = true;
        this.pos = 0;
    }

    public EvermindMessage cloneMessage() {
        return this.clone(new EvermindStreamMessage(false));
    }

    public EvermindStreamMessage clone(EvermindStreamMessage other) {
        other.data = this.data;
        other.pos = 0;
        other.length = this.length;
        other.inReadMode = true;
        return (EvermindStreamMessage)super.clone(other);
    }
}

