/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindMessageConsumer;
import com.evermind.server.multicastjms.EvermindTemporaryQueue;
import com.evermind.server.multicastjms.MessageSelector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;

public class EvermindTemporaryQueueReceiver
extends EvermindMessageConsumer
implements QueueReceiver {
    protected MessageSelector selector;
    protected EvermindTemporaryQueue queue;

    public EvermindTemporaryQueueReceiver(EvermindTemporaryQueue queue, MessageSelector selector) {
        super(selector == null ? null : selector.getCondition());
        this.selector = selector;
        this.queue = queue;
    }

    public Message receive() throws JMSException {
        EvermindMessage message = this.queue.receive(this.selector);
        if (this.messageListener != null) {
            try {
                this.messageListener.onMessage((Message)message);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return message;
    }

    public Message receive(long timeout) throws JMSException {
        EvermindMessage message = this.queue.receive(this.selector, timeout);
        if (message != null && this.messageListener != null) {
            try {
                this.messageListener.onMessage((Message)message);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        EvermindMessage message = this.queue.receiveNoWait(this.selector);
        if (message != null && this.messageListener != null) {
            try {
                this.messageListener.onMessage((Message)message);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return message;
    }

    public Queue getQueue() {
        return this.queue;
    }
}

