/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.io.IOUtils;
import com.evermind.server.rmi.RMIClient;
import com.evermind.server.rmi.RMIOutputStream;
import com.evermind.server.rmi.RMIProtocol;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.rmi.RMIMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.rmi.RmiCommandSource;
import oracle.oc4j.rmi.RmiTransport;

public abstract class RMIConnection
implements Runnable {
    public static final int PROTOCOL_CLUSTERAVAILABILITYLOOKUP = 228;
    private static Logger m_logger = TraceLogger.getLogger(RMIConnection.class);
    static final int MESSAGE_LOOKUP_OBJECT = 3;
    static final int MESSAGE_METHOD_INVOCATION = 4;
    static final int MESSAGE_RELEASE_OBJECT = 8;
    static final int MESSAGE_BIND_OBJECT = 14;
    static final int MESSAGE_UNBIND_OBJECT = 17;
    static final int MESSAGE_LIST_CONTEXT = 30;
    static final int MESSAGE_GET_CLASSDATA = 40;
    static final int[] ORMI_REQUESTS = new int[]{3, 4, 8, 14, 17, 30, 40};
    static final int MESSAGE_LOOKUP_RESPONSE = 9;
    static final int MESSAGE_INVOCATION_RESPONSE = 10;
    static final int MESSAGE_BIND_OBJECT_RESPONSE = 15;
    static final int MESSAGE_UNBIND_OBJECT_RESPONSE = 18;
    static final int MESSAGE_LIST_CONTEXT_RESPONSE = 39;
    static final int MESSAGE_GET_CLASSDATA_RESPONSE = 41;
    static final int MESSAGE_RELEASE_OBJECT_RESPONSE = 52;
    static final int MESSAGE_FAILOVER = 53;
    static final int[] ORMI_RESPONSES = new int[]{9, 10, 15, 18, 39, 41, 52, 53};
    static final int MESSAGE_DISCONNECT = 22;
    public static final int MESSAGE_SET_DOMAIN = 25;
    static final int MESSAGE_TRANSACTION_COMMAND = 26;
    static final int[] ORMI_COMMANDS = new int[]{22, 25, 26};
    static final int MESSAGE_OBJECT_NOT_FOUND = 1;
    static final int MESSAGE_OBJECT_FOUND = 2;
    static final int MESSAGE_INVOCATION_OK = 5;
    static final int MESSAGE_EXCEPTION = 7;
    static final int MESSAGE_INVALID_LOGIN = 11;
    public static final int MESSAGE_LOGIN_OK = 12;
    static final int MESSAGE_BIND_SUCCEEDED = 16;
    static final int MESSAGE_UNBIND_SUCCEEDED = 19;
    static final int MESSAGE_BAD_IP = 20;
    static final int MESSAGE_NOT_ALLOWED = 23;
    static final int MESSAGE_LIST_OK = 34;
    static final int MESSAGE_FORBIDDEN = 35;
    private RMIClient server;
    private boolean alive = false;
    private RMIProtocol m_protocol;
    public static final String USERNAME = "__XYZ__";
    public static final String PASSWORD = "___ABC___";
    public static final String DOMAINNAME = "DomainName";

    protected RMIConnection(RMIClient server) {
        this.server = server;
        this.m_protocol = new RMIProtocol(server.getInterceptorManager());
    }

    protected RMIConnection(RMIConnection other) {
        this(other.server);
    }

    boolean isAlive() {
        return this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        try {
            try {
                thread.setName(this.getConnectionThreadName(thread));
                this.listenForOrmiCommands();
            }
            catch (Throwable e) {
                m_logger.log(Level.FINE, "Got uncaught Throwable. : ", e);
                RMIMessages.finerThrowable("Uncaught exception RMIConnectionThread", e);
                Object var5_4 = null;
                m_logger.log(Level.FINE, "RMIConnectionThread Done ", this.getTransport().getDisconnectMessage());
                thread.setName(threadName);
            }
            Object var5_3 = null;
            m_logger.log(Level.FINE, "RMIConnectionThread Done ", this.getTransport().getDisconnectMessage());
            thread.setName(threadName);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            m_logger.log(Level.FINE, "RMIConnectionThread Done ", this.getTransport().getDisconnectMessage());
            thread.setName(threadName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listenForOrmiCommands() {
        if (!this.getTransport().isConnected()) {
            m_logger.log(Level.FINE, "The transport object is not connected. exit.");
            return;
        }
        this.initializeConnectionThread();
        try {
            if (!this.mayStartConnectionThread()) {
                return;
            }
            this.alive = true;
            while (this.getTransport().isConnected()) {
                this.handleCommand(this.receiveInputMessage());
            }
        }
        catch (IOException e) {
            m_logger.log(Level.FINE, "Got IOException. : ", e);
            this.disconnect(e.getMessage() == null ? "RMIConnection Disconnected" : e.getMessage(), true);
            RMIMessages.finerThrowable(e);
        }
        catch (RuntimeException t) {
            this.disconnect(t.getMessage() == null ? "RMIConnection Disconnected" : t.getMessage(), true);
            RMIMessages.finerThrowable(t);
            m_logger.log(Level.FINE, "Got RuntimeException. : ", t);
        }
        finally {
            this.alive = false;
            CommonThreadState.getCurrent().reset();
        }
    }

    protected abstract RmiCommandSource.MessageIn receiveInputMessage() throws IOException;

    private void handleCommand(RmiCommandSource.MessageIn messageIn) throws IOException {
        ClassLoaderObjectInputStream in = messageIn.getInputStream();
        try {
            int command = this.readCommand(in);
            if (command >= 0) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "received command {0}", new Integer(command));
                }
                this.processReceivedCommand(command, in);
            }
        }
        catch (InterruptedIOException e) {
            this.handleInterrupt();
        }
    }

    private int readCommand(ClassLoaderObjectInputStream in) throws IOException {
        try {
            int command = in.read();
            if (command < 0 && this.getTransport().isConnected()) {
                throw new EOFException("The connection reaches EOF.");
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Read command: {0}", new Integer(command));
            }
            return command;
        }
        catch (NullPointerException e) {
            if (this.getTransport().isConnected()) {
                return -1;
            }
            throw e;
        }
    }

    public synchronized void handleInterrupt() {
        if (this.isDisconnectOnInterrupt()) {
            this.disconnect("Timed out", false);
        }
    }

    protected abstract RmiTransport getTransport();

    protected abstract boolean isDisconnectOnInterrupt();

    public abstract void processReceivedCommand(int var1, ClassLoaderObjectInputStream var2) throws IOException;

    void handleOrmiCommand(int command, ClassLoaderObjectInputStream in) throws IOException {
        switch (command) {
            case 25: {
                this.receiveDomainSetting(in.readUTF());
                break;
            }
            case 22: {
                this.receiveDisconnect(IOUtils.readUTF(in));
                break;
            }
            case 26: {
                this.handleBackwardsCompatabilityForOldTxPropagation(in);
                break;
            }
            default: {
                throw new IOException("Unknown command: " + command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(String message, boolean setErrorOnCall) {
        RMIConnection rMIConnection = this;
        synchronized (rMIConnection) {
            if (this.getTransport().isConnected()) {
                this.writeDisconnectMessage(message);
            }
            this.receiveDisconnect(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveDisconnect(String message) {
        RMIConnection rMIConnection = this;
        synchronized (rMIConnection) {
            this.getTransport().closeDataStreams();
            this.resetState(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDisconnectMessage(String message) {
        m_logger.log(Level.FINER, "Preparing to send disconnect message: {0}", message);
        OutputStream writeOut = this.getTransport().getObjectOutputStream();
        if (writeOut == null) {
            writeOut = this.getTransport().getOutputStream();
        }
        if (writeOut == null || !this.getTransport().isConnected()) {
            return;
        }
        OutputStream outputStream = writeOut;
        synchronized (outputStream) {
            try {
                IOUtils.writeCompressedInt(writeOut, 22);
                IOUtils.writeUTF(writeOut, message);
                writeOut.flush();
            }
            catch (IOException e) {
                m_logger.log(Level.FINE, "Unable to send disconnect message: IOException {0}", e.getMessage());
            }
        }
    }

    protected void resetState(String disconnectMessage) {
        this.getTransport().disconnect(disconnectMessage);
    }

    public RMIClient getServer() {
        return this.server;
    }

    protected boolean isCommand(int command) {
        for (int i = 0; i < ORMI_COMMANDS.length; ++i) {
            if (command != ORMI_COMMANDS[i]) continue;
            return true;
        }
        return false;
    }

    protected void writeCommandByte(ObjectOutputStream out, int command) throws IOException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "[{0}] Write command: {1}", new Object[]{Thread.currentThread().getName(), new Integer(command)});
        }
        out.write(command);
    }

    protected int readStatus(int command, ObjectInputStream in) throws IOException {
        int status = this.getProtocol().readStatus(command, in);
        if (status < 0) {
            throw new EOFException();
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "Read status: {0}", new Integer(status));
        }
        return status;
    }

    private void handleBackwardsCompatabilityForOldTxPropagation(ClassLoaderObjectInputStream in) throws IOException {
        this.readStatus(26, in);
        if (in.readBoolean()) {
            in.readLong();
            long dataLength = in.readShort();
            long bytesSkipped = in.skip(dataLength);
            if (bytesSkipped != dataLength) {
                throw new IOException("Exception occurred stripping old tx data for backwards compatability.");
            }
            in.readBoolean();
            in.readBoolean();
        }
    }

    public static boolean isMethodInvocationCommand(int command) {
        return command == 4 || command == 10;
    }

    public static boolean isMethodLookupBindOrInvocationCommand(int command) {
        return 3 == command || 4 == command || 14 == command;
    }

    protected abstract void initializeConnectionThread();

    protected abstract String getConnectionThreadName(Thread var1);

    protected abstract boolean mayStartConnectionThread() throws IOException;

    protected RMIProtocol getProtocol() {
        return this.m_protocol;
    }

    protected abstract void receiveDomainSetting(String var1);

    protected RMIOutputStream getOut() {
        return this.getTransport().getObjectOutputStream();
    }
}

